/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.parts;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.BranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.ui.mergequest.policies.GraphXYLayoutEditPolicy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

public class GraphEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    private IBranchGraph graph;

    public GraphEditPart(IBranchGraph graph) {
        this.graph = graph;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.graph.addPropertyListener((PropertyChangeListener)this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.graph.removePropertyListener((PropertyChangeListener)this);
            super.deactivate();
        }
    }

    protected IFigure createFigure() {
        FreeformLayer figure = new FreeformLayer();
        figure.setBorder((Border)new MarginBorder(10));
        figure.setLayoutManager((LayoutManager)new FreeformLayout());
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        BendpointConnectionRouter router = new BendpointConnectionRouter();
        connLayer.setConnectionRouter((ConnectionRouter)router);
        return figure;
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean value = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (value != null && value.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((value = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && value.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((value = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && value.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() > 0) {
                return new CompoundSnapToHelper(snapStrategies.toArray(new SnapToHelper[snapStrategies.size()]));
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
        }
        return super.getAdapter(key);
    }

    protected List<Branch> getModelChildren() {
        BranchGraph graph = (BranchGraph)this.getModel();
        return Arrays.asList(graph.getBranches());
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new GraphXYLayoutEditPolicy(this.graph));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("ELEMENT_ADDED".equals(property) || "ELEMENT_REMOVED".equals(property)) {
            this.refreshChildren();
        }
    }
}

