/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.figures;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class MappingConnectionAnchor
extends AbstractConnectionAnchor {
    private int index = 0;
    private int style = 0;
    private int xOffset = 0;
    private int yOffset = 0;

    public MappingConnectionAnchor(IFigure owner, int index, int style) {
        super(owner);
        this.style = style;
        this.index = index;
    }

    public boolean isTop() {
        return (0x80 & this.style) != 0;
    }

    public boolean isBottom() {
        return (0x400 & this.style) != 0;
    }

    public boolean isLeft() {
        return (0x4000 & this.style) != 0;
    }

    public boolean isRight() {
        return (0x20000 & this.style) != 0;
    }

    public int getIndex() {
        return this.index;
    }

    public MappingConnectionAnchor setXOffset(int x) {
        this.xOffset = x;
        this.fireAnchorMoved();
        return this;
    }

    public MappingConnectionAnchor setYOffset(int y) {
        this.yOffset = y;
        this.fireAnchorMoved();
        return this;
    }

    public Point getReferencePoint() {
        return this.getLocation(null);
    }

    public Point getLocation(Point reference) {
        IFigure owner = this.getOwner();
        Rectangle r = owner.getBounds();
        int y = r.y + this.yOffset;
        int x = r.x + this.xOffset;
        PrecisionPoint p = new PrecisionPoint(x, y);
        owner.translateToAbsolute((Translatable)p);
        return p;
    }
}

