/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.editor.outline;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.branches.EditBranchAction;
import com.perforce.team.ui.mergequest.editor.IBranchGraphPage;
import com.perforce.team.ui.mergequest.editor.outline.BranchGraphOutlineSorter;
import com.perforce.team.ui.mergequest.editor.outline.BranchMappingContentProvider;
import com.perforce.team.ui.mergequest.editor.outline.BranchMappingLabelProvider;
import com.perforce.team.ui.mergequest.editor.outline.MappingProxy;
import com.perforce.team.ui.mergequest.editor.outline.MappingProxySelectionProvider;
import com.perforce.team.ui.mergequest.editor.outline.Messages;
import com.perforce.team.ui.mergequest.editor.outline.SelectionSynchronizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class BranchGraphOutlinePage
extends Page
implements IContentOutlinePage,
IPageChangedListener {
    private TreeViewer viewer;
    private SelectionSynchronizer synchronizer;
    private ListenerList listeners;
    private IP4Connection connection;
    private IPageChangeProvider pageProvider;
    private IBranchGraph graph;
    private PropertyChangeListener builderListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if ("sourceMappings".equals(property)) {
                Mapping mapping = (Mapping)evt.getNewValue();
                if (mapping == null) {
                    mapping = (Mapping)evt.getOldValue();
                }
                if (mapping != null) {
                    BranchGraphOutlinePage.this.refreshBranch(mapping.getSource());
                    BranchGraphOutlinePage.this.revealProxies(mapping);
                }
            } else if ("targetMappings".equals(property)) {
                Mapping mapping = (Mapping)evt.getNewValue();
                if (mapping == null) {
                    mapping = (Mapping)evt.getOldValue();
                }
                BranchGraphOutlinePage.this.refreshBranch(mapping.getTarget());
            } else if ("name".equals(property) || "type".equals(property)) {
                BranchGraphOutlinePage.this.viewer.refresh(evt.getSource());
            } else if ("ELEMENT_ADDED".equals(property) || "ELEMENT_REMOVED".equals(property)) {
                BranchGraphOutlinePage.this.viewer.refresh();
            }
        }
    };

    private void refreshBranch(Branch branch) {
        if (branch != null) {
            this.viewer.refresh((Object)branch);
            this.viewer.expandToLevel((Object)branch, 1);
        }
    }

    private void revealProxies(Mapping mapping) {
        MappingProxy[] proxies = MappingProxy.generateProxies(mapping);
        if (proxies.length > 0) {
            this.viewer.reveal((Object)proxies[0]);
        }
    }

    public BranchGraphOutlinePage(IP4Connection connection, IPageChangeProvider pageProvider) {
        this.connection = connection;
        this.listeners = new ListenerList();
        this.pageProvider = pageProvider;
    }

    public void setInput(IBranchGraphPage page) {
        this.unhookListeners();
        this.graph = page.getGraph();
        this.synchronizer.register(page);
        this.hookListener();
        if (!this.isDisposed()) {
            this.viewer.setInput((Object)this.graph);
            this.viewer.expandToLevel(2);
        }
    }

    private void hookListener() {
        if (this.graph != null) {
            this.graph.addPropertyListener(this.builderListener);
        }
    }

    private void unhookListeners() {
        if (this.graph != null) {
            this.graph.removePropertyListener(this.builderListener);
        }
    }

    public void dispose() {
        this.unhookListeners();
        if (this.synchronizer != null) {
            this.synchronizer.dispose();
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.synchronizer = new SelectionSynchronizer((StructuredViewer)this.viewer);
        this.viewer.setUseHashlookup(true);
        this.viewer.setAutoExpandLevel(2);
        new BranchMappingLabelProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new BranchMappingContentProvider(this.connection, (StructuredViewer)this.viewer){

            public Object[] getElements(Object element) {
                if (BranchGraphOutlinePage.this.graph != null) {
                    return BranchGraphOutlinePage.this.graph.getBranches();
                }
                return EMPTY;
            }
        });
        this.viewer.setSorter((ViewerSorter)new BranchGraphOutlineSorter());
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object first = ((IStructuredSelection)event.getSelection()).getFirstElement();
                Mapping mapping = (Mapping)P4CoreUtils.convert((Object)first, Mapping.class);
                if (mapping instanceof BranchSpecMapping) {
                    BranchSpecMapping branchMapping = (BranchSpecMapping)mapping;
                    EditBranchAction edit = new EditBranchAction();
                    edit.selectionChanged(null, (ISelection)new StructuredSelection((Object)branchMapping.generateBranch(BranchGraphOutlinePage.this.connection)));
                    edit.run(null);
                }
            }
        });
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)listener);
            ++n2;
        }
        this.listeners.clear();
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
        MappingProxySelectionProvider proxyProvider = new MappingProxySelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)proxyProvider);
        this.getSite().registerContextMenu("branchGraphOutlinePage", manager, (ISelectionProvider)proxyProvider);
        this.pageProvider.addPageChangedListener((IPageChangedListener)this);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BranchGraphOutlinePage.this.pageProvider.removePageChangedListener((IPageChangedListener)BranchGraphOutlinePage.this);
            }
        });
        Object selectedPage = this.pageProvider.getSelectedPage();
        if (selectedPage != null) {
            this.pageChanged(new PageChangedEvent(this.pageProvider, selectedPage));
        }
        this.addToolbarActions();
    }

    private void addToolbarActions() {
        Action collapseAction = new Action(){

            public void run() {
                BranchGraphOutlinePage.this.viewer.collapseAll();
            }
        };
        collapseAction.setToolTipText(Messages.BranchGraphOutlinePage_CollapseAll);
        collapseAction.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/collapseall.png"));
        this.getSite().getActionBars().getToolBarManager().add((IAction)collapseAction);
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.addSelectionChangedListener(listener);
        } else {
            this.listeners.add((Object)listener);
        }
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener(listener);
        } else {
            this.listeners.remove((Object)listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (P4UIUtils.okToUse((Viewer)this.viewer)) {
            this.viewer.setSelection(selection);
        }
    }

    public boolean isDisposed() {
        return !P4UIUtils.okToUse((Viewer)this.viewer);
    }

    public void pageChanged(PageChangedEvent event) {
        if (event.getSelectedPage() instanceof IBranchGraphPage) {
            this.setInput((IBranchGraphPage)event.getSelectedPage());
        }
    }
}

