/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.editor.actions;

import com.perforce.team.ui.mergequest.editor.IBranchGraphEditor;
import com.perforce.team.ui.mergequest.editor.actions.GraphDeleteAction;
import com.perforce.team.ui.mergequest.editor.actions.GraphRedoAction;
import com.perforce.team.ui.mergequest.editor.actions.GraphUndoAction;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class GraphActionRegistry
extends PlatformObject
implements CommandStackListener,
ISelectionChangedListener {
    private ActionRegistry registry = new ActionRegistry();
    private List<String> updateActions = new ArrayList<String>();
    private List<String> selectActions = new ArrayList<String>();
    private IBranchGraphEditor editor;

    public GraphActionRegistry(IBranchGraphEditor editor) {
        this.editor = editor;
    }

    public void loadActions() {
        GraphUndoAction undo = new GraphUndoAction(this.editor);
        this.registry.registerAction((IAction)undo);
        this.updateActions.add(undo.getId());
        GraphRedoAction redo = new GraphRedoAction(this.editor);
        this.registry.registerAction((IAction)redo);
        this.updateActions.add(redo.getId());
        GraphDeleteAction delete = new GraphDeleteAction(this.editor);
        this.registry.registerAction((IAction)delete);
        this.selectActions.add(delete.getId());
    }

    public void commandStackChanged(EventObject event) {
        this.updateActions(this.updateActions);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ActionRegistry.class) {
            return this.registry;
        }
        return super.getAdapter(adapter);
    }

    private void updateActions(List<String> ids) {
        for (String id : ids) {
            IAction action = this.registry.getAction((Object)id);
            if (!(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateActions(this.selectActions);
    }
}

