/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest;

import com.perforce.team.core.mergequest.model.BranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.ui.LabelDecoratorAdapter;
import com.perforce.team.ui.LabelProviderAdapter;
import com.perforce.team.ui.StyledLabelProvider;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.mergequest.Messages;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ReorderGraphDialog
extends P4StatusDialog {
    private TableViewer viewer;
    private Image graphImage;
    private List<IBranchGraph> pages = new ArrayList<IBranchGraph>();

    public ReorderGraphDialog(Shell parent, IBranchGraph[] graphs) {
        super(parent);
        this.setTitle(Messages.ReorderGraphDialog_DialogTitle);
        this.setModalResizeStyle();
        this.pages = new ArrayList<IBranchGraph>(Arrays.asList(graphs));
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite displayArea = new Composite(c, 0);
        displayArea.setLayout((Layout)new GridLayout(2, false));
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TableViewer(displayArea, 2820);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.graphImage = P4BranchGraphPlugin.getImageDescriptor("icons/branchgraph_main_editor.png").createImage();
        LabelProviderAdapter baseLabelProvider = new LabelProviderAdapter(){

            public void dispose() {
                super.dispose();
                if (ReorderGraphDialog.this.graphImage != null) {
                    ReorderGraphDialog.this.graphImage.dispose();
                }
            }

            public String getText(Object element) {
                return ((BranchGraph)element).getName();
            }

            public Image getImage(Object element) {
                return ReorderGraphDialog.this.graphImage;
            }
        };
        DecoratingStyledCellLabelProvider labelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new StyledLabelProvider((ILabelProvider)baseLabelProvider), (ILabelDecorator)new LabelDecoratorAdapter(){

            public String decorateText(String text, Object element) {
                if (element instanceof BranchGraph) {
                    BranchGraph graph = (BranchGraph)element;
                    int mappingCount = graph.getMappings().length;
                    int branchCount = graph.getBranches().length;
                    StringBuilder builder = new StringBuilder(text);
                    builder.append(" : ");
                    if (branchCount == 1) {
                        builder.append(MessageFormat.format(Messages.ReorderGraphDialog_SingleBranch, branchCount));
                    } else {
                        builder.append(MessageFormat.format(Messages.ReorderGraphDialog_MultipleBranches, branchCount));
                    }
                    builder.append(", ");
                    if (mappingCount == 1) {
                        builder.append(MessageFormat.format(Messages.ReorderGraphDialog_SingleMapping, mappingCount));
                    } else {
                        builder.append(MessageFormat.format(Messages.ReorderGraphDialog_MultipleMappings, mappingCount));
                    }
                    return builder.toString();
                }
                return text;
            }
        }, null);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(this.pages);
        Composite buttons = new Composite(displayArea, 0);
        GridLayout bLayout = new GridLayout(1, true);
        bLayout.marginHeight = 0;
        bLayout.marginWidth = 0;
        buttons.setLayout((Layout)bLayout);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true));
        Button moveUp = new Button(buttons, 0x800008);
        moveUp.setText(Messages.ReorderGraphDialog_MoveUp);
        moveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                BranchGraph graph = (BranchGraph)((IStructuredSelection)ReorderGraphDialog.this.viewer.getSelection()).getFirstElement();
                if (graph != null && (index = ReorderGraphDialog.this.pages.indexOf(graph)) > 0) {
                    ReorderGraphDialog.this.pages.remove(index);
                    ReorderGraphDialog.this.pages.add(--index, graph);
                    ReorderGraphDialog.this.viewer.refresh();
                }
            }
        });
        moveUp.setLayoutData((Object)new GridData(4, 4, true, false));
        Button moveDown = new Button(buttons, 0x800008);
        moveDown.setText(Messages.ReorderGraphDialog_MoveDown);
        moveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                BranchGraph graph = (BranchGraph)((IStructuredSelection)ReorderGraphDialog.this.viewer.getSelection()).getFirstElement();
                if (graph != null && (index = ReorderGraphDialog.this.pages.indexOf(graph)) + 1 < ReorderGraphDialog.this.pages.size()) {
                    ReorderGraphDialog.this.pages.remove(index);
                    ReorderGraphDialog.this.pages.add(++index, graph);
                    ReorderGraphDialog.this.viewer.refresh();
                }
            }
        });
        moveDown.setLayoutData((Object)new GridData(4, 4, true, false));
        return c;
    }

    public BranchGraph[] getOrder() {
        return this.pages.toArray(new BranchGraph[this.pages.size()]);
    }
}

