/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast.expressions;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;

public class CallHolder
extends Expression {
    private Expression fArguments = null;

    public CallHolder(int start, int end, Expression arguments) {
        super(start, end);
        this.fArguments = arguments;
    }

    public CallHolder(DLTKToken dltk, DLTKToken dltk2, Expression k) {
        super(dltk.getColumn(), dltk2.getColumn() + 1);
        this.fArguments = k;
    }

    public int getKind() {
        return 1067;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Expression)this)) {
            if (this.fArguments != null) {
                this.fArguments.traverse(pVisitor);
            }
            pVisitor.endvisit((Expression)this);
        }
    }

    public Expression getArguments() {
        return this.fArguments;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("( ");
        if (this.fArguments != null) {
            this.fArguments.printNode(output);
        }
        output.formatPrintLn(" )");
    }
}

