/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.processor;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.mergequest.model.MappingDescriptor;
import com.perforce.team.core.mergequest.model.MappingException;
import com.perforce.team.core.mergequest.processor.Messages;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4ConnectionProvider;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.p4java.P4Workspace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class InterchangesProcessor {
    private ISchedulingRule rule = P4Runner.createRule();
    private Map<Mapping, Result> interchanges;
    private IBranchGraph graph;
    private IP4ConnectionProvider provider;
    private IP4Listener p4Listener = new IP4Listener(){

        public void resoureChanged(P4Event event) {
            P4Event.EventType type = event.getType();
            if (P4Event.EventType.SUBMIT_CHANGELIST == event.getType()) {
                if (this.connectionMatch((IP4Resource[])event.getCommonConnections())) {
                    InterchangesProcessor.this.refresh();
                }
            } else if (P4Event.EventType.REFRESHED == type) {
                this.refreshBranchSpecMappings(event.getBranches());
            }
        }

        private void refreshBranchSpecMappings(IP4Branch[] branches) {
            if (branches.length > 0) {
                ArrayList<Mapping> refresh = new ArrayList<Mapping>();
                Mapping[] mappingArray = InterchangesProcessor.this.getMappings();
                int n = mappingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Mapping mapping = mappingArray[n2];
                    if (mapping instanceof BranchSpecMapping) {
                        IP4Branch[] iP4BranchArray = branches;
                        int n3 = branches.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IP4Branch branch = iP4BranchArray[n4];
                            if (branch.getName().equals(mapping.getName()) && this.connectionMatch(new IP4Resource[]{branch})) {
                                refresh.add(mapping);
                                break;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                if (!refresh.isEmpty()) {
                    RefreshRequest request = new RefreshRequest();
                    request.mappings = refresh.toArray(new Mapping[refresh.size()]);
                    request.force = true;
                    InterchangesProcessor.this.scheduleRefreshRequest(request);
                }
            }
        }

        private boolean connectionMatch(IP4Resource ... resources) {
            IP4Connection connection = InterchangesProcessor.this.provider.getConnection();
            if (connection != null) {
                IP4Resource[] iP4ResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource resource = iP4ResourceArray[n2];
                    if (connection.equals(resource.getConnection())) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public String getName() {
            return InterchangesProcessor.this.getClass().getSimpleName();
        }
    };
    private PropertyChangeListener mappingListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof Mapping) {
                InterchangesProcessor.this.scheduleFullRefresh((Mapping)source);
            }
        }
    };

    private void scheduleFullRefresh(Mapping mapping) {
        if (mapping != null) {
            RefreshRequest request = new RefreshRequest();
            request.force = true;
            request.mappings = new Mapping[]{mapping};
            this.scheduleRefreshRequest(request);
        }
    }

    public InterchangesProcessor(IP4ConnectionProvider provider, IBranchGraph graph) {
        this.interchanges = Collections.synchronizedMap(new HashMap());
        this.provider = provider;
        this.graph = graph;
        P4Workspace.getWorkspace().addListener(this.p4Listener);
    }

    private void addMappingListener(Mapping mapping) {
        if (mapping != null) {
            mapping.addPropertyListener("name", this.mappingListener);
            mapping.addPropertyListener("sourcePath", this.mappingListener);
            mapping.addPropertyListener("targetPath", this.mappingListener);
        }
    }

    private void removeMappingListener(Mapping mapping) {
        if (mapping != null) {
            mapping.removePropertyListener("name", this.mappingListener);
            mapping.removePropertyListener("sourcePath", this.mappingListener);
            mapping.removePropertyListener("targetPath", this.mappingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mapping[] getMappings() {
        Mapping[] mappings = null;
        Map<Mapping, Result> map = this.interchanges;
        synchronized (map) {
            mappings = this.interchanges.keySet().toArray(new Mapping[0]);
        }
        return mappings;
    }

    public void dispose() {
        P4Workspace.getWorkspace().removeListener(this.p4Listener);
        Mapping[] mappingArray = this.getMappings();
        int n = mappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping mapping = mappingArray[n2];
            this.removeMappingListener(mapping);
            ++n2;
        }
        this.interchanges.clear();
    }

    public ISchedulingRule getRule() {
        return this.rule;
    }

    public void refresh() {
        this.refresh((Runnable)null);
    }

    public void refresh(Runnable callback) {
        this.refresh(this.graph.getMappings(), callback);
    }

    public void refresh(Mapping[] mappings) {
        this.refresh(mappings, null);
    }

    public void refresh(Mapping[] mappings, Runnable callback) {
        RefreshRequest request = new RefreshRequest();
        request.mappings = mappings;
        request.callback = callback;
        this.scheduleRefreshRequest(request);
    }

    protected void scheduleRefreshRequest(final RefreshRequest request) {
        if (request == null) {
            return;
        }
        request.connection = this.provider.getConnection();
        if (request.connection == null) {
            return;
        }
        if (request.mappings == null || request.mappings.length == 0) {
            return;
        }
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.InterchangesProcessor_RefreshingConnectors;
            }

            public void run(IProgressMonitor monitor) {
                request.monitor = monitor;
                InterchangesProcessor.this.refresh(request);
                if (request.callback != null) {
                    request.callback.run();
                }
            }
        }, (ISchedulingRule)this.getRule());
    }

    private void refresh(RefreshRequest request) {
        IP4Connection connection = request.connection;
        Mapping[] mappings = request.mappings;
        IProgressMonitor monitor = request.monitor;
        monitor.beginTask("", mappings.length * 4);
        HashMap<Object, IP4SubmittedChangelist> contexts = new HashMap<Object, IP4SubmittedChangelist>();
        Mapping[] mappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping mapping = mappingArray[n2];
            if (monitor.isCanceled()) break;
            monitor.subTask(MessageFormat.format(Messages.InterchangesProcessor_RefreshingChange, mapping.getName()));
            Result mappingResult = this.getResult(mapping);
            boolean error = false;
            int latestSourceList = mapping.getLatestSource();
            int latestTargetList = mapping.getLatestTarget();
            Object sourceContext = mapping.getSourceContext(connection, null);
            IP4SubmittedChangelist latestSource = null;
            if (sourceContext != null) {
                latestSource = (IP4SubmittedChangelist)contexts.get(sourceContext);
            }
            if (latestSource == null) {
                try {
                    latestSource = mapping.refreshLatestSourceChange(connection, sourceContext);
                    if (latestSource != null && sourceContext != null) {
                        contexts.put(sourceContext, latestSource);
                    }
                }
                catch (MappingException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                    error = true;
                }
            } else {
                mapping.setLatestSource(latestSource.getId());
            }
            monitor.worked(1);
            if (monitor.isCanceled()) break;
            Object targetContext = mapping.getTargetContext(connection, sourceContext);
            IP4SubmittedChangelist latestTarget = null;
            if (targetContext != null) {
                latestTarget = (IP4SubmittedChangelist)contexts.get(targetContext);
            }
            if (latestTarget == null) {
                if (!error) {
                    try {
                        latestTarget = mapping.refreshLatestTargetChange(connection, targetContext);
                        if (latestTarget != null && targetContext != null) {
                            contexts.put(targetContext, latestTarget);
                        }
                    }
                    catch (MappingException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                        error = true;
                    }
                }
            } else {
                mapping.setLatestTarget(latestTarget.getId());
            }
            monitor.worked(1);
            if (monitor.isCanceled()) break;
            if (latestSourceList != mapping.getLatestSource() || latestTargetList != mapping.getLatestTarget()) {
                mapping.setSourceToTargetCount(0);
                mapping.setTargetToSourceCount(0);
            }
            if (!error && (request.force || this.needsRefresh(mapping) || this.needsRefresh(latestSource, latestTarget, mappingResult))) {
                monitor.subTask(MessageFormat.format(Messages.InterchangesProcessor_RefreshingStatus, mapping.getName()));
                mappingResult.latestSource = latestSource;
                mappingResult.latestTarget = latestTarget;
                try {
                    mapping.refreshSourceStatus(connection, sourceContext);
                    if (MappingDescriptor.ChangeType.NO_CHANGES == mapping.getSourceChange()) {
                        mappingResult.sourceInterchanges = null;
                    }
                }
                catch (MappingException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
                monitor.worked(1);
                if (monitor.isCanceled()) break;
                try {
                    mapping.refreshTargetStatus(connection, targetContext);
                    if (MappingDescriptor.ChangeType.NO_CHANGES == mapping.getTargetChange()) {
                        mappingResult.targetInterchanges = null;
                    }
                }
                catch (MappingException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
                monitor.worked(1);
            } else {
                monitor.worked(2);
            }
            ++n2;
        }
        monitor.done();
    }

    private boolean needsRefresh(Mapping mapping) {
        switch (mapping.getDirection()) {
            case SOURCE: {
                return mapping.getSourceChange() == MappingDescriptor.ChangeType.UNKNOWN;
            }
            case TARGET: {
                return mapping.getTargetChange() == MappingDescriptor.ChangeType.UNKNOWN;
            }
            case BOTH: {
                return mapping.getSourceChange() == MappingDescriptor.ChangeType.UNKNOWN || mapping.getTargetChange() == MappingDescriptor.ChangeType.UNKNOWN;
            }
        }
        return false;
    }

    public void refreshInterchanges() {
        this.refreshInterchanges((Runnable)null);
    }

    public void refreshInterchanges(Runnable callback) {
        this.refreshInterchanges(this.graph.getMappings(), callback);
    }

    public void refreshInterchanges(Mapping[] mappings) {
        this.refreshInterchanges(mappings, null);
    }

    public void refreshInterchanges(final Mapping[] mappings, final Runnable callback) {
        if (mappings == null || mappings.length == 0) {
            return;
        }
        final IP4Connection connection = this.provider.getConnection();
        if (connection == null) {
            return;
        }
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.InterchangesProcessor_RefreshingInterchanges;
            }

            public void run(IProgressMonitor monitor) {
                InterchangesProcessor.this.refreshInterchanges(mappings, connection, monitor);
                if (callback != null) {
                    callback.run();
                }
            }
        }, (ISchedulingRule)this.getRule());
    }

    private void refreshInterchanges(Mapping[] mappings, IP4Connection connection, IProgressMonitor monitor) {
        monitor.beginTask("", mappings.length * 2);
        Mapping[] mappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping mapping = mappingArray[n2];
            if (monitor.isCanceled()) break;
            Result mappingResult = this.getResult(mapping);
            monitor.subTask(mapping.getName());
            boolean error = false;
            if (mapping.hasSourceChanges()) {
                try {
                    mappingResult.sourceInterchanges = mapping.refreshSourceInterchanges(connection);
                }
                catch (MappingException e) {
                    mappingResult.sourceInterchanges = null;
                    error = true;
                }
            }
            monitor.worked(1);
            if (monitor.isCanceled()) break;
            if (mapping.hasTargetChanges()) {
                try {
                    mappingResult.targetInterchanges = mapping.refreshTargetInterchanges(connection);
                }
                catch (MappingException e) {
                    mappingResult.targetInterchanges = null;
                    error = true;
                }
            }
            monitor.worked(1);
            if (!error) {
                mappingResult.interchangesRefreshTime = System.currentTimeMillis();
            }
            ++n2;
        }
        monitor.done();
    }

    public Date getLastRefreshDate(Mapping mapping) {
        Date date = null;
        if (mapping != null) {
            Result result = this.getResult(mapping);
            long time = result.interchangesRefreshTime;
            if (time > 0L) {
                date = new Date(time);
            }
        }
        return date;
    }

    private Result getResult(Mapping mapping) {
        Result result = this.interchanges.get(mapping);
        if (result == null) {
            result = new Result();
            this.addMappingListener(mapping);
            this.interchanges.put(mapping, result);
        }
        return result;
    }

    private boolean needsRefresh(IP4SubmittedChangelist latestSource, IP4SubmittedChangelist latestTarget, Result result) {
        if (result.latestSource == null && latestSource != null) {
            return true;
        }
        if (result.latestTarget == null && latestTarget != null) {
            return true;
        }
        if (result.latestTarget != null && latestSource == null) {
            return true;
        }
        if (result.latestSource != null && latestTarget == null) {
            return true;
        }
        if (result.latestSource != null && latestSource != null && result.latestSource.getId() != latestSource.getId()) {
            return true;
        }
        return result.latestTarget != null && latestTarget != null && result.latestTarget.getId() != latestTarget.getId();
    }

    public IP4SubmittedChangelist[] getSourceInterchanges(Mapping mapping) {
        return mapping != null ? this.getResult((Mapping)mapping).sourceInterchanges : null;
    }

    public IP4SubmittedChangelist[] getTargetInterchanges(Mapping mapping) {
        return mapping != null ? this.getResult((Mapping)mapping).targetInterchanges : null;
    }

    public void clear(Mapping mapping) {
        if (mapping != null) {
            this.removeMappingListener(mapping);
            this.interchanges.remove(mapping);
        }
    }

    private static class RefreshRequest {
        boolean force = false;
        Mapping[] mappings = null;
        IP4Connection connection = null;
        IProgressMonitor monitor = null;
        Runnable callback = null;

        private RefreshRequest() {
        }
    }

    private static class Result {
        IP4SubmittedChangelist latestTarget = null;
        IP4SubmittedChangelist latestSource = null;
        IP4SubmittedChangelist[] sourceInterchanges = null;
        IP4SubmittedChangelist[] targetInterchanges = null;
        long interchangesRefreshTime = -1L;

        private Result() {
        }
    }
}

