/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.model.registry;

import com.perforce.team.core.extensions.ExtensionPointRegistry;
import com.perforce.team.core.mergequest.model.registry.BranchType;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class BranchRegistry
extends ExtensionPointRegistry
implements Iterable<BranchType> {
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String LABEL_ATTRIBUTE = "label";
    public static final String FIRMNESS_ATTRIBUTE = "firmness";
    public static final String BRANCH_ELEMENT = "branch";
    public static final int DEFAULT_FIRMNESS = 1;
    String extensionPointId;
    private BranchType defaultType = null;
    private Map<String, BranchType> types;

    public BranchRegistry(String extensionPointId) {
        this.extensionPointId = extensionPointId;
        this.types = new TreeMap<String, BranchType>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointId);
        this.buildBranches(elements);
    }

    public BranchType[] getTypes() {
        return this.types.values().toArray(new BranchType[this.types.size()]);
    }

    public BranchType getType(String type) {
        BranchType bType = null;
        if (type != null) {
            bType = this.types.get(type);
        }
        if (bType == null) {
            bType = BranchType.UNKNOWN;
        }
        return bType;
    }

    public BranchType getDefaultType() {
        return this.defaultType != null ? this.defaultType : BranchType.UNKNOWN;
    }

    protected void buildBranches(IConfigurationElement[] elements) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String type;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (BRANCH_ELEMENT.equals(element.getName()) && (type = element.getAttribute(TYPE_ATTRIBUTE)) != null && type.length() > 0) {
                String label = element.getAttribute(LABEL_ATTRIBUTE);
                if (label == null || label.length() == 0) {
                    label = type;
                }
                int firmness = this.getInteger(element.getAttribute(FIRMNESS_ATTRIBUTE), -1);
                BranchType branchType = new BranchType(type, label, firmness);
                this.types.put(type, branchType);
                if (branchType.getFirmness() == 1) {
                    this.defaultType = branchType;
                }
            }
            ++n2;
        }
    }

    @Override
    public Iterator<BranchType> iterator() {
        return this.types.values().iterator();
    }
}

