/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.model;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IBranchMapping;
import com.perforce.p4java.core.IBranchSpecSummary;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.BranchSpecSummary;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.mergequest.model.MappingDescriptor;
import com.perforce.team.core.mergequest.model.MappingException;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4ClientOperation;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4ServerOperation;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4Branch;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.core.p4java.P4IntegrationOptions;
import com.perforce.team.core.p4java.P4ServerOperation;
import com.perforce.team.core.p4java.P4SubmittedChangelist;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BranchSpecMapping
extends Mapping {
    public static final String TYPE = "branchSpec";

    public BranchSpecMapping(String id, IBranchGraph graph) {
        super(id, graph);
    }

    public BranchSpecMapping(String id) {
        super(id);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BranchSpecMapping && super.equals(obj);
    }

    public IP4Branch generateBranch(IP4Connection connection) {
        BranchSpecSummary summary = new BranchSpecSummary();
        summary.setName(this.getName());
        return new P4Branch(connection, (IBranchSpecSummary)summary, false);
    }

    @Override
    public IP4SubmittedChangelist[] refreshSourceInterchanges(IP4Connection connection) throws MappingException {
        IP4SubmittedChangelist[] lists = null;
        if (Mapping.Direction.TARGET != this.getDirection() && connection != null && (lists = this.getInterchanges(this.generateBranch(connection), true)) != null) {
            this.setTargetToSourceCount(lists.length);
        }
        if (lists == null) {
            lists = EMPTY_LISTS;
        }
        return lists;
    }

    @Override
    public IP4SubmittedChangelist[] refreshTargetInterchanges(IP4Connection connection) throws MappingException {
        IP4SubmittedChangelist[] lists = null;
        if (Mapping.Direction.SOURCE != this.getDirection() && connection != null && (lists = this.getInterchanges(this.generateBranch(connection), false)) != null) {
            this.setSourceToTargetCount(lists.length);
        }
        if (lists == null) {
            lists = EMPTY_LISTS;
        }
        return lists;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private IP4SubmittedChangelist getLatestChangelist(final String[] paths, final IP4Connection connection) throws MappingException {
        final IP4SubmittedChangelist[] list = new IP4SubmittedChangelist[1];
        P4ServerOperation operation = new P4ServerOperation(){

            public void run(IServer server) throws P4JavaException, P4JavaError {
                List lists = server.getChangelists(1, P4FileSpecBuilder.makeFileSpecList((String[])paths), null, null, false, IChangelist.Type.SUBMITTED, false);
                IChangelistSummary latestSummary = null;
                for (IChangelistSummary summary : lists) {
                    if (latestSummary != null && summary.getId() <= latestSummary.getId()) continue;
                    latestSummary = summary;
                }
                if (latestSummary != null) {
                    list[0] = new P4SubmittedChangelist(connection, (IChangelist)new Changelist(latestSummary, server, false));
                }
            }
        };
        this.runOperation(connection, (IP4ServerOperation)operation);
        return list[0];
    }

    private IP4SubmittedChangelist[] getInterchanges(final IP4Branch branch, final boolean reverse) throws MappingException {
        if (branch == null) {
            return null;
        }
        final List[] submittedLists = new List[1];
        final IP4Connection connection = branch.getConnection();
        P4ServerOperation operation = new P4ServerOperation(){

            public void run(IServer server) throws P4JavaException, P4JavaError {
                List lists = server.getInterchanges(branch.getName(), null, null, false, true, -1, reverse, false);
                ArrayList<P4SubmittedChangelist> submitted = new ArrayList<P4SubmittedChangelist>(lists.size());
                for (IChangelist list : lists) {
                    submitted.add(new P4SubmittedChangelist(connection, list));
                }
                submittedLists[0] = submitted;
            }
        };
        this.runOperation(connection, (IP4ServerOperation)operation);
        if (submittedLists[0] != null) {
            return submittedLists[0].toArray(new IP4SubmittedChangelist[submittedLists[0].size()]);
        }
        return null;
    }

    @Override
    public IP4SubmittedChangelist refreshLatestSourceChange(IP4Connection connection, Object context) throws MappingException {
        IP4SubmittedChangelist latest = null;
        if (context instanceof BranchContext) {
            latest = this.getLatestChangelist(((BranchContext)context).sourcePaths, connection);
        }
        if (latest != null) {
            this.setLatestSource(latest.getId());
        }
        return latest;
    }

    @Override
    public IP4SubmittedChangelist refreshLatestTargetChange(IP4Connection connection, Object context) throws MappingException {
        IP4SubmittedChangelist latest = null;
        if (context instanceof BranchContext) {
            latest = this.getLatestChangelist(((BranchContext)context).targetPaths, connection);
        }
        if (latest != null) {
            this.setLatestTarget(latest.getId());
        }
        return latest;
    }

    private BranchContext getContext(IP4Connection connection) {
        IP4Branch branch;
        BranchContext context = null;
        if (connection != null && (branch = this.generateBranch(connection)) != null) {
            context = new BranchContext();
            context.branch = branch;
            branch.refresh();
            ArrayList<String> sourcePaths = new ArrayList<String>();
            ArrayList<String> targetPaths = new ArrayList<String>();
            ViewMap view = branch.getView();
            if (view != null) {
                for (IBranchMapping entry : view) {
                    if (IMapEntry.EntryType.EXCLUDE == entry.getType()) continue;
                    sourcePaths.add(entry.getLeft(false));
                    targetPaths.add(entry.getRight(false));
                }
            }
            context.sourcePaths = sourcePaths.toArray(new String[sourcePaths.size()]);
            context.targetPaths = targetPaths.toArray(new String[targetPaths.size()]);
        }
        return context;
    }

    @Override
    public Object getSourceContext(IP4Connection connection, Object context) {
        if (context instanceof BranchContext) {
            BranchContext bContext = (BranchContext)context;
            if (bContext.sourcePaths != null) {
                if (!bContext.source) {
                    bContext = new BranchContext(bContext);
                    bContext.source = true;
                }
                return bContext;
            }
        }
        return this.getContext(connection);
    }

    @Override
    public Object getTargetContext(IP4Connection connection, Object context) {
        if (context instanceof BranchContext) {
            BranchContext bContext = (BranchContext)context;
            if (bContext.targetPaths != null) {
                if (bContext.source) {
                    bContext = new BranchContext(bContext);
                    bContext.source = false;
                }
                return bContext;
            }
            return context;
        }
        return this.getContext(connection);
    }

    private MappingDescriptor.ChangeType changesExist(IP4Connection connection, final boolean reverse) throws MappingException {
        final MappingDescriptor.ChangeType[] changes = new MappingDescriptor.ChangeType[]{MappingDescriptor.ChangeType.UNKNOWN};
        P4ClientOperation operation = new P4ClientOperation(){

            public void run(IClient client) throws P4JavaException, P4JavaError {
                P4IntegrationOptions options = BranchSpecMapping.this.createIntegrationOptions();
                options.setReverseMapping(reverse);
                List files = client.integrateFiles(null, null, BranchSpecMapping.this.getName(), options.createIntegrateFilesOptions(-1, true));
                if (files.size() > 0) {
                    changes[0] = BranchSpecMapping.this.getChangeType((IFileSpec)files.get(0));
                }
            }
        };
        this.runOperation(connection, (IP4ClientOperation)operation);
        return changes[0];
    }

    @Override
    public boolean refreshSourceStatus(IP4Connection connection, Object context) throws MappingException {
        MappingDescriptor.ChangeType changes = this.getSourceChange();
        if (Mapping.Direction.TARGET != this.getDirection()) {
            changes = this.changesExist(connection, true);
            this.setSourceChanges(changes);
        }
        return changes == MappingDescriptor.ChangeType.VISIBLE_CHANGES;
    }

    @Override
    public boolean refreshTargetStatus(IP4Connection connection, Object context) throws MappingException {
        MappingDescriptor.ChangeType changes = this.getTargetChange();
        if (Mapping.Direction.SOURCE != this.getDirection()) {
            changes = this.changesExist(connection, false);
            this.setTargetChanges(changes);
        }
        return changes == MappingDescriptor.ChangeType.VISIBLE_CHANGES;
    }

    private static class BranchContext {
        IP4Branch branch;
        String[] sourcePaths;
        String[] targetPaths;
        boolean source = true;

        public BranchContext() {
        }

        public BranchContext(BranchContext context) {
            if (context != null) {
                this.branch = context.branch;
                this.sourcePaths = context.sourcePaths;
                this.targetPaths = context.targetPaths;
                this.source = context.source;
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof BranchContext) {
                BranchContext otherContext = (BranchContext)other;
                if (this.source != otherContext.source) {
                    return false;
                }
                if (!this.branch.getName().equals(otherContext.branch.getName())) {
                    return false;
                }
                if (!this.branch.getConnection().equals(otherContext.branch.getConnection())) {
                    return false;
                }
                if (this.sourcePaths != null || otherContext.sourcePaths != null || !Arrays.equals(this.sourcePaths, otherContext.sourcePaths)) {
                    return false;
                }
                return this.targetPaths == null && otherContext.targetPaths == null && Arrays.equals(this.targetPaths, otherContext.targetPaths);
            }
            return false;
        }

        public int hashCode() {
            if (this.branch != null) {
                return this.branch.hashCode();
            }
            return super.hashCode();
        }
    }
}

