/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.model;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.BranchGraphElement;
import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.DepotPathMapping;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.mergequest.model.factory.BranchFactory;
import com.perforce.team.core.mergequest.model.factory.BranchMappingFactory;
import com.perforce.team.core.mergequest.model.factory.DepotPathMappingFactory;
import com.perforce.team.core.mergequest.model.factory.IBranchGraphElementFactory;
import com.perforce.team.core.p4java.IP4Connection;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BranchGraph
extends BranchGraphElement
implements IBranchGraph {
    private IP4Connection connection;
    private Map<String, IBranchGraphElement> elements;
    private IBranchGraphElementFactory depotMappingFactory;
    private IBranchGraphElementFactory branchMappingFactory;
    private IBranchGraphElementFactory branchFactory;
    private PropertyChangeListener globalListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BranchGraph.this.changeSupport.firePropertyChange(evt);
        }
    };

    public BranchGraph(String id) {
        this(id, id, (IP4Connection)null);
    }

    public BranchGraph(String id, String name, IP4Connection connection) {
        super(id, name);
        this.connection = connection;
        this.elements = new HashMap<String, IBranchGraphElement>();
        this.branchFactory = new BranchFactory();
        this.depotMappingFactory = new DepotPathMappingFactory();
        this.branchMappingFactory = new BranchMappingFactory();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IBranchGraph) {
            return P4CoreUtils.equals((Object)this.connection, (Object)((IBranchGraph)obj).getConnection()) && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.connection == null ? super.hashCode() : super.hashCode() + this.connection.hashCode() * 31;
    }

    @Override
    public void setConnection(IP4Connection connection) {
        this.connection = connection;
    }

    @Override
    public Branch[] getBranches() {
        Collection<Branch> branches = this.getElements(Branch.class);
        return branches.toArray(new Branch[branches.size()]);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Mapping[] getMappings() {
        Collection<Mapping> mappings = this.getElements(Mapping.class);
        return mappings.toArray(new Mapping[mappings.size()]);
    }

    @Override
    public IP4Connection getConnection() {
        return this.connection;
    }

    @Override
    public Branch createBranch(String id) {
        return (Branch)this.branchFactory.create(id, this);
    }

    @Override
    public BranchSpecMapping createBranchSpecMapping(String id) {
        return (BranchSpecMapping)this.branchMappingFactory.create(id, this);
    }

    @Override
    public DepotPathMapping createDepotPathMapping(String id) {
        return (DepotPathMapping)this.depotMappingFactory.create(id, this);
    }

    @Override
    public boolean add(IBranchGraphElement element) {
        boolean added = false;
        if (element != null && !this.elements.containsKey(element.getId())) {
            element.setGraph(this);
            this.elements.put(element.getId(), element);
            added = true;
            if (added) {
                element.addPropertyListener(this.globalListener);
                this.changeSupport.firePropertyChange("ELEMENT_ADDED", null, element);
            }
        }
        return added;
    }

    @Override
    public boolean remove(IBranchGraphElement element) {
        boolean removed = false;
        if (element != null) {
            removed = this.elements.remove(element.getId()) != null;
            element.setGraph(null);
            if (removed) {
                element.removePropertyListener(this.globalListener);
                this.changeSupport.firePropertyChange("ELEMENT_REMOVED", element, null);
            }
        }
        return removed;
    }

    @Override
    public IBranchGraphElement getElementById(String id) {
        return id != null ? this.elements.get(id) : null;
    }

    @Override
    public boolean containsElement(String id) {
        return id != null ? this.elements.containsKey(id) : false;
    }

    @Override
    public <ElementType extends IBranchGraphElement> Collection<ElementType> getElements(Class<ElementType> elementClass) {
        ArrayList<IBranchGraphElement> typedElements = new ArrayList<IBranchGraphElement>();
        if (elementClass != null) {
            for (IBranchGraphElement element : this.elements.values()) {
                if (!elementClass.isInstance(element)) continue;
                typedElements.add(element);
            }
        }
        return typedElements;
    }

    @Override
    public IBranchGraph getGraph() {
        return this;
    }

    @Override
    public void setGraph(IBranchGraph graph) {
    }

    @Override
    public Branch getBranch(String id) {
        return this.getElementById(id, Branch.class);
    }

    @Override
    public <ElementType extends IBranchGraphElement> ElementType getElementById(String id, Class<ElementType> elementClass) {
        IBranchGraphElement candidate;
        IBranchGraphElement element = null;
        if (elementClass != null && (candidate = this.getElementById(id)) != null && elementClass.isInstance(candidate)) {
            element = candidate;
        }
        return (ElementType)element;
    }

    @Override
    public Mapping getMapping(String id) {
        return this.getElementById(id, Mapping.class);
    }

    @Override
    public IBranchGraphElement[] getElements() {
        return this.elements.values().toArray(new IBranchGraphElement[this.elements.size()]);
    }

    @Override
    public void updateFactories() {
        IBranchGraphElement[] iBranchGraphElementArray = this.getElements();
        int n = iBranchGraphElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBranchGraphElement element = iBranchGraphElementArray[n2];
            if (element instanceof Branch) {
                this.branchFactory.update(element.getId());
            } else if (element instanceof DepotPathMapping) {
                this.depotMappingFactory.update(element.getId());
            } else if (element instanceof BranchSpecMapping) {
                this.branchMappingFactory.update(element.getId());
            }
            ++n2;
        }
    }

    protected boolean containsBranchAtPoint(Point point, Branch[] branches) {
        Branch[] branchArray = branches;
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            Branch branch = branchArray[n2];
            if (branch.containsPoint(point)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void translatePoint(Point point, int[] coords, double factor) {
        point.translate((int)((double)coords[0] * factor), (int)((double)coords[1] * factor));
    }

    @Override
    public Point findEmptyLocation(Point startingLocation, int increment) {
        Branch[] branches;
        Point empty;
        if (startingLocation == null) {
            startingLocation = new Point(100, 100);
        }
        if (increment <= 0) {
            increment = 25;
        }
        if (!this.containsBranchAtPoint(empty = new Point(startingLocation), branches = this.getBranches())) {
            return empty;
        }
        double factor = 1.0;
        int[][] combinations = new int[8][2];
        combinations[0][0] = increment;
        combinations[0][1] = 0;
        combinations[1][0] = increment;
        combinations[1][1] = increment;
        combinations[2][0] = 0;
        combinations[2][1] = increment;
        combinations[3][0] = -increment;
        combinations[3][1] = increment;
        combinations[4][0] = -increment;
        combinations[4][1] = 0;
        combinations[5][0] = -increment;
        combinations[5][1] = -increment;
        combinations[6][0] = 0;
        combinations[6][1] = -increment;
        combinations[7][0] = increment;
        combinations[7][1] = -increment;
        boolean pointTaken = true;
        int trial = 0;
        int[] increments = null;
        while (pointTaken) {
            pointTaken = this.containsBranchAtPoint(empty, branches);
            if (!pointTaken) continue;
            if (increments != null) {
                this.translatePoint(empty, increments, factor * -1.0);
            }
            if (trial == combinations.length) {
                factor += 0.5;
                trial = 0;
            }
            increments = combinations[trial];
            this.translatePoint(empty, increments, factor);
            ++trial;
        }
        return empty;
    }
}

