/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.builder;

import com.perforce.team.core.mergequest.builder.xml.XmlBranchGraphBuilder;
import com.perforce.team.core.mergequest.model.IBranchGraphContainer;
import com.perforce.team.core.mergequest.model.factory.IContainerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.Assert;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HttpBranchGraphBuilder
extends XmlBranchGraphBuilder {
    private String url;

    public HttpBranchGraphBuilder(IContainerFactory factory, String url) {
        super(factory);
        Assert.isNotNull((Object)url, (String)"Url cannot be null");
        this.url = url;
    }

    public HttpBranchGraphBuilder(String url) {
        Assert.isNotNull((Object)url, (String)"Url cannot be null");
        this.url = url;
    }

    @Override
    public IBranchGraphContainer load() throws IOException {
        IBranchGraphContainer container = null;
        InputStream stream = null;
        IOException ioException = null;
        try {
            try {
                URL locator = new URL(this.url);
                URLConnection connection = locator.openConnection();
                stream = connection.getInputStream();
                if (stream != null) {
                    container = this.unformat(new InputSource(stream));
                }
                if (container == null) {
                    container = this.unformat(null);
                }
            }
            catch (IOException e) {
                ioException = e;
                throw ioException;
            }
            catch (SAXException e) {
                ioException = new IOException(e);
                throw ioException;
            }
        }
        finally {
            this.logLoadException(ioException);
        }
        return container;
    }

    @Override
    public void persist(IBranchGraphContainer container) {
    }
}

