/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.timelapse;

import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.timelapse.IAnnotateModel;
import com.perforce.team.ui.timelapse.ITickDecorator;
import com.perforce.team.ui.timelapse.ITickFormatter;
import com.perforce.team.ui.timelapse.ITickPositionHandler;
import com.perforce.team.ui.timelapse.Messages;
import com.perforce.team.ui.timelapse.TimeLapseUtils;
import java.util.Arrays;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class TimeLapseSlider {
    private static final RGB MARK_BG = new RGB(50, 91, 144);
    private static final int MARGIN_BOTTOM = 5;
    private static final int SLIDER_X1 = 15;
    private static final int SLIDER_X2 = 20;
    private static final int SLIDER_ARC = 10;
    private static final int TICK_X1 = 10;
    private static final int TICK_X2 = 10;
    private static final int SLIDER_Y1 = 5;
    private static final int SLIDER_HEIGHT = 13;
    private static final int TICK_HEIGHT = 4;
    private static final int TICK1_Y1 = 14;
    private static final int TICK1_Y2 = 18;
    private static final int TICK2_Y1 = 18;
    private static final int TICK2_Y2 = 22;
    private static final int LABEL_Y1 = 24;
    private static final int MARK_Y1 = 4;
    private static final int MARK_WIDTH = 9;
    private static final int MARK_ARC = 3;
    private static final int MARK_HEIGHT = 16;
    private static final int MARK_X1 = 4;
    private static final int BOTTOM_PADDING = 2;
    private static final int DECORATOR_Y = 16;
    private static final int TICK_PADDING = 4;
    private static final int TICK_PADDING_OFFSET = 2;
    private static final String SLIDER_BG_PATH = "images/slider_bg.png";
    private static final String GRABBER_FG_PATH = "images/grabber.png";
    private int[] spaces = new int[0];
    private int position = 0;
    private int decoratorY = 0;
    private IAnnotateModel.Type type = null;
    private Composite displayArea;
    private Combo options;
    private ToolBar toolbar;
    private ToolItem next;
    private ToolItem previous;
    private Canvas slider;
    private Image buffer;
    private Cursor currentCursor = null;
    private Cursor moveCursor = null;
    private Color inactiveTickBg = null;
    private Color markBg = null;
    private Font sliderFont = null;
    private ITickFormatter formatter = null;
    private ITickPositionHandler positioner = null;
    private boolean drawDecorations = false;
    private ITickDecorator decorator = null;
    private boolean mouseDown = false;
    private boolean inRedraw = false;
    private boolean inUpdate = false;
    private boolean inActionUpdate = false;
    private IP4Revision[] allRevisions;
    private IP4Revision[] revisions;
    private IRevisionListener listener;
    private IAnnotateModel.Type[] scaleTypes = new IAnnotateModel.Type[]{IAnnotateModel.Type.REVISION, IAnnotateModel.Type.CHANGELIST, IAnnotateModel.Type.DATE};

    public TimeLapseSlider() {
        this.revisions = new IP4Revision[0];
    }

    public ITickFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(ITickFormatter formatter) {
        this.formatter = formatter;
    }

    public ITickPositionHandler getPositioner() {
        return this.positioner;
    }

    public void setPositioner(ITickPositionHandler positioner) {
        this.positioner = positioner;
    }

    public void setDecorator(ITickDecorator decorator) {
        this.decorator = decorator;
    }

    public TimeLapseSlider(IP4Revision[] revisions) {
        this.setRevisions(revisions);
    }

    public TimeLapseSlider(IP4Revision[] revisions, IAnnotateModel.Type[] scaleTypes) {
        this.setRevisions(revisions);
        if (scaleTypes != null && scaleTypes.length > 0 && scaleTypes[0] != null) {
            this.scaleTypes = scaleTypes;
        }
    }

    public boolean filter(boolean reset) {
        Object[] previous = this.revisions;
        int newPosition = -1;
        if (this.positioner != null && this.positioner.isEnabled()) {
            this.revisions = this.positioner.filter(this.allRevisions);
            newPosition = this.positioner.getNewPosition();
        } else {
            this.revisions = this.allRevisions;
        }
        if (newPosition < 0) {
            newPosition = this.revisions.length - 1;
        }
        boolean force = true;
        if (!reset && previous != null && this.position >= 0 && this.position < previous.length) {
            if (!Arrays.equals(previous, this.revisions)) {
                int found;
                Object previousRev = previous[this.position];
                int n = found = this.revisions == null ? -1 : Arrays.binarySearch(this.revisions, previousRev);
                if (found >= 0) {
                    newPosition = found;
                }
            } else {
                newPosition = this.position;
                force = false;
            }
        }
        return this.updatePosition(newPosition, force);
    }

    private void setRevisions(IP4Revision[] revisions) {
        this.allRevisions = revisions;
        this.filter(true);
    }

    public void resetRevisions(IP4Revision[] newRevisions, IP4Revision revision) {
        this.setRevisions(newRevisions);
        if (revision != null) {
            int i = 0;
            while (i < this.revisions.length) {
                if (revision.getContentIdentifier().equals(this.revisions[i].getContentIdentifier())) {
                    this.position = i;
                    break;
                }
                ++i;
            }
        }
        this.redraw();
        this.update();
        this.updateActions();
    }

    public ToolBar getToolbar() {
        return this.toolbar;
    }

    public void setListener(IRevisionListener listener) {
        this.listener = listener;
    }

    private int getTickStart(int width) {
        return this.revisions.length == 1 ? width / 2 : 25;
    }

    private int[] getTickSpacing(int width) {
        int overflow;
        int space;
        int spaces = this.revisions.length;
        int[] spacing = new int[spaces];
        int tickSpacing = space = width - 20 - 10 - 10;
        if (spaces > 2) {
            tickSpacing /= spaces - 1;
        }
        if ((overflow = space - (spaces - 1) * tickSpacing) > 0) {
            int each = Math.max(1, overflow / spaces);
            int i = 0;
            while (i < spacing.length - 1) {
                int size = tickSpacing;
                if (overflow > 0) {
                    size += each;
                    overflow -= each;
                }
                spacing[i] = size;
                ++i;
            }
        } else {
            Arrays.fill(spacing, tickSpacing);
        }
        return spacing;
    }

    private int getTickOffset(int tickStart) {
        int offset = tickStart;
        int i = 0;
        while (i < this.position) {
            offset += this.spaces[i];
            ++i;
        }
        return offset;
    }

    private int getGrabPosition(int width) {
        return this.getTickOffset(this.getTickStart(width));
    }

    private boolean updatePosition(int newPosition) {
        return this.updatePosition(newPosition, false);
    }

    private boolean updatePosition(int newPosition, boolean force) {
        if (force || this.position != newPosition) {
            IP4Revision rev;
            this.position = newPosition;
            this.inUpdate = true;
            this.inRedraw = true;
            this.inActionUpdate = true;
            if (this.listener != null && this.revisions != null && this.revisions.length > this.position && (rev = this.revisions[this.position]) != null) {
                this.listener.revisionChanged(rev);
            }
            this.inRedraw = false;
            this.redraw();
            this.inUpdate = false;
            this.update();
            this.inActionUpdate = false;
            this.updateActions();
            return true;
        }
        return false;
    }

    public void redraw() {
        if (!this.inRedraw && this.slider != null) {
            this.slider.redraw();
        }
    }

    public void update() {
        if (!this.inUpdate && this.slider != null) {
            this.slider.update();
        }
    }

    private void createToolbar(Composite parent) {
        Composite toolArea = new Composite(parent, 0);
        GridLayout taLayout = new GridLayout(3, false);
        taLayout.marginHeight = 0;
        taLayout.marginWidth = 0;
        toolArea.setLayout((Layout)taLayout);
        toolArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Label scaleLabel = new Label(toolArea, 16384);
        scaleLabel.setText(Messages.TimeLapseSlider_Scale);
        this.options = new Combo(toolArea, 12);
        IAnnotateModel.Type[] typeArray = this.scaleTypes;
        int n = this.scaleTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotateModel.Type type = typeArray[n2];
            if (type != null) {
                switch (type) {
                    case REVISION: {
                        this.options.add(Messages.TimeLapseSlider_Revisions);
                        break;
                    }
                    case CHANGELIST: {
                        this.options.add(Messages.TimeLapseSlider_Changelists);
                        break;
                    }
                    case DATE: {
                        this.options.add(Messages.TimeLapseSlider_Date);
                        break;
                    }
                }
            }
            ++n2;
        }
        this.type = this.scaleTypes[0];
        this.options.select(0);
        this.options.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = TimeLapseSlider.this.options.getSelectionIndex();
                if (index >= 0) {
                    TimeLapseSlider.this.type = TimeLapseSlider.this.scaleTypes[index];
                }
                TimeLapseSlider.this.redraw();
                TimeLapseSlider.this.update();
                if (TimeLapseSlider.this.listener != null) {
                    TimeLapseSlider.this.listener.displayChanged(TimeLapseSlider.this.type);
                }
            }
        });
        this.toolbar = new ToolBar(toolArea, 0x800040);
        this.toolbar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.previous = new ToolItem(this.toolbar, 8);
        this.previous.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK"));
        this.previous.setToolTipText(Messages.TimeLapseSlider_ShowPreviousRev);
        this.previous.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPosition = TimeLapseSlider.this.position - 1;
                if (TimeLapseSlider.this.positioner != null && TimeLapseSlider.this.positioner.isEnabled()) {
                    newPosition = TimeLapseSlider.this.positioner.getPrevious(TimeLapseSlider.this.position);
                }
                if (newPosition >= 0) {
                    TimeLapseSlider.this.updatePosition(newPosition);
                }
            }
        });
        this.next = new ToolItem(this.toolbar, 8);
        this.next.setToolTipText(Messages.TimeLapseSlider_ShowNextRev);
        this.next.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD"));
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPosition = TimeLapseSlider.this.position + 1;
                if (TimeLapseSlider.this.positioner != null && TimeLapseSlider.this.positioner.isEnabled()) {
                    newPosition = TimeLapseSlider.this.positioner.getNext(TimeLapseSlider.this.position);
                }
                if (newPosition >= 0 && newPosition < TimeLapseSlider.this.revisions.length) {
                    TimeLapseSlider.this.updatePosition(newPosition);
                }
            }
        });
    }

    public void updateActions() {
        if (!this.inActionUpdate && this.next != null && this.previous != null) {
            if (this.positioner == null || !this.positioner.isEnabled()) {
                this.next.setEnabled(this.revisions == null ? false : this.position + 1 < this.revisions.length);
                this.previous.setEnabled(this.position > 0);
            } else {
                this.next.setEnabled(this.positioner.hasNextPosition(this.position));
                this.previous.setEnabled(this.positioner.hasPreviousPosition(this.position));
            }
        }
    }

    private int computeTickStart(int position) {
        int start = 0;
        int i = 0;
        while (i < position) {
            start += this.spaces[i];
            ++i;
        }
        return start;
    }

    private int computeHeightHint() {
        int height = 22;
        int textHeight = 5;
        if (this.sliderFont != null) {
            GC gc = new GC((Drawable)this.slider);
            try {
                gc.setFont(this.sliderFont);
                FontMetrics metrics = gc.getFontMetrics();
                textHeight = metrics.getHeight();
            }
            finally {
                gc.dispose();
            }
        }
        return height += textHeight + 2;
    }

    private void updateSliderHeight(boolean layout) {
        GridData sliderData = (GridData)this.slider.getLayoutData();
        sliderData.heightHint = this.drawDecorations ? this.decoratorY + 16 : this.decoratorY;
        if (layout) {
            Composite parent = this.slider.getParent();
            if (parent.getParent() != null) {
                parent.getParent().layout(true, true);
            } else {
                parent.layout(true, true);
            }
        }
    }

    private void createBar(Composite parent) {
        this.slider = new Canvas(parent, 0x20080000);
        this.moveCursor = new Cursor((Device)this.slider.getDisplay(), 9);
        P4UIUtils.registerDisposal((Widget)this.slider, (Resource)this.moveCursor);
        this.markBg = new Color((Device)this.slider.getDisplay(), MARK_BG);
        this.inactiveTickBg = this.slider.getDisplay().getSystemColor(16);
        this.sliderFont = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        P4UIUtils.registerDisposal((Widget)this.slider, (Resource)this.markBg);
        final Image sliderBg = PerforceUIPlugin.imageDescriptorFromPlugin((String)"com.perforce.team.ui", (String)SLIDER_BG_PATH).createImage();
        final Rectangle sliderBgBounds = sliderBg.getBounds();
        P4UIUtils.registerDisposal((Widget)this.slider, (Resource)sliderBg);
        final Image grabberFg = PerforceUIPlugin.imageDescriptorFromPlugin((String)"com.perforce.team.ui", (String)GRABBER_FG_PATH).createImage();
        final Rectangle grabberFgBounds = grabberFg.getBounds();
        P4UIUtils.registerDisposal((Widget)this.slider, (Resource)grabberFg);
        GridData sliderData = new GridData(4, 4, true, true);
        this.decoratorY = this.computeHeightHint();
        this.slider.setLayoutData((Object)sliderData);
        this.updateSliderHeight(false);
        this.slider.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point size = TimeLapseSlider.this.slider.getSize();
                if (TimeLapseSlider.this.buffer != null) {
                    Rectangle r = TimeLapseSlider.this.buffer.getBounds();
                    if (r.width != size.x || r.height != size.y) {
                        TimeLapseSlider.this.buffer.dispose();
                        TimeLapseSlider.this.buffer = null;
                    }
                }
                if (TimeLapseSlider.this.buffer == null) {
                    TimeLapseSlider.this.buffer = new Image((Device)e.display, size.x, size.y);
                }
                GC gc = new GC((Drawable)TimeLapseSlider.this.buffer);
                try {
                    gc.setFont(TimeLapseSlider.this.sliderFont);
                    gc.setBackground(e.gc.getBackground());
                    gc.fillRectangle(0, 0, size.x, size.y);
                    gc.drawImage(sliderBg, 0, 0, sliderBgBounds.width, sliderBgBounds.height, 15, 5, size.x - 20, 13);
                    gc.setFont(TimeLapseSlider.this.sliderFont);
                    gc.setForeground(e.display.getSystemColor(2));
                    gc.drawRectangle(15, 5, size.x - 20, 13);
                    TimeLapseSlider.this.spaces = TimeLapseSlider.this.getTickSpacing(size.x);
                    int tickStart = TimeLapseSlider.this.getTickStart(size.x);
                    Color black = e.display.getSystemColor(2);
                    gc.setForeground(black);
                    TimeLapseSlider.this.paintSlider(e, gc, tickStart, size, black, TimeLapseSlider.this.type);
                    int grabberPosition = TimeLapseSlider.this.getGrabPosition(size.x);
                    gc.drawImage(grabberFg, 0, 0, grabberFgBounds.width, grabberFgBounds.height, grabberPosition - 4, 4, 9, 16);
                    e.gc.drawImage(TimeLapseSlider.this.buffer, 0, 0);
                }
                finally {
                    gc.dispose();
                }
            }
        });
        this.slider.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                TimeLapseSlider.this.mouseDown = false;
                TimeLapseSlider.this.updateCursor(e);
            }

            public void mouseDown(MouseEvent e) {
                TimeLapseSlider.this.mouseDown = true;
                TimeLapseSlider.this.updateCursor(e);
            }

            public void mouseDoubleClick(MouseEvent e) {
                TimeLapseSlider.this.mouseDown = false;
                TimeLapseSlider.this.updateCursor(e);
                TimeLapseSlider.this.changePosition(e);
            }
        });
        this.slider.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TimeLapseSlider.this.updateCursor(e);
                if (TimeLapseSlider.this.draggingGrab()) {
                    TimeLapseSlider.this.changePosition(e);
                }
            }
        });
    }

    private void paintSlider(PaintEvent e, GC gc, int tickStart, Point size, Color black, IAnnotateModel.Type type) {
        int space = 0;
        int lastX = 0;
        int currTick = tickStart;
        if (this.formatter == null) {
            IP4Revision[] iP4RevisionArray = this.revisions;
            int n = this.revisions.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Revision revision = iP4RevisionArray[n2];
                lastX = this.drawTick(size.x, currTick, gc, lastX, revision, type);
                currTick += this.spaces[space];
                ++space;
                ++n2;
            }
            this.drawTick(size.x, tickStart + this.computeTickStart(this.position), gc, black, -1, this.revisions[this.position], type);
        } else {
            int i = 0;
            while (i < this.revisions.length) {
                Color bg = this.formatter.format(this.revisions[i], i, e);
                lastX = this.drawTick(size.x, currTick, gc, bg, lastX, this.revisions[i], type);
                currTick += this.spaces[space];
                ++space;
                ++i;
            }
            Color bg = this.formatter.format(this.revisions[this.position], this.position, e);
            if (bg == null || bg == e.display.getSystemColor(16)) {
                bg = black;
            }
            this.drawTick(size.x, tickStart + this.computeTickStart(this.position), gc, bg, -1, this.revisions[this.position], type);
        }
    }

    private int drawTick(int width, int x, GC gc, String text, Color color, int lastEndX, IP4Revision revision) {
        int endX = lastEndX;
        gc.setForeground(color);
        gc.drawLine(x, 14, x, 18);
        gc.drawLine(x, 18, x, 22);
        int size = gc.stringExtent((String)text).x + 4;
        int tickX = x - size / 2 + 2;
        if (tickX < 0) {
            tickX = 1;
        } else if (x + size > width) {
            tickX = width - size;
        }
        if (tickX > lastEndX) {
            if (this.drawDecorations && this.decorator != null) {
                this.decorator.decorate(revision, x, this.decoratorY, gc);
            }
            endX = tickX + size;
            gc.drawText(text, tickX, 24);
        }
        return endX;
    }

    private int drawTick(int width, int x, GC gc, Color color, int lastEndX, IP4Revision revision, IAnnotateModel.Type type) {
        switch (type) {
            case REVISION: {
                return this.drawTick(width, x, gc, Integer.toString(revision.getRevision()), color, lastEndX, revision);
            }
            case CHANGELIST: {
                return this.drawTick(width, x, gc, Integer.toString(revision.getChangelist()), color, lastEndX, revision);
            }
            case DATE: {
                return this.drawTick(width, x, gc, TimeLapseUtils.format(revision.getTimestamp()), color, lastEndX, revision);
            }
        }
        return 0;
    }

    private int drawTick(int width, int x, GC gc, int lastEndX, IP4Revision revision, IAnnotateModel.Type type) {
        return this.drawTick(width, x, gc, this.inactiveTickBg, lastEndX, revision, type);
    }

    private void changePosition(MouseEvent e) {
        int closest = this.getClosestPosition(e);
        this.updatePosition(closest);
    }

    private int getClosestPosition(MouseEvent e) {
        int start;
        Point size = this.slider.getSize();
        int current = start = this.getTickStart(size.x);
        int closest = 0;
        int space = 0;
        while (current < e.x && closest < this.revisions.length) {
            int spacing = this.spaces[space];
            if (e.x <= current + spacing / 2) break;
            ++closest;
            current += spacing;
            ++space;
        }
        closest = Math.min(this.revisions.length - 1, closest);
        return closest;
    }

    private boolean draggingGrab() {
        return this.mouseDown && this.currentCursor == this.moveCursor;
    }

    private void updateCursor(MouseEvent e) {
        if (this.overGrab(e)) {
            this.currentCursor = this.moveCursor;
            this.slider.setCursor(this.currentCursor);
        } else if (!this.mouseDown && this.currentCursor == this.moveCursor) {
            this.currentCursor = null;
            this.slider.setCursor(this.currentCursor);
        }
    }

    private boolean overGrab(MouseEvent e) {
        Point size = this.slider.getSize();
        int grabberX = this.getGrabPosition(size.x) - 4;
        return e.x >= grabberX && e.x <= grabberX + 9 && e.y >= 4 && e.y <= 20;
    }

    public void setDrawDecorations(boolean draw) {
        this.drawDecorations = draw;
        if (this.slider != null) {
            this.updateSliderHeight(true);
        }
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.verticalSpacing = 2;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createToolbar(this.displayArea);
        this.createBar(this.displayArea);
        this.updateActions();
    }

    public static interface IRevisionListener {
        public void revisionChanged(IP4Revision var1);

        public void displayChanged(IAnnotateModel.Type var1);
    }
}

