/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.timelapse;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.preferences.IPreferenceHandler;
import com.perforce.team.ui.timelapse.IContextHandler;
import com.perforce.team.ui.views.SessionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public final class TimeLapseRegistry {
    public static final String TIMELAPSE_EXTENSION_POINT = "com.perforce.team.ui.timelapse";
    public static final String CONTENT_TYPE_ELEMENT = "contentType";
    public static final String EDITOR_ELEMENT = "editor";
    public static final String CONTEXT_HANDLER_ELEMENT = "contextHandler";
    public static final String PREFERENCE_HANDLER_ELEMENT = "preferenceHandler";
    public static final String ID_ATTRIBUTE = "id";
    public static final String CLASS_ATTRIBUTE = "class";
    private static TimeLapseRegistry registry;
    private Map<String, Entry> typeToEditors = new HashMap<String, Entry>();

    public static synchronized TimeLapseRegistry getRegistry() {
        if (registry == null) {
            registry = new TimeLapseRegistry();
        }
        return registry;
    }

    private TimeLapseRegistry() {
        this.loadExtensionPoints();
    }

    public String[] getContentTypes() {
        Set<String> types = this.typeToEditors.keySet();
        return types.toArray(new String[types.size()]);
    }

    public String getEditorId(IFile file) {
        String editor = null;
        if (file != null) {
            try {
                IContentDescription description = file.getContentDescription();
                if (description != null) {
                    editor = this.getEditorId(description.getContentType());
                }
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return editor;
    }

    public String getEditorId(IContentType type) {
        return this.getEditorId(type, true);
    }

    public String getEditorId(IContentType type, boolean checkBaseType) {
        String editor = null;
        if (type != null) {
            editor = this.getEditorId(type.getId());
            if (checkBaseType && editor == null) {
                editor = this.getEditorId(type.getBaseType());
            }
        }
        return editor;
    }

    public String getEditorId(String contentType) {
        return this.getEditorId(contentType, true);
    }

    public String getEditorId(String contentType, boolean checkIfDisabled) {
        String[] disabled;
        if (checkIfDisabled && contentType != null && Arrays.asList(disabled = SessionManager.getEntries("com.perforce.team.ui.preferences.DISABLED_TIMELAPSE_CONTENT_TYPES")).contains(contentType)) {
            contentType = null;
        }
        return this.getEditor(contentType);
    }

    public IContextHandler getHandler(IFile file) {
        IContextHandler handler = null;
        if (file != null) {
            try {
                IContentDescription description = file.getContentDescription();
                if (description != null) {
                    handler = this.getHandler(description.getContentType());
                }
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return handler;
    }

    public IContextHandler getHandler(IContentType type) {
        return type != null ? this.getHandler(type.getId()) : null;
    }

    public IContextHandler getHandler(String contentType) {
        Entry entry = null;
        if (contentType != null) {
            entry = this.typeToEditors.get(contentType);
        }
        return entry != null ? entry.handler : null;
    }

    public IPreferenceHandler[] getPreferenceHandlers() {
        ArrayList<IPreferenceHandler> handlers = new ArrayList<IPreferenceHandler>();
        for (Entry entry : this.typeToEditors.values()) {
            if (entry.prefHandler == null) continue;
            handlers.add(entry.prefHandler);
        }
        return handlers.toArray(new IPreferenceHandler[handlers.size()]);
    }

    private String getEditor(String contentType) {
        Entry entry = null;
        if (contentType != null) {
            entry = this.typeToEditors.get(contentType);
        }
        return entry != null ? entry.editorId : null;
    }

    private void loadExtensionPoints() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TIMELAPSE_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (EDITOR_ELEMENT.equals(element.getName()) && (id = element.getAttribute(ID_ATTRIBUTE)) != null) {
                IConfigurationElement[] types;
                String handlerClass;
                String handlerClass2;
                IContextHandler handler = null;
                IConfigurationElement[] handlers = element.getChildren(CONTEXT_HANDLER_ELEMENT);
                if (handlers.length > 0 && (handlerClass2 = handlers[0].getAttribute(CLASS_ATTRIBUTE)) != null) {
                    try {
                        Object possibleHandler = handlers[0].createExecutableExtension(CLASS_ATTRIBUTE);
                        if (possibleHandler instanceof IContextHandler) {
                            handler = (IContextHandler)possibleHandler;
                        }
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                }
                IPreferenceHandler prefHandler = null;
                IConfigurationElement[] prefHandlers = element.getChildren(PREFERENCE_HANDLER_ELEMENT);
                if (prefHandlers.length > 0 && (handlerClass = prefHandlers[0].getAttribute(CLASS_ATTRIBUTE)) != null) {
                    try {
                        Object possibleHandler = prefHandlers[0].createExecutableExtension(CLASS_ATTRIBUTE);
                        if (possibleHandler instanceof IPreferenceHandler) {
                            prefHandler = (IPreferenceHandler)possibleHandler;
                        }
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                }
                IConfigurationElement[] iConfigurationElementArray2 = types = element.getChildren(CONTENT_TYPE_ELEMENT);
                int n3 = types.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement typeElement = iConfigurationElementArray2[n4];
                    String typeId = typeElement.getAttribute(ID_ATTRIBUTE);
                    if (typeId != null) {
                        Entry entry = new Entry();
                        entry.handler = handler;
                        entry.prefHandler = prefHandler;
                        entry.editorId = id;
                        this.typeToEditors.put(typeId, entry);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static class Entry {
        String editorId;
        IContextHandler handler;
        IPreferenceHandler prefHandler;

        private Entry() {
        }
    }
}

