/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.timelapse;

import com.perforce.team.ui.LabelProviderAdapter;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.preferences.IPreferenceHandler;
import com.perforce.team.ui.timelapse.Messages;
import com.perforce.team.ui.timelapse.TimeLapseRegistry;
import com.perforce.team.ui.views.SessionManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TimeLapsePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.perforce.team.ui.timelapse.TimeLapsePreferencePage";
    private Button p4vButton;
    private Button textButton;
    private BooleanFieldEditor showChangelistButton;
    private BooleanFieldEditor showBranchesButton;
    private BooleanFieldEditor showActionsButton;
    private List<IContentType> contentTypes;
    private CheckboxTableViewer typeViewer;
    private IPreferenceHandler[] handlers = TimeLapseRegistry.getRegistry().getPreferenceHandlers();

    protected Control createContents(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        displayArea.setLayout((Layout)daLayout);
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        boolean internal = this.getPreferenceStore().getBoolean("com.perforce.team.ui.preferences.USE_INTERNAL_TIMELAPSE");
        this.p4vButton = new Button(displayArea, 16);
        this.p4vButton.setText(Messages.TimeLapsePreferencePage_UseP4VCTimelapse);
        this.p4vButton.setSelection(!internal);
        this.textButton = new Button(displayArea, 16);
        this.textButton.setText(Messages.TimeLapsePreferencePage_UseInternalTimelapse);
        this.textButton.setSelection(internal);
        this.createContentTable(displayArea);
        this.showChangelistButton = new BooleanFieldEditor("com.perforce.team.ui.timelapse.SHOW_CHANGELIST", Messages.TimeLapsePreferencePage_ShowChangelistDetails, displayArea);
        this.showChangelistButton.setPreferenceStore(this.getPreferenceStore());
        this.showChangelistButton.load();
        this.showBranchesButton = new BooleanFieldEditor("com.perforce.team.ui.timelapse.SHOW_BRANCH_HISTORY", Messages.TimeLapsePreferencePage_ShowBranchingHistory, displayArea);
        this.showBranchesButton.setPreferenceStore(this.getPreferenceStore());
        this.showBranchesButton.load();
        this.showActionsButton = new BooleanFieldEditor("com.perforce.team.ui.timelapse.SHOW_FILE_ACTIONS", Messages.TimeLapsePreferencePage_ShowFileActionsInSlider, displayArea);
        this.showActionsButton.setPreferenceStore(this.getPreferenceStore());
        this.showActionsButton.load();
        IPreferenceHandler[] iPreferenceHandlerArray = this.handlers;
        int n = this.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceHandler handler = iPreferenceHandlerArray[n2];
            handler.addControls(displayArea);
            ++n2;
        }
        return displayArea;
    }

    private void createContentTable(Composite parent) {
        String[] disabled;
        Group languageGroup = new Group(parent, 0);
        languageGroup.setText(Messages.TimeLapsePreferencePage_AvailableContentTypeSpecificTimelapseViews);
        GridLayout lgLayout = new GridLayout(1, true);
        lgLayout.marginWidth = 0;
        lgLayout.marginHeight = 0;
        languageGroup.setLayout((Layout)lgLayout);
        languageGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.typeViewer = CheckboxTableViewer.newCheckList((Composite)languageGroup, (int)2820);
        this.typeViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        LabelProviderAdapter labelProvider = new LabelProviderAdapter(){

            public String getText(Object element) {
                if (element instanceof IContentType) {
                    return ((IContentType)element).getName();
                }
                return "";
            }
        };
        this.typeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeViewer.setSorter(new ViewerSorter());
        IContentTypeManager manager = Platform.getContentTypeManager();
        this.contentTypes = new ArrayList<IContentType>();
        String[] stringArray = TimeLapseRegistry.getRegistry().getContentTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            IContentType cType = manager.getContentType(type);
            if (cType != null) {
                this.contentTypes.add(cType);
            }
            ++n2;
        }
        this.typeViewer.setInput(this.contentTypes);
        this.typeViewer.setAllChecked(true);
        String[] stringArray2 = disabled = SessionManager.getEntries("com.perforce.team.ui.preferences.DISABLED_TIMELAPSE_CONTENT_TYPES");
        int n3 = disabled.length;
        n = 0;
        while (n < n3) {
            String disable = stringArray2[n];
            IContentType cType = manager.getContentType(disable);
            if (cType != null) {
                this.typeViewer.setChecked((Object)cType, false);
            }
            ++n;
        }
    }

    protected void performDefaults() {
        boolean internal = this.getPreferenceStore().getDefaultBoolean("com.perforce.team.ui.preferences.USE_INTERNAL_TIMELAPSE");
        this.textButton.setSelection(internal);
        this.p4vButton.setSelection(!internal);
        this.typeViewer.setAllChecked(true);
        this.showBranchesButton.loadDefault();
        this.showChangelistButton.loadDefault();
        this.showActionsButton.loadDefault();
        IPreferenceHandler[] iPreferenceHandlerArray = this.handlers;
        int n = this.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceHandler handler = iPreferenceHandlerArray[n2];
            handler.defaults();
            ++n2;
        }
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        this.getPreferenceStore().setValue("com.perforce.team.ui.preferences.USE_INTERNAL_TIMELAPSE", this.textButton.getSelection());
        ArrayList<String> disabled = new ArrayList<String>();
        for (IContentType type : this.contentTypes) {
            if (this.typeViewer.getChecked((Object)type)) continue;
            disabled.add(type.getId());
        }
        this.showBranchesButton.store();
        this.showChangelistButton.store();
        this.showActionsButton.store();
        SessionManager.saveEntries(disabled, "com.perforce.team.ui.preferences.DISABLED_TIMELAPSE_CONTENT_TYPES");
        IPreferenceHandler[] iPreferenceHandlerArray = this.handlers;
        int n = this.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceHandler handler = iPreferenceHandlerArray[n2];
            handler.save();
            ++n2;
        }
        return ok;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(PerforceUIPlugin.getPlugin().getPreferenceStore());
    }
}

