/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.synchronize;

import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.synchronize.CheckConsistencyModelOperation;
import com.perforce.team.ui.synchronize.CommitModelOperation;
import com.perforce.team.ui.synchronize.HistoryModelOperation;
import com.perforce.team.ui.synchronize.Messages;
import com.perforce.team.ui.synchronize.ReopenModelOperation;
import com.perforce.team.ui.synchronize.ResolveModelOperation;
import com.perforce.team.ui.synchronize.RevertModelOperation;
import com.perforce.team.ui.synchronize.RevertUnchangedModelOperation;
import com.perforce.team.ui.synchronize.ShelveModelOperation;
import com.perforce.team.ui.synchronize.TimeLapseModelOperation;
import com.perforce.team.ui.synchronize.UpdateModelOperation;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;

public class PerforceSyncActionGroup
extends SynchronizePageActionGroup {
    public static final String FILE_ACTION_GROUP = "perforce_file_group";
    public static final String OTHER_ACTION_GROUP = "perforce_other_group";
    private Action history;
    private Action expandAll;
    private Action revert;
    private Action revertUnchanged;
    private Action commit;
    private Action update;
    private Action commitAll;
    private Action updateAll;
    private Action resolve;
    private Action reopen;
    private Action shelve;
    private Action timelapse;
    private Action consistency;

    private void createToolbarActions(final ISynchronizePageConfiguration configuration) {
        this.expandAll = new Action(){

            public void run() {
                Viewer viewer = configuration.getPage().getViewer();
                if (viewer instanceof AbstractTreeViewer) {
                    ((AbstractTreeViewer)viewer).expandAll();
                }
            }
        };
        this.expandAll.setText(Messages.PerforceSyncActionGroup_ExpandAll);
        this.expandAll.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/expandall.png"));
        this.updateAll = new SynchronizeModelAction(Messages.PerforceSyncActionGroup_UpdateAll, configuration, this.getVisibleRootsSelectionProvider()){

            protected FastSyncInfoFilter getSyncInfoFilter() {
                return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8});
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new UpdateModelOperation(configuration, elements);
            }
        };
        this.updateAll.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/update_all.png"));
        this.commitAll = new SynchronizeModelAction(Messages.PerforceSyncActionGroup_SubmitAll, configuration, this.getVisibleRootsSelectionProvider()){

            protected FastSyncInfoFilter getSyncInfoFilter() {
                return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4});
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new CommitModelOperation(configuration, elements, this.getStructuredSelection());
            }
        };
        this.commitAll.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/commit_all.png"));
    }

    private void createMenuActions(ISynchronizePageConfiguration configuration) {
        this.commit = new SynchronizeModelAction(Messages.PerforceSyncActionGroup_Submit, configuration){

            protected FastSyncInfoFilter getSyncInfoFilter() {
                return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4});
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new CommitModelOperation(configuration, elements, this.getStructuredSelection());
            }
        };
        this.commit.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/submit.png"));
        this.revert = new SynchronizeModelAction(Messages.PerforceSyncActionGroup_Revert, configuration){

            protected FastSyncInfoFilter getSyncInfoFilter() {
                return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 12});
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new RevertModelOperation(configuration, elements);
            }
        };
        this.revert.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/revert.png"));
        this.revertUnchanged = new SynchronizeModelAction(Messages.PerforceSyncActionGroup_RevertUnchanged, configuration){

            protected FastSyncInfoFilter getSyncInfoFilter() {
                return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4});
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new RevertUnchangedModelOperation(configuration, elements);
            }
        };
        this.update = new SynchronizeModelAction(Messages.PerforceSyncActionGroup_Update, configuration){

            protected FastSyncInfoFilter getSyncInfoFilter() {
                return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8});
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new UpdateModelOperation(configuration, elements);
            }
        };
        this.update.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/sync.png"));
        this.resolve = new SynchronizeModelAction(Messages.PerforceSyncActionGroup_Resolve, configuration){

            protected FastSyncInfoFilter getSyncInfoFilter() {
                return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{12});
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new ResolveModelOperation(configuration, elements);
            }
        };
        this.resolve.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/resolve.png"));
        this.history = new SynchronizeModelAction(Messages.PerforceSyncActionGroup_RevisionHistory, configuration){

            protected boolean updateSelection(IStructuredSelection selection) {
                Object element;
                if (selection != null) {
                    super.updateSelection(selection);
                }
                if (selection != null && selection.size() == 1 && (element = selection.getFirstElement()) instanceof ISynchronizeModelElement) {
                    return ((ISynchronizeModelElement)element).getKind() != 0;
                }
                return false;
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new HistoryModelOperation(configuration, elements);
            }
        };
        this.history.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("views/history.png"));
        this.reopen = new SynchronizeModelAction(Messages.PerforceSyncActionGroup_MoveToChangelist, configuration){

            protected FastSyncInfoFilter getSyncInfoFilter() {
                return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 12});
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new ReopenModelOperation(configuration, elements);
            }
        };
        this.shelve = new SynchronizeModelAction(Messages.PerforceSyncActionGroup_Shelve, configuration){

            protected FastSyncInfoFilter getSyncInfoFilter() {
                return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4});
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new ShelveModelOperation(configuration, elements);
            }
        };
        this.shelve.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/shelve.png"));
        this.timelapse = new SynchronizeModelAction(Messages.PerforceSyncActionGroup_TimelapseView, configuration){

            protected boolean updateSelection(IStructuredSelection selection) {
                Object element;
                if (selection != null) {
                    super.updateSelection(selection);
                }
                if (selection != null && selection.size() == 1 && (element = selection.getFirstElement()) instanceof ISynchronizeModelElement) {
                    return ((ISynchronizeModelElement)element).getKind() != 0;
                }
                return false;
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new TimeLapseModelOperation(configuration, elements);
            }
        };
        this.timelapse.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/time_lapse.png"));
        this.consistency = new SynchronizeModelAction(Messages.PerforceSyncActionGroup_CheckConsistency, configuration){

            protected boolean updateSelection(IStructuredSelection selection) {
                boolean enabled = super.updateSelection(selection);
                if (enabled) {
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof ChangeSetDiffNode) {
                            enabled = false;
                            break;
                        }
                        ++n2;
                    }
                }
                return enabled;
            }

            protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                return new CheckConsistencyModelOperation(configuration, elements);
            }
        };
        this.consistency.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/check_consistency.png"));
    }

    public void initialize(ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        this.createToolbarActions(configuration);
        this.createMenuActions(configuration);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.appendToGroup((IContributionManager)actionBars.getToolBarManager(), "navigate", (IAction)this.expandAll);
        this.appendToGroup((IContributionManager)actionBars.getToolBarManager(), "synchronize", (IAction)this.commitAll);
        this.appendToGroup((IContributionManager)actionBars.getToolBarManager(), "synchronize", (IAction)this.updateAll);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator(FILE_ACTION_GROUP));
        menu.add((IAction)this.commit);
        menu.add((IAction)this.resolve);
        menu.add((IAction)this.revert);
        menu.add((IAction)this.revertUnchanged);
        menu.add((IAction)this.update);
        menu.add((IAction)this.reopen);
        menu.add((IContributionItem)new Separator(OTHER_ACTION_GROUP));
        menu.add((IAction)this.consistency);
        menu.add((IAction)this.history);
        menu.add((IAction)this.shelve);
        menu.add((IAction)this.timelapse);
    }
}

