/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swt;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PageBook
extends Composite {
    private BookPage currentPage = null;

    public PageBook(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new PageBookLayout());
    }

    public void showPage(BookPage page) {
        System.out.println("showPage(Control) " + (Object)((Object)page));
        if (page.isDisposed() || page.getParent() != this) {
            return;
        }
        this.currentPage = page;
        page.setVisible(true);
        this.layout(true);
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != page && !child.isDisposed()) {
                child.setVisible(false);
            }
            ++i;
        }
    }

    public BookPage showPageById(Object id) {
        System.out.println("showPage(Object) " + id);
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            BookPage page;
            Control c = controlArray[n2];
            if (c instanceof BookPage && (page = (BookPage)c).getId().equals(id)) {
                this.showPage(page);
                return page;
            }
            ++n2;
        }
        return null;
    }

    public BookPage getActivePage() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof BookPage && c.isVisible()) {
                return (BookPage)c;
            }
            ++n2;
        }
        return null;
    }

    public void setInput(Object input) {
        BookPage p = this.getActivePage();
        if (p != null) {
            p.setInput(input);
        }
    }

    public static abstract class BookPage
    extends Composite {
        public BookPage(Composite parent, int style) {
            super(parent, style);
        }

        protected final void init(Object input) {
            this.createControl();
            this.addListeners();
            this.setInput(input);
        }

        public void setInput(Object input) {
        }

        public abstract void createControl();

        public abstract Object getId();

        public void addListeners() {
        }
    }

    public class PageBookLayout
    extends Layout {
        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point result = null;
            result = PageBook.this.currentPage != null ? PageBook.this.currentPage.computeSize(wHint, hHint, flushCache) : new Point(0, 0);
            if (wHint != -1) {
                result.x = wHint;
            }
            if (hHint != -1) {
                result.y = hHint;
            }
            return result;
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (PageBook.this.currentPage != null) {
                PageBook.this.currentPage.setBounds(composite.getClientArea());
            }
        }
    }
}

