/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview.action;

import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.swarmreview.action.PendingReviewAction;
import com.perforce.team.ui.swarmreview.dialogs.UpdatePendingReviewDialog;
import com.perforce.team.ui.swarmreview.restapi.Result;
import org.eclipse.core.runtime.IProgressMonitor;

public class UpdatePendingReviewAction
extends PendingReviewAction {
    @Override
    protected void runAction() {
        try {
            final IP4PendingChangelist pendingChangeList = (IP4PendingChangelist)this.getSelection().toList().get(0);
            IP4Resource[] selectedItems = pendingChangeList.getAllMembers();
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    UpdatePendingReviewAction.this.showNoOpenedFilesDialog(pendingChangeList);
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void showNoOpenedFilesDialog(final IP4PendingChangelist pendingChangeList) {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                UpdatePendingReviewAction.this.initSwarmController(pendingChangeList, true);
                UpdatePendingReviewDialog usrd = new UpdatePendingReviewDialog(UpdatePendingReviewAction.this.getShell());
                usrd.setController(UpdatePendingReviewAction.this.controller);
                if (usrd.open() != 0) {
                    return;
                }
                if (usrd.isRevertChecked()) {
                    UpdatePendingReviewAction.this.revertFiles(usrd.getCheckedFiles(), usrd.isRemoveChecked());
                }
            }
        });
    }

    @Override
    public boolean isEnabledEx() {
        boolean enabled = false;
        IP4PendingChangelist pendingChangeList = this.getCurrentSelection();
        if (pendingChangeList != null) {
            this.initSwarmController(pendingChangeList, false);
            Result<Boolean> result = this.controller.isChangeListCandidateForUpdateReview(pendingChangeList);
            enabled = result.isSuccessful();
            if (!result.isSuccessful()) {
                result.isReportInSilence();
            }
        }
        return enabled;
    }
}

