/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.submitted;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.ui.dialogs.PerforceDialog;
import com.perforce.team.ui.submitted.Messages;
import com.perforce.team.ui.submitted.SubmittedChangelistTable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SubmittedChangelistDialog
extends PerforceDialog {
    private Composite displayArea;
    private SubmittedChangelistTable table;
    private IP4Connection connection = null;
    private IP4SubmittedChangelist[] selected = new IP4SubmittedChangelist[0];
    private boolean single = false;

    public SubmittedChangelistDialog(Shell parent, IP4Connection connection) {
        super(parent, Messages.SubmittedChangelistDialog_SelectSubmittedChangelist);
        this.setModalResizeStyle();
        this.connection = connection;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.displayArea = new Composite(c, 0);
        GridLayout daLayout = new GridLayout(1, true);
        this.displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        daData.heightHint = 500;
        daData.widthHint = 600;
        this.displayArea.setLayoutData((Object)daData);
        this.table = new SubmittedChangelistTable(null, null, null, false);
        this.table.createPartControl(this.displayArea, this.single ? 4 : 2);
        this.table.showDisplayDetails(true);
        this.table.showChangelists((IP4Resource)this.connection);
        this.table.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SubmittedChangelistDialog.this.okPressed();
            }
        });
        return c;
    }

    public SubmittedChangelistTable getTable() {
        return this.table;
    }

    public void updateSelectedChangelists() {
        this.selected = this.table.getSelectedChangelists();
    }

    public IP4SubmittedChangelist[] getSelected() {
        return this.selected;
    }

    protected void okPressed() {
        this.updateSelectedChangelists();
        super.okPressed();
    }

    public void setSingle(boolean single) {
        this.single = single;
    }
}

