/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams.wizard;

import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.option.server.GetStreamsOptions;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.streams.Messages;
import com.perforce.team.ui.streams.StreamUtil;
import com.perforce.team.ui.streams.StreamsSuggestProvider;
import com.perforce.team.ui.streams.SuggestBox;
import com.perforce.team.ui.streams.wizard.ChangeableWriteValue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.progress.UIJob;

public class StreamParentSelectionWidget
extends Composite {
    private IP4Connection connection;
    private StreamsSuggestProvider provider;
    private SuggestBox streamCombo;
    private Combo depotCombo;
    private Label depotLabel;
    private Label streamLabel;
    private ChangeableWriteValue locationValue = new ChangeableWriteValue();
    private IStream stream;
    private IRunnableContext context;
    private SelectionListener depotListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StreamParentSelectionWidget.this.updateLocationValue();
        }
    };

    public WritableValue getLocationValue() {
        return this.locationValue;
    }

    public StreamParentSelectionWidget(Composite parent, int style, IP4Connection conn, IRunnableContext context) {
        super(parent, style);
        this.connection = conn;
        this.context = context;
        this.provider = new StreamsSuggestProvider(this.connection){

            @Override
            protected List<String> initPaths(String filter) {
                ArrayList<String> paths = null;
                if (filter.startsWith("//")) {
                    paths = new ArrayList();
                    String path = filter;
                    path = filter.length() > 2 ? (!filter.substring(2).contains("/") ? (filter.endsWith("*") ? String.valueOf(filter) + "/*" : String.valueOf(filter) + "*/*") : (filter.endsWith("*") ? filter : String.valueOf(filter) + "*")) : String.valueOf(filter) + "...";
                    paths.add(path);
                    return paths;
                }
                paths = super.initPaths(filter);
                return paths;
            }

            @Override
            public List<Object> fetchElement(String filter) {
                List<Object> fetchElements = super.fetchElement(filter);
                ArrayList<Object> result = new ArrayList<Object>();
                for (Object obj : fetchElements) {
                    if (obj instanceof IStreamSummary && ((IStreamSummary)obj).getType() == IStreamSummary.Type.TASK && StreamParentSelectionWidget.this.stream.getType() == IStreamSummary.Type.TASK) continue;
                    result.add(obj);
                }
                return result;
            }
        };
        this.createControl(this);
    }

    private void createControl(Composite parent) {
        GridLayoutFactory.swtDefaults().margins(1, 5).applyTo(parent);
        boolean visible = true;
        this.depotLabel = new Label(parent, 0);
        this.depotLabel.setText(Messages.StreamWizard_ParentStreamToBranchFrom);
        GridDataFactory.swtDefaults().span(1, 1).align(1, 0x1000000).exclude(!visible).applyTo((Control)this.depotLabel);
        this.depotCombo = new Combo(parent, 12);
        this.depotCombo.setVisible(visible);
        GridDataFactory.swtDefaults().span(1, 1).align(4, 0x1000000).grab(true, false).exclude(!visible).applyTo((Control)this.depotCombo);
        visible = false;
        this.streamLabel = new Label(parent, 0);
        this.streamLabel.setText(Messages.StreamWizard_ParentStreamToBranchFrom);
        GridDataFactory.swtDefaults().span(1, 1).align(1, 0x1000000).exclude(!visible).applyTo((Control)this.streamLabel);
        this.streamCombo = new SuggestBox(parent, 0, this.provider);
        this.streamCombo.setVisible(visible);
        GridDataFactory.swtDefaults().span(1, 1).align(4, 0x1000000).indent(10, 5).grab(true, false).exclude(!visible).applyTo((Control)this.streamCombo);
        this.addListeners();
    }

    private void addListeners() {
        this.depotCombo.addSelectionListener(this.depotListener);
        this.streamCombo.getModel().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                StreamParentSelectionWidget.this.updateLocationValue();
            }
        });
    }

    protected void updateLocationValue() {
        SuggestBox.SelectionModel model = (SuggestBox.SelectionModel)this.streamCombo.getModel().getValue();
        String depot = null;
        if (this.depotCombo.isVisible()) {
            depot = this.depotCombo.getText();
        }
        if (!this.streamCombo.getVisible()) {
            this.locationValue.setValue(depot);
        } else if (!this.depotCombo.getVisible()) {
            this.locationValue.setValue(model);
        } else {
            this.locationValue.setValue(new TaskStreamModel(depot, model));
        }
    }

    public void setType(IStreamSummary.Type childType) {
        this.setType(childType, true);
    }

    private void setType(IStreamSummary.Type childType, boolean propagateChange) {
        if (childType == IStreamSummary.Type.MAINLINE) {
            int index;
            this.depotLabel.setText(Messages.StreamWizard_DepotMainlineStreamLocated);
            this.showControl(true, (Control)this.depotLabel);
            this.showControl(true, (Control)this.depotCombo);
            this.showControl(false, (Control)this.streamLabel);
            this.showControl(false, (Control)this.streamCombo);
            String parent = null;
            if (this.stream != null) {
                IStream sum = this.stream;
                parent = StreamUtil.getDepotName((IStreamSummary)sum);
            }
            if (propagateChange) {
                parent = this.depotCombo.getText();
            }
            if (parent != null && (index = ArrayUtils.indexOf((Object[])this.depotCombo.getItems(), (Object)parent)) >= 0) {
                this.depotCombo.select(index);
            }
            if (propagateChange) {
                this.locationValue.setValue(parent);
            }
        } else if (childType == IStreamSummary.Type.VIRTUAL) {
            this.streamLabel.setText(Messages.StreamWizard_ParentStreamToSourceFrom);
            this.showControl(false, (Control)this.depotLabel);
            this.showControl(false, (Control)this.depotCombo);
            this.showStreamCombo();
        } else if (childType == IStreamSummary.Type.DEVELOPMENT || childType == IStreamSummary.Type.RELEASE) {
            this.streamLabel.setText(Messages.StreamWizard_ParentStreamToBranchFrom);
            this.showControl(false, (Control)this.depotLabel);
            this.showControl(false, (Control)this.depotCombo);
            this.showStreamCombo();
        } else if (childType == IStreamSummary.Type.TASK) {
            this.depotLabel.setText(Messages.StreamWizard_DepotTaskStreamLocated);
            this.showControl(true, (Control)this.depotLabel);
            this.showControl(true, (Control)this.depotCombo);
            this.streamLabel.setText(Messages.StreamWizard_ParentStreamToBranchFrom);
            this.showControl(true, (Control)this.streamLabel);
            this.showControl(true, (Control)this.streamCombo);
        }
    }

    private void showControl(boolean visible, Control control) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            GridData data = (GridData)ld;
            data.exclude = !visible;
            control.setVisible(visible);
            Composite parent = control.getParent();
            if (parent != null) {
                parent.layout();
                parent = parent.getParent();
                if (parent != null) {
                    parent.layout();
                }
            }
        }
    }

    private void showStreamCombo() {
        IStreamSummary s;
        SuggestBox.SelectionModel model;
        this.showControl(true, (Control)this.streamLabel);
        this.showControl(true, (Control)this.streamCombo);
        if (this.stream != null && !StreamUtil.isParentEmpty((IStreamSummary)this.stream)) {
            IStream s2 = this.stream;
            String parent = s2.getParent();
            if (StreamUtil.isStreamPathFormat(parent)) {
                IP4Stream ps = this.connection.getStream(parent = StreamUtil.normalizeStreamPathForQuery(parent));
                if (ps != null) {
                    this.streamCombo.updateModel(new SuggestBox.SelectionModel(parent, ps.getStreamSummary()));
                } else {
                    this.streamCombo.setTextQuietlyAndUpdateModel(parent);
                }
            }
        } else if (this.stream != null && (model = (SuggestBox.SelectionModel)this.streamCombo.getModel().getValue()) != null && (s = (IStreamSummary)model.getSelection()) != null) {
            this.stream.setParent(s.getParent());
            String depot = StreamUtil.getDepot(s);
            String root = StreamUtil.getStreamRoot((IStreamSummary)this.stream);
            StreamUtil.updateStream(this.stream, root, depot);
        }
        this.updateLocationValue();
    }

    public void init(IP4Connection conn, IStream s) {
        this.stream = s;
        this.connection = conn;
        try {
            this.context.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.StreamsFilterWidget_LoadingDepots, 10);
                    monitor.worked(5);
                    P4Runner.schedule((IP4Runnable)new P4Runnable(){

                        public String getTitle() {
                            return Messages.StreamsFilterWidget_LoadingDepots;
                        }

                        public void run(IProgressMonitor monitor) {
                            try {
                                final List depots = StreamParentSelectionWidget.this.connection.getDepots();
                                GetStreamsOptions opts = new GetStreamsOptions();
                                opts.setFields("Name,Stream");
                                UIJob job = new UIJob(Messages.StreamsFilterWidget_LoadingDepots){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        monitor.done();
                                        if (StreamParentSelectionWidget.this.depotCombo.isDisposed()) {
                                            return Status.CANCEL_STATUS;
                                        }
                                        StreamParentSelectionWidget.this.depotCombo.clearSelection();
                                        StreamParentSelectionWidget.this.depotCombo.removeAll();
                                        StreamParentSelectionWidget.this.depotCombo.add("");
                                        for (IDepot depot : depots) {
                                            if (!IDepot.DepotType.STREAM.equals((Object)depot.getDepotType())) continue;
                                            StreamParentSelectionWidget.this.depotCombo.add(depot.getName());
                                        }
                                        if (StreamParentSelectionWidget.this.stream != null) {
                                            StreamParentSelectionWidget.this.setType(StreamParentSelectionWidget.this.stream.getType(), false);
                                            String parentDepot = StreamUtil.getDepotName((IStreamSummary)StreamParentSelectionWidget.this.stream);
                                            if (parentDepot != null) {
                                                StreamParentSelectionWidget.this.selectDepot(StreamParentSelectionWidget.this.depotCombo.indexOf(parentDepot), false);
                                            }
                                            StreamParentSelectionWidget.this.streamCombo.updateModel(new SuggestBox.SelectionModel(null, StreamUtil.getParentStream((IStreamSummary)StreamParentSelectionWidget.this.stream, StreamParentSelectionWidget.this.connection)));
                                        }
                                        return Status.OK_STATUS;
                                    }
                                };
                                job.schedule();
                            }
                            catch (Throwable e) {
                                PerforceProviderPlugin.logError((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.streamCombo.setEnabled(enabled);
        if (!enabled) {
            this.depotCombo.setBackground(this.getDisplay().getSystemColor(34));
        } else {
            this.depotCombo.setBackground(this.getDisplay().getSystemColor(25));
        }
    }

    private void selectDepot(int index, boolean propagateChange) {
        if (!propagateChange) {
            this.depotCombo.removeSelectionListener(this.depotListener);
        }
        this.depotCombo.select(index);
        if (!propagateChange) {
            this.depotCombo.addSelectionListener(this.depotListener);
        }
    }

    public static class TaskStreamModel {
        String depot;
        SuggestBox.SelectionModel branchStream;

        public TaskStreamModel(String depot, SuggestBox.SelectionModel parentStream) {
            this.depot = depot;
            this.branchStream = parentStream;
        }

        public String getDepot() {
            return this.depot;
        }

        public void setDepot(String depot) {
            this.depot = depot;
        }

        public SuggestBox.SelectionModel getBranchStream() {
            return this.branchStream;
        }

        public void setBranchStream(SuggestBox.SelectionModel branchStream) {
            this.branchStream = branchStream;
        }
    }
}

