/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams.wizard;

import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.dialogs.FixedWidthScrolledComposite;
import com.perforce.team.ui.streams.StreamTypeComboViewer;
import com.perforce.team.ui.streams.StreamUtil;
import com.perforce.team.ui.streams.SuggestBox;
import com.perforce.team.ui.streams.wizard.AbstractEditStreamWizardPage;
import com.perforce.team.ui.streams.wizard.Messages;
import com.perforce.team.ui.streams.wizard.PropagationOptionWidget;
import com.perforce.team.ui.streams.wizard.StreamParentSelectionWidget;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class BasicSettingPage
extends AbstractEditStreamWizardPage {
    private Text nameText;
    private StreamTypeComboViewer typeCombo;
    private PropagationOptionWidget propWidget;
    private StreamParentSelectionWidget parentWidget;
    private Text descText;
    private Button populateBtn;
    private String depotName;
    private String[] segments;

    public BasicSettingPage() {
        super(BasicSettingPage.class.getName());
        this.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/stream_wizard.png"));
        this.setTitle(Messages.BasicSettingPage_Title);
        this.setDescription(Messages.BasicSettingPage_Description);
    }

    public void createControl(Composite parent) {
        String path;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.perforce.team.ui.streams_view");
        IStream sum = this.getStream();
        FixedWidthScrolledComposite scroll = new FixedWidthScrolledComposite(parent, 512);
        scroll.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)scroll, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        SWTUtils.createLabel(composite, Messages.BasicSettingPage_StreamName);
        this.nameText = SWTUtils.createText(composite);
        if (sum != null && sum.getName() != null) {
            this.nameText.setText(sum.getName());
        }
        this.depotName = StreamUtil.getParentDepot((IStreamSummary)sum);
        if (this.depotName != null) {
            this.nameText.setText(this.depotName);
        }
        if ((path = sum.getParent()) != null) {
            this.segments = path.substring(this.depotName.length()).split("/");
        }
        SWTUtils.createLabel(composite, Messages.BasicSettingPage_StreamType);
        this.typeCombo = new StreamTypeComboViewer(composite);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo(this.typeCombo.getControl());
        this.typeCombo.setInput(IStreamSummary.Type.values());
        this.typeCombo.setConnection(this.getConnection());
        this.typeCombo.setFromStreamType(IStreamSummary.Type.UNKNOWN);
        this.typeCombo.setParentStreamType(IStreamSummary.Type.UNKNOWN);
        this.typeCombo.setDifferentParentDepot(false);
        if (this.getWizard().isEditMode()) {
            this.typeCombo.setFromStreamType(this.getStream().getType());
            IStreamSummary parentStream = StreamUtil.getParentStream((IStreamSummary)this.getStream(), this.getConnection());
            if (parentStream != null) {
                String pdepot;
                String depot = StreamUtil.getDepot((IStreamSummary)this.getStream());
                this.typeCombo.setDifferentParentDepot(!depot.equals(pdepot = StreamUtil.getDepot(parentStream)));
                this.typeCombo.setParentStreamType(parentStream.getType());
            }
        }
        if (sum != null && sum.getType() != null) {
            this.typeCombo.setSelection((ISelection)new StructuredSelection((Object)sum.getType()));
        }
        SWTUtils.createLabel(composite, Messages.BasicSettingPage_ChangePropagation);
        this.propWidget = new PropagationOptionWidget(composite, 0, this.getStream());
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.propWidget);
        this.parentWidget = new StreamParentSelectionWidget(composite, 0, this.getConnection(), (IRunnableContext)this.getWizard().getContainer());
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.parentWidget);
        this.parentWidget.init(this.getConnection(), this.getStream());
        this.enableParentWidget();
        SWTUtils.createLabel(composite, Messages.BasicSettingPage_StreamDescription);
        this.descText = SWTUtils.createTextArea(composite, 1, 1, 4);
        if (sum != null && sum.getDescription() != null) {
            this.descText.setText(sum.getDescription());
        }
        this.populateBtn = SWTUtils.createButton(composite, Messages.BasicSettingPage_BranchFromParent, 32, 1);
        GridData gd = (GridData)this.populateBtn.getLayoutData();
        gd.exclude = this.getWizard().isEditMode();
        this.populateBtn.setVisible(!this.getWizard().isEditMode());
        this.populateBtn.setSelection(!this.getWizard().isEditMode());
        scroll.setContent((Control)composite);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        Point def = composite.computeSize(-1, -1);
        scroll.setMinSize(def);
        this.setControl((Control)scroll);
        this.restoreFromSettings();
        this.addListeners();
        scroll.getContent().setEnabled(!this.getWizard().isEditMode() || !this.getWizard().isStreamLocked());
    }

    @Override
    public boolean canFlipToNextPage() {
        if (this.getWizard().isStreamLocked()) {
            return true;
        }
        return super.canFlipToNextPage();
    }

    protected void validateAndUpdate() {
        if (this.getWizard().isEditMode() && this.getWizard().isStreamLocked()) {
            this.applyToStatusLine(ValidationStatus.warning((String)this.getWizard().getStreamLockMessage()));
            return;
        }
        Tracing.printTrace((String)"StreamWizard>>", (String)StreamUtil.print(this.getStream()));
        IStatus status = this.validate();
        this.applyToStatusLine(status);
        this.getWizard().getContainer().updateButtons();
    }

    @Override
    protected void addListeners() {
        WizardDialog dialog = (WizardDialog)this.getWizard().getContainer();
        dialog.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (event.getSelectedPage() == BasicSettingPage.this) {
                    BasicSettingPage.this.validateAndUpdate();
                }
            }
        });
        this.nameText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 8 || e.keyCode == 127) {
                    if (BasicSettingPage.this.nameText.getCaretPosition() <= BasicSettingPage.this.depotName.length()) {
                        e.doit = false;
                        return;
                    }
                } else {
                    boolean isDepthSame;
                    String namePart = BasicSettingPage.this.nameText.getText().substring(BasicSettingPage.this.depotName.length());
                    boolean bl = isDepthSame = BasicSettingPage.this.segments.length == namePart.split("/").length;
                    if (e.keyCode == 47 && BasicSettingPage.this.nameText.getText().endsWith("/")) {
                        e.doit = false;
                        return;
                    }
                    if (isDepthSame && e.keyCode == 47) {
                        e.doit = false;
                        return;
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 8 || e.keyCode == 127) {
                    e.doit = false;
                }
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicSettingPage.this.getStream().setName(BasicSettingPage.this.nameText.getText().substring(BasicSettingPage.this.depotName.length()));
                BasicSettingPage.this.getStream().setStream(BasicSettingPage.this.nameText.getText());
                if (!BasicSettingPage.this.getWizard().isEditMode()) {
                    String depot = StreamUtil.getDepot((IStreamSummary)BasicSettingPage.this.getStream());
                    if (StringUtils.isEmpty((CharSequence)depot)) {
                        depot = StreamUtil.getParentDepot((IStreamSummary)BasicSettingPage.this.getStream());
                    }
                    if (!StringUtils.isEmpty((CharSequence)depot) && !BasicSettingPage.this.getWizard().rootFolderChanged) {
                        StreamUtil.updateStreamName(BasicSettingPage.this.getStream(), BasicSettingPage.this.getStream().getName(), depot);
                    }
                }
            }
        });
        this.typeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)BasicSettingPage.this.typeCombo.getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof IStreamSummary.Type) {
                    IStreamSummary.Type type = (IStreamSummary.Type)obj;
                    BasicSettingPage.this.getStream().setType(type);
                    BasicSettingPage.this.propWidget.setType(type);
                    BasicSettingPage.this.parentWidget.setType(type);
                    BasicSettingPage.this.showPopulateOption();
                    BasicSettingPage.this.enableParentWidget();
                }
            }
        });
        this.descText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicSettingPage.this.getStream().setDescription(BasicSettingPage.this.descText.getText());
            }
        });
        SWTUtils.addContentListener(new Control[]{this.nameText, this.typeCombo.getControl(), this.descText, this.propWidget}, new Runnable(){

            @Override
            public void run() {
                BasicSettingPage.this.validateAndUpdate();
            }
        });
        this.parentWidget.getLocationValue().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                Object newValue = event.diff.getNewValue();
                String btnText = "";
                if (newValue instanceof SuggestBox.SelectionModel) {
                    Object obj;
                    String stream = null;
                    SuggestBox.SelectionModel value = (SuggestBox.SelectionModel)newValue;
                    if (value != null && (obj = value.getSelection()) instanceof IStreamSummary) {
                        stream = ((IStreamSummary)obj).getStream();
                    }
                    BasicSettingPage.this.getStream().setParent(stream);
                    if (!StringUtils.isEmpty((CharSequence)BasicSettingPage.this.getStream().getName()) && BasicSettingPage.this.getStream().getStream() == null) {
                        String depot = StreamUtil.getParentDepot((IStreamSummary)BasicSettingPage.this.getStream());
                        BasicSettingPage.this.getStream().setStream(String.valueOf(depot) + "/" + BasicSettingPage.this.getStream().getName());
                    }
                    btnText = Messages.BasicSettingPage_BranchFromParent;
                } else if (newValue instanceof String) {
                    String depot = StreamUtil.normalizePath((String)newValue);
                    StreamUtil.updateStreamDepot(BasicSettingPage.this.getStream(), depot);
                    BasicSettingPage.this.getStream().setParent(null);
                    if (!StringUtils.isEmpty((CharSequence)BasicSettingPage.this.getStream().getName()) && BasicSettingPage.this.getStream().getStream() == null) {
                        String d = StreamUtil.getDepot((IStreamSummary)BasicSettingPage.this.getStream());
                        BasicSettingPage.this.getStream().setStream(String.valueOf(d) + "/" + BasicSettingPage.this.getStream().getName());
                    }
                    btnText = Messages.BasicSettingPage_PopulateMainStreamFromDepot;
                } else if (newValue instanceof StreamParentSelectionWidget.TaskStreamModel) {
                    StreamParentSelectionWidget.TaskStreamModel tm = (StreamParentSelectionWidget.TaskStreamModel)newValue;
                    SuggestBox.SelectionModel sm = tm.getBranchStream();
                    if (!StringUtils.isEmpty((CharSequence)tm.getDepot())) {
                        String depot = StreamUtil.normalizePath(tm.getDepot());
                        StreamUtil.updateStreamDepot(BasicSettingPage.this.getStream(), depot);
                        IStreamSummary ss = (IStreamSummary)sm.getSelection();
                        if (ss != null) {
                            BasicSettingPage.this.getStream().setParent(ss.getStream());
                        } else {
                            BasicSettingPage.this.getStream().setParent(null);
                        }
                    } else {
                        Object obj;
                        String stream = null;
                        if (sm != null && (obj = sm.getSelection()) instanceof IStreamSummary) {
                            stream = ((IStreamSummary)obj).getStream();
                        }
                        BasicSettingPage.this.getStream().setParent(stream);
                        if (!StringUtils.isEmpty((CharSequence)BasicSettingPage.this.getStream().getName()) && BasicSettingPage.this.getStream().getStream() == null) {
                            String depot = StreamUtil.getParentDepot((IStreamSummary)BasicSettingPage.this.getStream());
                            BasicSettingPage.this.getStream().setStream(String.valueOf(depot) + "/" + BasicSettingPage.this.getStream().getName());
                        }
                    }
                    btnText = sm != null && sm.getSelection() != null ? Messages.BasicSettingPage_BranchFromParent : Messages.BasicSettingPage_PopulateTaskStreamFromDepot;
                }
                BasicSettingPage.this.populateBtn.setText(btnText);
                BasicSettingPage.this.validateAndUpdate();
            }
        });
    }

    protected void showPopulateOption() {
        IStreamSummary.Type t = this.getStream().getType();
        GridData gd = (GridData)this.populateBtn.getLayoutData();
        boolean visible = false;
        if (!(this.getWizard().isEditMode() || t != IStreamSummary.Type.TASK && t != IStreamSummary.Type.DEVELOPMENT && t != IStreamSummary.Type.RELEASE && t != IStreamSummary.Type.MAINLINE)) {
            visible = true;
        }
        this.populateBtn.setVisible(visible);
        gd.exclude = !visible;
        this.populateBtn.getParent().layout();
    }

    protected void enableParentWidget() {
        if (this.getWizard().isEditMode()) {
            this.parentWidget.setEnabled(this.getWizard().getOriginalStream().getType() != IStreamSummary.Type.TASK);
        }
    }

    @Override
    public IStatus doValidate() {
        IStream stream = this.getStream();
        Assert.isNotNull((Object)stream);
        if (StringUtils.isEmpty((CharSequence)stream.getName())) {
            return ValidationStatus.error((String)Messages.BasicSettingPage_NameEmptyError);
        }
        if (stream.getType() == null) {
            return ValidationStatus.error((String)Messages.BasicSettingPage_TypeEmptyError);
        }
        if (stream.getType() != IStreamSummary.Type.MAINLINE && stream.getType() != IStreamSummary.Type.TASK) {
            if (StreamUtil.isParentEmpty((IStreamSummary)stream)) {
                return ValidationStatus.error((String)Messages.BasicSettingPage_ParentStreamNotExistError);
            }
        } else {
            String depot = StreamUtil.getDepotName((IStreamSummary)stream);
            if (StringUtils.isEmpty((CharSequence)depot) || "UnKnown".equals(depot)) {
                return ValidationStatus.error((String)Messages.BasicSettingPage_StreamDepotNotSet);
            }
        }
        if (stream.getStream() != null && stream.getStream().equals(stream.getParent())) {
            return ValidationStatus.error((String)Messages.AdvancedSettingPage_CannotCreateSelfParentStream);
        }
        if (!StreamUtil.isValidStreamFormat(stream)) {
            return ValidationStatus.error((String)MessageFormat.format(Messages.AdvancedSettingPage_StreamFormatIncorrect, stream.getStream()));
        }
        return super.doValidate();
    }

    public boolean isPopulate() {
        IStreamSummary.Type t;
        if (!this.getWizard().isEditMode() && (t = this.getStream().getType()) != IStreamSummary.Type.VIRTUAL) {
            return this.populateBtn.getSelection();
        }
        return false;
    }
}

