/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.streams.Messages;
import com.perforce.team.ui.streams.NameValueToolTip;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class SuggestBox
extends Composite {
    private static final boolean DEBUG = false;
    private static final int VISIBLE_LINE_NUM = 10;
    WritableValue m_model = new WritableValue(DisplayRealm.getRealm((Display)this.getDisplay()), null, null);
    private Text m_text;
    private Button m_dropDown;
    private ChoiceDialog m_dialog;
    private ISuggestProvider m_provider;
    private String m_prevText = "";
    private ModifyListener m_modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SuggestBox.this.popupAndRepositionDialog(SuggestBox.this.m_text.getText());
        }
    };

    private static void debugPrint(String msg) {
    }

    public void setSuggestProvider(ISuggestProvider provider) {
        if (this.m_provider != provider) {
            this.m_provider = provider;
            this.refresh();
        }
    }

    public SuggestBox(Composite parent, int style, ISuggestProvider provider) {
        super(parent, style);
        this.m_provider = provider;
        this.createControl(this);
        this.addListeners();
    }

    public WritableValue getModel() {
        return this.m_model;
    }

    public boolean setFocus() {
        return this.m_text.setFocus();
    }

    private void createControl(Composite parent) {
        if (SWTUtils.isReadonlyStyle((Control)this)) {
            GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 5).spacing(0, 5).applyTo(parent);
            this.m_text = SWTUtils.createText(parent, 1, 2056);
            GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_text);
            this.setTooltip(this.m_text);
        } else {
            FormLayout layout = new FormLayout();
            parent.setLayout((Layout)layout);
            this.m_text = new Text(parent, 2048);
            this.m_dropDown = new Button(parent, 1028);
            FormData dropDownData = new FormData();
            this.m_dropDown.setLayoutData((Object)dropDownData);
            dropDownData.right = new FormAttachment(100, 0);
            dropDownData.top = new FormAttachment(0, 5);
            dropDownData.bottom = new FormAttachment(100, -5);
            FormData textData = new FormData();
            this.m_text.setLayoutData((Object)textData);
            textData.left = new FormAttachment(0);
            textData.right = new FormAttachment((Control)this.m_dropDown, 0, 131072);
            textData.top = new FormAttachment(0, 5);
            textData.bottom = new FormAttachment(100, -5);
            this.setTooltip(this.m_text);
            SWTUtils.decorate((Control)this, 16512);
            SWTUtils.updateDecoration((Control)this, ValidationStatus.info((String)Messages.StreamsFilterWidget_TypeToFilterChoices));
        }
        if (parent.getParent() != null) {
            parent.getParent().layout(true);
        }
    }

    private void setTooltip(Text control) {
        if (this.m_provider != null && this.m_provider.hasTooltip()) {
            new NameValueToolTip((Control)control, 2, true){

                @Override
                protected String getTitle() {
                    return SuggestBox.this.m_provider.getTooltipTitle((SelectionModel)SuggestBox.this.m_model.getValue());
                }

                @Override
                protected String getPairString() {
                    return SuggestBox.this.m_provider.getTooltips((SelectionModel)SuggestBox.this.m_model.getValue());
                }
            }.activate();
        }
    }

    private void addListeners() {
        this.m_text.addModifyListener(this.m_modifyListener);
        this.m_text.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 1: {
                        if (e.keyCode != 0x1000001 && e.keyCode != 0x1000002) break;
                        e.doit = false;
                        SuggestBox.this.popupAndRepositionDialog(SuggestBox.this.m_text.getText());
                    }
                }
            }
        });
        if (this.m_dropDown != null) {
            this.m_dropDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SuggestBox.this.popupAndRepositionDialog("");
                }
            });
        }
    }

    private void popupAndRepositionDialog(String filter) {
        if (this.isDialogVisible()) {
            return;
        }
        if (this.m_dialog == null) {
            this.m_dialog = new ChoiceDialog(this.m_text.getShell(), 0x10000008);
        }
        Rectangle bound = this.m_text.getParent().getBounds();
        Point pt = this.m_text.toDisplay(-this.m_text.getBorderWidth(), -this.m_text.getBorderWidth());
        bound.x = pt.x - 2;
        bound.y = pt.y;
        this.m_dialog.open(bound, filter);
    }

    protected boolean isDialogVisible() {
        return this.m_dialog != null;
    }

    private void closeDialog() {
        if (this.isDialogVisible()) {
            if (this.m_dialog.fSelectedObj == null && !StringUtils.isEmpty((CharSequence)this.m_dialog.buffer) && !this.m_dialog.buffer.startsWith("//")) {
                if (this.m_dialog.fTreeViewer.getTree().getItemCount() > 0) {
                    Object data = this.m_dialog.fTreeViewer.getTree().getItem(0).getData();
                    if (this.m_provider.getElementType().isInstance(data)) {
                        this.m_dialog.fSelectedObj = data;
                    } else {
                        List<Object> matches = this.m_provider.fetchElement(this.m_dialog.buffer);
                        if (matches.size() > 0) {
                            this.m_dialog.fSelectedObj = matches.get(0);
                        }
                    }
                } else {
                    this.m_dialog.fSelectedObj = null;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)this.m_dialog.buffer) && this.m_dialog.buffer.startsWith("//")) {
                List<Object> datas = this.m_provider.fetchElement(this.m_dialog.buffer);
                if (datas.size() > 0) {
                    this.m_dialog.fSelectedObj = datas.get(0);
                } else {
                    this.m_dialog.fSelectedObj = null;
                }
            }
            this.m_model.setValue((Object)new SelectionModel(this.m_dialog.buffer, this.m_dialog.fSelectedObj));
            String newText = "";
            if (this.m_dialog.fSelectedObj != null) {
                String filterText = this.m_provider.getFilterText(this.m_dialog.fSelectedObj);
                if (filterText != null) {
                    newText = filterText;
                }
            } else if (!StringUtils.isEmpty((CharSequence)this.m_dialog.buffer) && this.m_dialog.buffer.startsWith("//")) {
                newText = this.m_dialog.buffer;
            }
            if (!this.m_text.getText().equals(newText)) {
                this.m_text.setText("");
                this.m_text.append(newText);
            }
            this.m_prevText = newText;
            this.m_dialog.getShell().close();
            this.m_text.setFocus();
            this.m_dialog = null;
        }
    }

    public static void main(String[] args) {
        ISuggestProvider exampleProvider = new ISuggestProvider(){

            @Override
            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            @Override
            public void updateElement(Object parent, int index, TreeViewer viewer) {
                if (parent instanceof List) {
                    List list = (List)parent;
                    if (index >= 0 && index < list.size()) {
                        Object obj = list.get(index);
                        viewer.replace(parent, index, obj);
                        viewer.setChildCount(obj, 0);
                    }
                }
            }

            @Override
            public void updateChildCount(Object element, int currentChildCount, TreeViewer viewer) {
                int size;
                if (element instanceof List && (size = ((List)element).size()) != currentChildCount) {
                    viewer.setChildCount(element, size);
                }
            }

            @Override
            public String getColumnText(Object element, int columnIndex) {
                return element == null ? "null" : element.toString();
            }

            @Override
            public List<Object> fetchElement(String text) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ArrayList<Object> list = new ArrayList<Object>();
                int i = 0;
                while (i < 10) {
                    list.add(String.valueOf(text) + "0" + i);
                    ++i;
                }
                return list;
            }

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            @Override
            public String getFilterText(Object selectedObj) {
                return selectedObj.toString();
            }

            @Override
            public boolean hasTooltip() {
                return true;
            }

            @Override
            public String getTooltipTitle(SelectionModel value) {
                return "Tooltip";
            }

            @Override
            public String getTooltips(SelectionModel value) {
                return "Name: 123\nRoot://tmp";
            }

            @Override
            public Class<?> getElementType() {
                return String.class;
            }
        };
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setSize(800, 400);
        shell.setLayout((Layout)new GridLayout());
        SuggestBox instance = new SuggestBox((Composite)shell, 0, exampleProvider);
        instance.getModel().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                System.out.println("model=" + event.getObservableValue().getValue());
            }
        });
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)instance);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public void setTextQuietlyAndUpdateModel(String text) {
        this.setTextQuietly(text);
        this.m_model.setValue((Object)new SelectionModel(text, null));
    }

    public void updateModel(SelectionModel newModel) {
        this.m_model.setValue((Object)newModel);
        this.refresh();
    }

    private void setTextQuietly(String txt) {
        this.m_text.removeModifyListener(this.m_modifyListener);
        this.m_text.setText("");
        if (txt != null) {
            this.m_text.append(txt);
        }
        this.m_text.addModifyListener(this.m_modifyListener);
        this.m_prevText = txt;
    }

    public String getText() {
        return this.m_text.getText();
    }

    public void refresh() {
        SelectionModel selection = (SelectionModel)this.m_model.getValue();
        if (selection != null && selection.getSelection() != null) {
            this.setTextQuietly(this.m_provider.getFilterText(selection.getSelection()));
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_text.setEnabled(enabled);
        if (this.m_dropDown != null) {
            this.m_dropDown.setEnabled(enabled);
        }
        if (!enabled) {
            this.m_text.setBackground(this.getDisplay().getSystemColor(34));
        } else {
            this.m_text.setBackground(this.getDisplay().getSystemColor(25));
        }
    }

    class ChoiceDialog
    extends Dialog {
        private final Object BROWSE;
        private Object LOADING;
        private String buffer;
        private Job fUpdateFilterJob;
        private Object fSelectedObj;
        private Shell fShell;
        private Text fText;
        private Button fDropDown;
        private TreeViewer fTreeViewer;
        private ISelectionChangedListener fSelectionChangedListener;
        private DisposeListener fDisposeListener;
        private Listener fActivateListener;
        private Listener fListener;

        public ChoiceDialog(Shell parent, int style) {
            super(parent, style);
            this.BROWSE = Messages.SuggestBox_Browse;
            this.LOADING = new Object();
            this.buffer = "";
            this.fSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object sel = ChoiceDialog.this.getSelection();
                    if (sel != ChoiceDialog.this.LOADING && sel != ChoiceDialog.this.BROWSE && sel != null) {
                        ChoiceDialog.this.buffer = SuggestBox.this.m_provider.getColumnText(sel, 0);
                        SuggestBox.this.closeDialog();
                    }
                }
            };
            this.fDisposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    SuggestBox.debugPrint("shell::widgetDisposed() : text=" + SuggestBox.this.m_text.getText());
                    SuggestBox.this.m_dialog = null;
                }
            };
            this.fActivateListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 27: {
                            ChoiceDialog.this.cancelChoice();
                        }
                    }
                }
            };
            this.fListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 1: {
                            if (e.keyCode != 0x1000001 && e.keyCode != 0x1000002 && e.keyCode != 0x1000005 && e.keyCode != 0x1000006) break;
                            e.doit = false;
                            break;
                        }
                        case 2: {
                            e.doit = false;
                            if (e.keyCode == 0x1000001) {
                                this.choiceLineUp();
                                break;
                            }
                            if (e.keyCode == 0x1000002) {
                                this.choiceLineDown();
                                break;
                            }
                            if (e.keyCode == 0x1000005) {
                                this.choicePageUp();
                                break;
                            }
                            if (e.keyCode == 0x1000006) {
                                this.choicePageDown();
                                break;
                            }
                            if (e.keyCode == 13 || e.keyCode == 10) {
                                e.doit = ChoiceDialog.this.applyChoice();
                                break;
                            }
                            if (e.keyCode == 27) {
                                ChoiceDialog.this.cancelChoice();
                                e.doit = false;
                                break;
                            }
                            if (e.keyCode == 0x1000003 || e.keyCode == 0x1000004 || ChoiceDialog.this.fText.getText().equals(ChoiceDialog.this.buffer)) break;
                            ChoiceDialog.this.buffer = ChoiceDialog.this.fText.getText();
                            ChoiceDialog.this.restartUpdateFilterJob();
                            break;
                        }
                        case 31: {
                            if (e.detail != 2) break;
                            ChoiceDialog.this.cancelChoice();
                            e.doit = false;
                        }
                    }
                }

                private void choicePageDown() {
                    this.down(10);
                }

                private void choicePageUp() {
                    this.up(10);
                }

                private void choiceLineDown() {
                    this.down(1);
                }

                private void choiceLineUp() {
                    this.up(1);
                }

                private void up(int delta) {
                    if (ChoiceDialog.this.fShell.isDisposed()) {
                        return;
                    }
                    Tree tree = ChoiceDialog.this.fTreeViewer.getTree();
                    ISelection selection = ChoiceDialog.this.fTreeViewer.getSelection();
                    if (selection == null || selection.isEmpty()) {
                        if (tree.getItemCount() > 0) {
                            tree.select(tree.getItem(tree.getItemCount() - 1));
                        }
                    } else {
                        int index = tree.indexOf(tree.getSelection()[0]) - delta;
                        if (index >= 0) {
                            tree.select(tree.getItem(index));
                        } else if (delta == 1) {
                            tree.select(tree.getItem(tree.getItemCount() - 1));
                        } else {
                            tree.select(tree.getItem(0));
                        }
                    }
                    tree.showSelection();
                    ChoiceDialog.this.showSelectionInText();
                }

                private void down(int delta) {
                    if (ChoiceDialog.this.fShell.isDisposed()) {
                        return;
                    }
                    Tree tree = ChoiceDialog.this.fTreeViewer.getTree();
                    ISelection selection = ChoiceDialog.this.fTreeViewer.getSelection();
                    if (selection == null || selection.isEmpty()) {
                        if (tree.getItemCount() > 0) {
                            tree.select(tree.getItem(0));
                        }
                    } else {
                        int index = tree.indexOf(tree.getSelection()[0]) + delta;
                        if (index < tree.getItemCount()) {
                            tree.select(tree.getItem(index));
                        } else if (delta == 1) {
                            tree.select(tree.getItem(0));
                        } else {
                            tree.select(tree.getItem(tree.getItemCount() - 1));
                        }
                    }
                    tree.showSelection();
                    ChoiceDialog.this.showSelectionInText();
                }
            };
        }

        public Shell getShell() {
            return this.fShell;
        }

        private Object getSelection() {
            ISelection sel = this.fTreeViewer.getSelection();
            if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
                this.fSelectedObj = ((IStructuredSelection)sel).getFirstElement();
                return this.fSelectedObj;
            }
            return null;
        }

        private Shell createShell() {
            Shell parent = this.getParent();
            Shell shell = new Shell(parent, 0);
            FormLayout layout = new FormLayout();
            shell.setLayout((Layout)layout);
            this.fText = new Text((Composite)shell, 2048);
            this.fDropDown = new Button((Composite)shell, 1028);
            FormData dropDownData = new FormData();
            this.fDropDown.setLayoutData((Object)dropDownData);
            dropDownData.right = new FormAttachment(100, 0);
            dropDownData.top = new FormAttachment(0, 5);
            FormData textData = new FormData();
            this.fText.setLayoutData((Object)textData);
            textData.left = new FormAttachment(0);
            textData.right = new FormAttachment((Control)this.fDropDown, 5, 131072);
            textData.top = new FormAttachment((Control)this.fDropDown, 5, 0x1000000);
            this.fTreeViewer = new TreeViewer((Composite)shell, 0x10010004);
            FormData viewData = new FormData();
            this.fTreeViewer.getControl().setLayoutData((Object)viewData);
            viewData.left = new FormAttachment(0);
            viewData.right = new FormAttachment(100, 0);
            viewData.top = new FormAttachment((Control)this.fText, 5, 1024);
            viewData.bottom = new FormAttachment(100, -5);
            this.fTreeViewer.setContentProvider((IContentProvider)new SuggestContentProvider());
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new SuggestLabelProvider());
            this.fTreeViewer.setUseHashlookup(true);
            this.fTreeViewer.getTree().setLinesVisible(true);
            new TreeColumn(this.fTreeViewer.getTree(), 4);
            this.createUpdateFilterJob();
            return shell;
        }

        private void repositionShell(Shell shell, Rectangle bound) {
            shell.pack();
            int rowHight = this.fTreeViewer.getTree().getItemHeight() + this.fTreeViewer.getTree().getGridLineWidth();
            shell.setSize(Math.max(shell.getSize().x, bound.width), rowHight * 10 + shell.getBorderWidth() * 4);
            Point oldOrigin = new Point(bound.x, bound.y);
            Point newOrigin = new Point(0, 0);
            Rectangle screenBound = this.getParent().getDisplay().getBounds();
            newOrigin.x = oldOrigin.x < 0 ? 0 : (oldOrigin.x > screenBound.width - shell.getSize().x ? screenBound.width - shell.getSize().x : oldOrigin.x + 2);
            newOrigin.y = oldOrigin.y < 0 ? 0 : (oldOrigin.y > screenBound.height - shell.getSize().y - bound.height ? screenBound.height - shell.getSize().y : oldOrigin.y);
            shell.setLocation(newOrigin);
            SuggestBox.debugPrint("repositionShell(): bound=" + shell.getBounds());
            shell.layout();
        }

        private void restartUpdateFilterJob() {
            if (this.fUpdateFilterJob != null) {
                this.fUpdateFilterJob.cancel();
            }
            this.createUpdateFilterJob();
            this.fUpdateFilterJob.schedule(500L);
        }

        private void createUpdateFilterJob() {
            this.fTreeViewer.setInput(this.LOADING);
            this.fTreeViewer.getTree().setItemCount(1);
            final String filter = this.fText.getText();
            final Display display = this.fText.getDisplay();
            this.fUpdateFilterJob = new Job("Update Filter"){

                protected IStatus run(IProgressMonitor monitor) {
                    SuggestBox.debugPrint("RRRRRRRRRRRRRRRRRRRRRRRRRR----> " + filter);
                    if (SuggestBox.this.m_provider == null) {
                        return Status.OK_STATUS;
                    }
                    final List<Object> list = SuggestBox.this.m_provider.fetchElement(filter);
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SuggestBox.debugPrint("UUUUUUUUUUUUUUUUUUUUUUUUU----> " + filter);
                            if (!ChoiceDialog.this.fText.isDisposed() && filter.equals(ChoiceDialog.this.fText.getText())) {
                                SuggestBox.debugPrint("NNNNNNNNNNNNNNNNNNNNNNNNN----> " + filter);
                                ChoiceDialog.this.fTreeViewer.setInput((Object)list);
                            }
                            if (ChoiceDialog.this.fText.getText().isEmpty()) {
                                ChoiceDialog.this.fText.setText(ChoiceDialog.this.fText.getText());
                                ChoiceDialog.this.fText.setFocus();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            this.fUpdateFilterJob.setSystem(true);
        }

        public void setDefaultSelection() {
            SuggestBox.debugPrint("setDefaultSelection()");
            Tree tree = this.fTreeViewer.getTree();
            if (tree.getSelection() != null) {
                return;
            }
            if (tree.getItemCount() > 0) {
                tree.select(tree.getItem(0));
            }
        }

        public int open(Rectangle bound, String filter) {
            this.fShell = this.createShell();
            this.repositionShell(this.fShell, bound);
            this.fShell.open();
            this.fTreeViewer.getTree().getColumn(0).setWidth(this.fTreeViewer.getTree().getClientArea().width);
            this.fText.setFocus();
            this.fText.append(filter);
            this.addDialogListeners();
            this.restartUpdateFilterJob();
            Display display = this.getShell().getDisplay();
            while (!this.fShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return 0;
        }

        private void addDialogListeners() {
            this.fShell.addDisposeListener(this.fDisposeListener);
            this.fShell.addListener(27, this.fActivateListener);
            this.fText.addListener(31, this.fListener);
            this.fText.addListener(2, this.fListener);
            this.fText.addListener(1, this.fListener);
            this.fDropDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChoiceDialog.this.cancelChoice();
                }
            });
            this.fTreeViewer.addSelectionChangedListener(this.fSelectionChangedListener);
        }

        private void showSelectionInText() {
            if (this.BROWSE.equals(this.getSelection())) {
                return;
            }
            if (this.LOADING.equals(this.getSelection())) {
                return;
            }
            this.updateText(SuggestBox.this.m_provider.getColumnText(this.getSelection(), 0));
            this.fSelectedObj = this.getSelection();
        }

        private void updateText(String newText) {
            this.buffer = newText;
            if (this.buffer != null) {
                this.fText.setText("");
                this.fText.append(this.buffer);
            }
        }

        protected boolean applyChoice() {
            SuggestBox.debugPrint("applyChoice() = START");
            if (SuggestBox.this.m_dialog != null) {
                SuggestBox.this.closeDialog();
            }
            return true;
        }

        protected void cancelChoice() {
            SuggestBox.debugPrint("cancelChoice()");
            if (!SuggestBox.this.m_prevText.equals(((SuggestBox)SuggestBox.this).m_dialog.buffer)) {
                String txt = SuggestBox.this.m_prevText;
                SuggestBox.this.setTextQuietly(txt);
            }
            if (SuggestBox.this.isDialogVisible()) {
                SuggestBox.this.m_dialog.getShell().close();
                SuggestBox.this.m_text.setFocus();
                SuggestBox.this.m_dialog = null;
            }
        }

        class SuggestContentProvider
        implements ILazyTreeContentProvider {
            SuggestContentProvider() {
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (SuggestBox.this.m_provider != null) {
                    SuggestBox.this.m_provider.inputChanged(viewer, oldInput, newInput);
                }
            }

            public Object getParent(Object element) {
                return null;
            }

            public void updateChildCount(Object element, int currentChildCount) {
                if (SuggestBox.this.m_provider != null) {
                    SuggestBox.this.m_provider.updateChildCount(element, currentChildCount, ChoiceDialog.this.fTreeViewer);
                }
            }

            public void updateElement(Object parent, int index) {
                if (parent == ChoiceDialog.this.LOADING && index == 0) {
                    ChoiceDialog.this.fTreeViewer.replace(parent, 0, ChoiceDialog.this.LOADING);
                } else {
                    SuggestBox.this.m_provider.updateElement(parent, index, ChoiceDialog.this.fTreeViewer);
                }
            }
        }

        class SuggestLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            SuggestLabelProvider() {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0 && element == ChoiceDialog.this.LOADING) {
                    return Messages.SuggestBox_Loading;
                }
                return SuggestBox.this.m_provider.getColumnText(element, columnIndex);
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0 && element == ChoiceDialog.this.LOADING) {
                    return null;
                }
                return SuggestBox.this.m_provider.getColumnImage(element, columnIndex);
            }
        }
    }

    public static interface ISuggestProvider {
        public void updateChildCount(Object var1, int var2, TreeViewer var3);

        public void updateElement(Object var1, int var2, TreeViewer var3);

        public String getColumnText(Object var1, int var2);

        public List<Object> fetchElement(String var1);

        public Image getColumnImage(Object var1, int var2);

        public String getFilterText(Object var1);

        public void inputChanged(Viewer var1, Object var2, Object var3);

        public boolean hasTooltip();

        public String getTooltipTitle(SelectionModel var1);

        public String getTooltips(SelectionModel var1);

        public Class<?> getElementType();
    }

    public static class SelectionModel {
        private String text;
        private Object selection;

        public SelectionModel(String text, Object sel) {
            this.setText(text);
            this.setSelection(sel);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Object getSelection() {
            return this.selection;
        }

        public void setSelection(Object selection) {
            this.selection = selection;
        }

        public String toString() {
            return String.valueOf(this.text == null ? "null" : this.text) + ", " + (this.selection == null ? "null" : this.selection.toString());
        }
    }
}

