/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.option.server.GetStreamsOptions;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.streams.Messages;
import com.perforce.team.ui.streams.StreamUtil;
import com.perforce.team.ui.streams.SuggestBox;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class StreamsSuggestProvider
implements SuggestBox.ISuggestProvider {
    protected IP4Connection connection;

    public IP4Connection getConnection() {
        return this.connection;
    }

    public void setConnection(IP4Connection connection) {
        this.connection = connection;
    }

    public StreamsSuggestProvider(IP4Connection conn) {
        this.connection = conn;
    }

    @Override
    public void updateChildCount(Object element, int currentChildCount, TreeViewer viewer) {
        int size;
        if (element instanceof List && (size = ((List)element).size()) != currentChildCount) {
            viewer.setChildCount(element, size);
        }
    }

    @Override
    public void updateElement(Object parent, int index, TreeViewer viewer) {
        if (parent instanceof List) {
            List list = (List)parent;
            if (index >= 0 && index < list.size()) {
                Object obj = list.get(index);
                viewer.replace(parent, index, obj);
                viewer.setChildCount(obj, 0);
            }
        }
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IStreamSummary) {
            IStreamSummary sum = (IStreamSummary)element;
            return String.valueOf(sum.getName()) + " " + "(" + sum.getStream() + ")";
        }
        return null;
    }

    @Override
    public List<Object> fetchElement(String filter) {
        Assert.isNotNull((Object)filter);
        if (StringUtils.isEmpty((CharSequence)filter)) {
            return this.initEmpty(filter);
        }
        if (!StringUtils.isEmpty((CharSequence)filter) && filter.trim().length() == 0 || filter.equals("/")) {
            return new ArrayList<Object>();
        }
        filter = filter.trim();
        GetStreamsOptions opts = this.initOptions(filter);
        List<String> paths = this.initPaths(filter);
        List summaries = this.connection.getStreams(paths, opts);
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(summaries);
        return result;
    }

    protected List<Object> initEmpty(String filter) {
        return this.fetchElement("//");
    }

    protected List<String> initPaths(String filter) {
        ArrayList<String> paths = null;
        if (filter.startsWith("//")) {
            String path = StreamUtil.normalizePath(filter);
            paths = new ArrayList<String>();
            if (StreamUtil.isStreamPathFormat(path)) {
                paths.add(String.valueOf(path) + "*");
            } else {
                paths.add(String.valueOf(path) + "*/*");
            }
        }
        return paths;
    }

    protected GetStreamsOptions initOptions(String filter) {
        GetStreamsOptions opts = new GetStreamsOptions();
        if (!filter.startsWith("//")) {
            opts.setFilter("Name=" + filter + "*");
        }
        return opts;
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    @Override
    public String getFilterText(Object selection) {
        if (selection instanceof IStreamSummary) {
            return StreamUtil.getStreamDisplayText((IStreamSummary)selection);
        }
        return null;
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public String getTooltipTitle(SuggestBox.SelectionModel value) {
        return Messages.StreamsSuggestProvider_Stream;
    }

    @Override
    public String getTooltips(SuggestBox.SelectionModel value) {
        String UNKNOWN = Messages.StreamsSuggestProvider_Unknown;
        String NAME = Messages.StreamsSuggestProvider_Name;
        String ROOT = Messages.StreamsSuggestProvider_Root;
        StringBuilder sb = new StringBuilder();
        if (value != null) {
            if (value.getSelection() instanceof IStreamSummary) {
                IStreamSummary sum = (IStreamSummary)value.getSelection();
                sb.append(String.valueOf(NAME) + ":" + sum.getName() + "\n");
                sb.append(String.valueOf(ROOT) + ":" + sum.getStream() + "\n");
            } else if (value.getText() != null && !value.getText().equals("")) {
                String text = value.getText();
                if (text.startsWith("//")) {
                    sb.append(String.valueOf(NAME) + ":" + UNKNOWN + "\n");
                    sb.append(String.valueOf(ROOT) + ":" + value.getText() + "\n");
                } else {
                    sb.append(String.valueOf(NAME) + ":" + value.getText() + "\n");
                    sb.append(String.valueOf(ROOT) + ":" + UNKNOWN + "\n");
                }
            } else {
                sb.append(String.valueOf(NAME) + ":" + UNKNOWN + "\n");
                sb.append(String.valueOf(ROOT) + ":" + UNKNOWN + "\n");
            }
        } else {
            sb.append(String.valueOf(NAME) + ":" + UNKNOWN + "\n");
            sb.append(String.valueOf(ROOT) + ":" + UNKNOWN + "\n");
        }
        return sb.toString();
    }

    @Override
    public Class<?> getElementType() {
        return IStreamSummary.class;
    }
}

