/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class NameValueToolTip
extends ToolTip {
    public static final String ms_tooltipLineSep = "\n";
    public static final String ms_tooltipPairSep = ":";
    private Control control;

    public NameValueToolTip(Control control, int style, boolean manualActivation) {
        super(control, style, manualActivation);
        this.control = control;
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.verticalSpacing = 1;
        comp.setLayout((Layout)gridLayout);
        Composite topArea = new Composite(comp, 0);
        GridData data = new GridData(4, 4, true, false);
        data.minimumWidth = 300;
        topArea.setLayoutData((Object)data);
        topArea.setBackground(Display.getCurrent().getSystemColor(29));
        gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 2;
        gridLayout.marginTop = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 2;
        topArea.setLayout((Layout)gridLayout);
        Label l = new Label(topArea, 0);
        l.setText(this.getTitle());
        l.setBackground(Display.getCurrent().getSystemColor(29));
        l.setFont(new FontRegistry().getBold(Display.getCurrent().getSystemFont().getFontData()[0].getName()));
        l.setForeground(Display.getCurrent().getSystemColor(28));
        l.setLayoutData((Object)new GridData(1808));
        this.createContentArea(comp).setLayoutData((Object)new GridData(1808));
        return comp;
    }

    protected Composite createContentArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getDisplay().getSystemColor(29));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 5;
        comp.setLayout((Layout)layout);
        String[] tips = this.getPairString().split(ms_tooltipLineSep);
        int i = 0;
        while (i < tips.length) {
            GridData gridData = new GridData(1, 1, false, false);
            String[] pair = tips[i].split(ms_tooltipPairSep);
            Label title = new Label(comp, 0);
            title.setFont(new FontRegistry().getBold(Display.getCurrent().getSystemFont().getFontData()[0].getName()));
            title.setText(pair[0]);
            title.setForeground(parent.getDisplay().getSystemColor(28));
            title.setBackground(parent.getDisplay().getSystemColor(29));
            title.setLayoutData((Object)gridData);
            Label cont = new Label(comp, 64);
            cont.setText(pair[1]);
            cont.setForeground(parent.getDisplay().getSystemColor(28));
            cont.setBackground(parent.getDisplay().getSystemColor(29));
            ++i;
        }
        return comp;
    }

    protected boolean shouldCreateToolTip(Event event) {
        String pairString = this.getPairString();
        return pairString != null && !pairString.trim().equals("");
    }

    public Point getLocation(Point tipSize, Event event) {
        return this.control.toDisplay(-this.control.getBorderWidth(), this.control.getSize().y - this.control.getBorderWidth());
    }

    protected abstract String getTitle();

    protected abstract String getPairString();
}

