/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.shelve.SubmitShelveDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SubmitShelveAction
extends P4Action {
    @Override
    public boolean isEnabledEx() {
        boolean enabled = this.containsOnlineConnection();
        if (enabled && !(enabled = this.containsContainers())) {
            P4Collection collection = this.getResourceSelection();
            IP4Resource[] iP4ResourceArray = collection.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4ShelvedChangelist list;
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4ShelvedChangelist && !(list = (IP4ShelvedChangelist)resource).isReadOnly() && list.getFiles().length > 0) {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }

    private void submitListsFromCollection(final P4Collection collection, final boolean showDialog) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                ArrayList<IP4ShelvedChangelist> changes = new ArrayList<IP4ShelvedChangelist>();
                ArrayList nonSubmittables = new ArrayList();
                IP4Resource[] iP4ResourceArray = collection.members();
                int n = iP4ResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource resource = iP4ResourceArray[n2];
                    if (resource instanceof IP4ShelvedChangelist) {
                        IP4ShelvedChangelist sl = (IP4ShelvedChangelist)resource;
                        List openedFiles = sl.getOpenedSpecs();
                        nonSubmittables.addAll(openedFiles);
                        IP4ShelvedChangelist list = (IP4ShelvedChangelist)resource;
                        changes.add(list);
                        if (nonSubmittables.isEmpty()) {
                            SubmitShelveAction.this.showSubmitDialogs(changes, showDialog);
                        } else {
                            final StringBuilder sb = new StringBuilder();
                            sb.append(MessageFormat.format(Messages.SubmitShelveAction_ChangelistContainsNonShelvedFiles, "" + sl.getId()));
                            if (nonSubmittables.size() < 20) {
                                sb.append(Messages.SubmitShelveAction_MoveFollowingFIlesToAnotherChangelist);
                                for (IExtendedFileSpec s : nonSubmittables) {
                                    sb.append("  ");
                                    sb.append(s.getDepotPathString());
                                    sb.append("\n");
                                }
                            } else {
                                sb.append(Messages.SubmitShelveAction_MoveFilesToAnotherCHangelist);
                            }
                            PerforceUIPlugin.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openError((Shell)SubmitShelveAction.this.getShell(), (String)this.getTitle(), (String)sb.toString());
                                }
                            });
                        }
                    }
                    ++n2;
                }
            }

            public String getTitle() {
                return Messages.SubmitAction_SubmittingChangelistTitle;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    private void showSubmitDialogs(final List<IP4ShelvedChangelist> lists, final boolean showDialog) {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!lists.isEmpty()) {
                    for (IP4ShelvedChangelist list : lists) {
                        if (showDialog) {
                            SubmitShelveDialog dialog = new SubmitShelveDialog(SubmitShelveAction.this.getShell(), MessageFormat.format(Messages.SubmitShelveAction_Submit_shelved_change, list.getId()), list);
                            if (dialog.open() != 0) continue;
                            SubmitShelveAction.this.submit(list);
                            continue;
                        }
                        SubmitShelveAction.this.submit(list);
                    }
                } else {
                    P4ConnectionManager.getManager().openInformation(SubmitShelveAction.this.getShell(), Messages.SubmitAction_NoFilesToSubmitTitle, Messages.SubmitAction_NoFilesToSubmitMessage);
                }
            }
        });
    }

    public void runAction(boolean showDialog) {
        P4Collection collection = this.getResourceSelection();
        this.submitListsFromCollection(collection, showDialog);
    }

    @Override
    public void runAction() {
        this.runAction(true);
    }

    private void submit(IP4ShelvedChangelist changelist) {
        IP4Connection connection = changelist.getConnection();
        Server server = (Server)connection.getServer();
        List retMaps = connection.execMapCmdList(CmdSpec.SUBMIT.name(), new String[]{"-e" + changelist.getId()}, new HashMap());
        try {
            ArrayList<Object> fileList = new ArrayList<Object>();
            String SUBMITTED_MSG = "Submitted as change ";
            String KEY_SUBMITTEDCHANGE = "submittedChange";
            String KEY_LOCK = "locked";
            if (retMaps != null) {
                for (Map map : retMaps) {
                    if (map.get("submittedChange") != null) {
                        Integer id = new Integer((String)map.get("submittedChange"));
                        fileList.add(new FileSpec(FileSpecOpStatus.INFO, "Submitted as change " + id));
                        continue;
                    }
                    if (map.get("locked") != null) continue;
                    fileList.add(server.handleFileReturn(map));
                }
            }
            for (IFileSpec iFileSpec : fileList) {
                if (iFileSpec.getStatusMessage() != null && !iFileSpec.getStatusMessage().contains("Submitted as change ")) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.SubmitShelveAction_Error, (String)iFileSpec.getStatusMessage());
                    break;
                }
                this.updateChanges(changelist);
            }
        }
        catch (P4JavaException e) {
            e.printStackTrace();
        }
    }

    private void updateChanges(IP4ShelvedChangelist changelist) {
        changelist.refresh();
        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.SUBMIT_SHELVEDCHANGELIST, (IP4Resource)changelist));
    }
}

