/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.ui.changelists.ChangelistFileWidget;
import com.perforce.team.ui.shelve.OpenEditorAction;
import com.perforce.team.ui.shelve.ShelvedFileContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;

public class ShelvedChangelistFileWidget
extends ChangelistFileWidget {
    public static final String DISPLAY_TYPE = "com.perforce.team.ui.shelve.DISPLAY_TYPE";
    private boolean enableEdit;

    public ShelvedChangelistFileWidget(boolean enableEdit) {
        this.enableEdit = enableEdit;
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        if (this.enableEdit) {
            viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection select = (IStructuredSelection)ShelvedChangelistFileWidget.this.getViewer().getSelection();
                    if (select.size() == 1 && select.getFirstElement() instanceof IP4ShelveFile) {
                        OpenEditorAction open = new OpenEditorAction();
                        open.selectionChanged(null, (ISelection)select);
                        open.run(null);
                    }
                }
            });
        }
    }

    @Override
    protected ITreeContentProvider createContentProvider(TreeViewer viewer) {
        return new ShelvedFileContentProvider((StructuredViewer)viewer, true, this);
    }

    @Override
    protected String getTypePreferenceKey() {
        return DISPLAY_TYPE;
    }
}

