/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.resource;

import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.BaseErrorProvider;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.resource.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;

public class ResourceBrowserWidget
extends BaseErrorProvider {
    private IP4Resource[] resources = null;
    private TreeViewer viewer = null;

    public ResourceBrowserWidget(IP4Resource[] resources) {
        this.resources = resources;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public IP4Resource getSelectedResource() {
        Object first;
        IP4Resource selected = null;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IP4Resource) {
            selected = (IP4Resource)first;
        }
        return selected;
    }

    @Override
    public void validate() {
        IP4Resource selected = this.getSelectedResource();
        this.errorMessage = selected == null ? Messages.ResourceBrowserWidget_SelectAResource : null;
        super.validate();
    }

    public void createControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 2820);
        GridData vData = new GridData(4, 4, true, true);
        vData.heightHint = P4UIUtils.computePixelHeight(this.viewer.getTree().getFont(), 15);
        vData.widthHint = 300;
        this.viewer.getTree().setLayoutData((Object)vData);
        this.viewer.setContentProvider((IContentProvider)new PerforceContentProvider((StructuredViewer)this.viewer, true));
        this.viewer.setLabelProvider((IBaseLabelProvider)new PerforceLabelProvider(false));
        this.viewer.setInput((Object)this.resources);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceBrowserWidget.this.validate();
            }
        });
        this.addContextMenu(this);
        this.validate();
    }

    private void addContextMenu(final ResourceBrowserWidget widget) {
        final Action refreshAction = new Action(Messages.ResourceBrowserDialog_Refresh, PerforceUIPlugin.getDescriptor("normal/refresh.png")){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)widget.getViewer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object refresh = objectArray[n2];
                    if (refresh instanceof IP4Container) {
                        ((IP4Container)refresh).markForRefresh();
                    }
                    widget.getViewer().refresh(refresh, true);
                    ++n2;
                }
            }
        };
        refreshAction.setToolTipText(Messages.ResourceBrowserDialog_Refresh);
        MenuManager manager = new MenuManager();
        Tree tree = widget.getViewer().getTree();
        Menu menu = manager.createContextMenu((Control)tree);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)widget.getViewer().getSelection();
                boolean containersOnly = true;
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object refresh = objectArray[n2];
                    if (!(refresh instanceof IP4Container)) {
                        containersOnly = false;
                        break;
                    }
                    ++n2;
                }
                if (containersOnly) {
                    manager.add((IAction)refreshAction);
                }
            }
        });
        manager.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
    }
}

