/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.resource;

import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.resource.LazyResourceBrowserWidget;
import com.perforce.team.ui.resource.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class LazyResourceBrowserDialog
extends P4StatusDialog {
    private IWorkbenchAdapter provider = null;
    private IP4Resource selected = null;
    private LazyResourceBrowserWidget widget = null;

    public LazyResourceBrowserDialog(Shell parent, IWorkbenchAdapter provider) {
        super(parent);
        this.setTitle(Messages.ResourceBrowserDialog_SelectAResource);
        this.setModalResizeStyle();
        this.provider = provider;
    }

    public IP4Resource getSelectedResource() {
        return this.selected;
    }

    protected void okPressed() {
        this.selected = this.widget.getSelectedResource();
        super.okPressed();
    }

    public TreeViewer getViewer() {
        return this.widget != null ? this.widget.getViewer() : null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.widget = new LazyResourceBrowserWidget(this.provider);
        this.widget.createControl(c);
        this.widget.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (LazyResourceBrowserDialog.this.widget.getSelectedResource() != null) {
                    LazyResourceBrowserDialog.this.okPressed();
                }
            }
        });
        this.widget.setErrorDisplay(this);
        final Action refreshAction = new Action(Messages.ResourceBrowserDialog_Refresh, PerforceUIPlugin.getDescriptor("normal/refresh.png")){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)LazyResourceBrowserDialog.this.widget.getViewer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object refresh = objectArray[n2];
                    if (refresh instanceof IP4Container) {
                        ((IP4Container)refresh).markForRefresh();
                    }
                    LazyResourceBrowserDialog.this.widget.getViewer().refresh(refresh, true);
                    ++n2;
                }
            }
        };
        refreshAction.setToolTipText(Messages.ResourceBrowserDialog_Refresh);
        MenuManager manager = new MenuManager();
        Tree tree = this.widget.getViewer().getTree();
        Menu menu = manager.createContextMenu((Control)tree);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)LazyResourceBrowserDialog.this.widget.getViewer().getSelection();
                boolean containersOnly = true;
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object refresh = objectArray[n2];
                    if (!(refresh instanceof IP4Container)) {
                        containersOnly = false;
                        break;
                    }
                    ++n2;
                }
                if (containersOnly) {
                    manager.add((IAction)refreshAction);
                }
            }
        });
        manager.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        return c;
    }

    public static interface ILazyResourceProvider {
        public IP4Resource[] getResources();
    }
}

