/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.refactor;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.refactor.IRefactorManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public abstract class RefactorManager
implements IRefactorManager {
    @Override
    public boolean isEnabled() {
        return this.isEnabled(this.getPreference());
    }

    @Override
    public boolean isEnabled(String preference) {
        return PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(preference);
    }

    protected int getActiveId(IResource resource) {
        IP4PendingChangelist list;
        int id = -1;
        IP4Connection connection = P4ConnectionManager.getManager().getConnection(resource.getProject());
        if (connection != null && (list = connection.getActivePendingChangelist()) != null) {
            id = list.getId();
        }
        return id;
    }

    protected boolean exists(IResource resource) {
        IPath location = resource.getLocation();
        return location != null ? location.toFile().exists() : false;
    }

    @Override
    public String getPreference() {
        return "pref_refactor_support";
    }
}

