/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.project;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.connection.IConnectionWizard;
import com.perforce.team.ui.p4java.actions.ImportProjectAction;
import com.perforce.team.ui.project.ImportProjectsWizardPage;
import com.perforce.team.ui.project.Messages;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ImportProjectsWizard
extends Wizard
implements IConnectionWizard {
    protected ImportProjectsWizardPage importPage;
    private IP4Connection connection;

    public ImportProjectsWizard(IP4Connection connection) {
        this.setNeedsProgressMonitor(true);
        this.connection = connection;
    }

    public void addPages() {
        this.importPage = new ImportProjectsWizardPage("importPage", false);
        this.addPage((IWizardPage)this.importPage);
    }

    public boolean performFinish() {
        boolean[] finished = new boolean[]{true};
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    ImportProjectsWizard.this.importProjects(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        return finished[0];
    }

    public IP4Folder[] getImportedFolders() {
        return this.importPage.getImportedFolders();
    }

    private void importProjects(final IProgressMonitor monitor) {
        IP4Folder[] imports = this.getImportedFolders();
        monitor.beginTask(Messages.ImportProjectsWizard_ImportingProjects, imports.length + 1);
        final ArrayList<IP4Folder> retrievedFolders = new ArrayList<IP4Folder>();
        IP4Folder[] iP4FolderArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Folder folder = iP4FolderArray[n2];
            monitor.subTask(MessageFormat.format(Messages.ImportProjectsWizard_CheckoutFolder, folder.getRemotePath()));
            IP4Folder updated = this.connection.getFolder(folder.getRemotePath());
            if (updated != null) {
                retrievedFolders.add(updated);
            }
            monitor.worked(1);
            ++n2;
        }
        if (retrievedFolders.size() > 0) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    ImportProjectAction checkout = new ImportProjectAction();
                    checkout.selectionChanged(null, (ISelection)new StructuredSelection(retrievedFolders));
                    checkout.runAction(monitor);
                }
            });
        }
        monitor.done();
    }

    @Override
    public String getPort() {
        return this.connection.getParameters().getPort();
    }

    @Override
    public String getUser() {
        return this.connection.getUser();
    }

    @Override
    public String getClient() {
        return this.connection.getClientName();
    }

    @Override
    public String getCharset() {
        return this.connection.getParameters().getCharset();
    }

    @Override
    public String getPassword() {
        return this.connection.getParameters().getPassword();
    }

    @Override
    public String getAuthTicket() {
        return this.connection.getParameters().getAuthTicket();
    }

    @Override
    public void setAuthTicket(String authTicket) {
        this.connection.getParameters().setAuthTicket(authTicket);
    }

    @Override
    public String getStream() {
        return this.connection.getClient().getStream();
    }

    @Override
    public boolean isIgnoreSSLValidation() {
        return this.connection.getParameters().isIgnoreSSLValidation();
    }
}

