/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.preferences;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.preferences.Messages;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class ExternalToolsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.perforce.team.ui.preferences.ExternalToolsPreferencePage";
    private static final String P4MERGE_APP = "p4merge.app";
    private static final String P4MERGE_APPENDED = "/Contents/MacOS/p4merge";
    private static final String P4V_APP = "p4v.app";
    private static final String P4V_APPENDED = "/Contents/MacOS/p4v";
    private static final String P4V_LINK = "https://www.perforce.com/downloads/helix-visual-client-p4v";
    private static final String P4MERGE_LINK = "https://www.perforce.com/downloads/visual-merge-tool";
    private static final String P4MFA_APP_LINK = "https://www.perforce.com/downloads/helix-mfa-authenticator";
    private Composite displayArea;
    private Group p4MergeGroup;
    private Label p4MergeInfo;
    private Link p4MergeLink;
    private Label p4MergeLabel;
    private Text p4MergeText;
    private Button browseButton;
    private Group p4VGroup;
    private Label p4VInfo;
    private Link p4VLink;
    private Label p4VLabel;
    private Text p4VText;
    private Button browseVButton;
    private Group p4MFAAppGroup;
    private Label p4MFAAppInfo;
    private Link p4MFAAppLink;
    private Label p4MFAAppLabel;
    private Text p4MFAAppText;
    private Button browseMFAAppButton;

    protected Control createContents(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(3, false);
        layout.marginBottom = 10;
        this.createP4MergeGroup(layout);
        this.createP4VGroup(layout);
        this.createP4MFAAppConfigGroup(layout);
        return this.displayArea;
    }

    private void createP4VGroup(GridLayout layout) {
        this.p4VGroup = new Group(this.displayArea, 0);
        this.p4VGroup.setLayout((Layout)layout);
        this.p4VGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.p4VGroup.setText(Messages.ExternalToolsPreferencePage_PerforceVisualClient);
        this.p4VInfo = new Label((Composite)this.p4VGroup, 16384);
        this.p4VInfo.setText(Messages.ExternalToolsPreferencePage_UseP4VForTimelapseAndRevgraph);
        GridData pvlData = new GridData(4, 4, true, false);
        pvlData.horizontalSpan = 3;
        this.p4VInfo.setLayoutData((Object)pvlData);
        this.p4VLabel = new Label((Composite)this.p4VGroup, 16384);
        this.p4VLabel.setText(Messages.ExternalToolsPreferencePage_P4VPath);
        this.p4VText = new Text((Composite)this.p4VGroup, 2052);
        this.p4VText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.p4VText.setText(this.getPreferenceStore().getString("com.perforce.team.ui.preferences.P4VC_PATH"));
        this.p4VText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExternalToolsPreferencePage.this.validate();
            }
        });
        this.browseVButton = new Button((Composite)this.p4VGroup, 8);
        this.browseVButton.setText(Messages.ExternalToolsPreferencePage_Browse);
        this.browseVButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ExternalToolsPreferencePage.this.browseVButton.getShell(), 4096);
                String path = dialog.open();
                if (path != null) {
                    if (P4CoreUtils.isMac() && path.endsWith(ExternalToolsPreferencePage.P4V_APP)) {
                        path = String.valueOf(path) + ExternalToolsPreferencePage.P4V_APPENDED;
                    }
                    ExternalToolsPreferencePage.this.p4VText.setText(path);
                }
            }
        });
        this.p4VLink = new Link((Composite)this.p4VGroup, 0);
        this.p4VLink.setText(Messages.ExternalToolsPreferencePage_DownloadP4V);
        this.p4VLink.setLayoutData((Object)pvlData);
        this.p4VLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsPreferencePage.this.openURL(ExternalToolsPreferencePage.P4V_LINK);
            }
        });
    }

    private void createP4MFAAppConfigGroup(GridLayout layout) {
        this.p4MFAAppGroup = new Group(this.displayArea, 0);
        this.p4MFAAppGroup.setLayout((Layout)layout);
        this.p4MFAAppGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.p4MFAAppGroup.setText(Messages.ExternalToolsPreferencePage_PerforceMFAAppConfig);
        this.p4MFAAppInfo = new Label((Composite)this.p4MFAAppGroup, 16384);
        this.p4MFAAppInfo.setText(Messages.ExternalToolsPreferencePage_UseP4MFAAppConfig);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        this.p4MFAAppInfo.setLayoutData((Object)data);
        this.p4MFAAppLabel = new Label((Composite)this.p4MFAAppGroup, 16384);
        this.p4MFAAppLabel.setText(Messages.ExternalToolsPreferencePage_P4MFAAppConfigPath);
        this.p4MFAAppText = new Text((Composite)this.p4MFAAppGroup, 2052);
        this.p4MFAAppText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.p4MFAAppText.setText(this.getPreferenceStore().getString("com.perforce.team.ui.preferences.P4MFA_APP_PATH"));
        this.p4MFAAppText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExternalToolsPreferencePage.this.validate();
            }
        });
        this.browseMFAAppButton = new Button((Composite)this.p4MFAAppGroup, 8);
        this.browseMFAAppButton.setText(Messages.ExternalToolsPreferencePage_Browse);
        this.browseMFAAppButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ExternalToolsPreferencePage.this.browseMFAAppButton.getShell(), 4096);
                String path = dialog.open();
                if (path != null) {
                    if (P4CoreUtils.isMac() && path.endsWith("HelixMFA.app")) {
                        path = String.valueOf(path) + "/Contents/MacOS/HelixMFA";
                    }
                    ExternalToolsPreferencePage.this.p4MFAAppText.setText(path);
                }
            }
        });
        this.p4MFAAppLink = new Link((Composite)this.p4MFAAppGroup, 0);
        this.p4MFAAppLink.setText(Messages.ExternalToolsPreferencePage_DownloadP4MFAAppConfig);
        this.p4MFAAppLink.setLayoutData((Object)data);
        this.p4MFAAppLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsPreferencePage.this.openURL(ExternalToolsPreferencePage.P4MFA_APP_LINK);
            }
        });
    }

    private void createP4MergeGroup(GridLayout layout) {
        this.p4MergeGroup = new Group(this.displayArea, 0);
        this.p4MergeGroup.setLayout((Layout)layout);
        this.p4MergeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.p4MergeGroup.setText(Messages.ExternalToolsPreferencePage_PerforceMerge);
        this.p4MergeInfo = new Label((Composite)this.p4MergeGroup, 16384);
        this.p4MergeInfo.setText(Messages.ExternalToolsPreferencePage_UseP4MergeForResolving);
        GridData pmlData = new GridData(4, 4, true, false);
        pmlData.horizontalSpan = 3;
        this.p4MergeInfo.setLayoutData((Object)pmlData);
        this.p4MergeLabel = new Label((Composite)this.p4MergeGroup, 16384);
        this.p4MergeLabel.setText(Messages.ExternalToolsPreferencePage_P4MergePath);
        this.p4MergeText = new Text((Composite)this.p4MergeGroup, 2052);
        this.p4MergeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.p4MergeText.setText(this.getPreferenceStore().getString("com.perforce.team.ui.preferences.P4MERGE_PATH"));
        this.p4MergeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExternalToolsPreferencePage.this.validate();
            }
        });
        this.browseButton = new Button((Composite)this.p4MergeGroup, 8);
        this.browseButton.setText(Messages.ExternalToolsPreferencePage_Browse);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ExternalToolsPreferencePage.this.browseButton.getShell(), 4096);
                String path = dialog.open();
                if (path != null) {
                    if (P4CoreUtils.isMac() && path.endsWith(ExternalToolsPreferencePage.P4MERGE_APP)) {
                        path = String.valueOf(path) + ExternalToolsPreferencePage.P4MERGE_APPENDED;
                    }
                    ExternalToolsPreferencePage.this.p4MergeText.setText(path);
                }
            }
        });
        this.p4MergeLink = new Link((Composite)this.p4MergeGroup, 0);
        this.p4MergeLink.setText(Messages.ExternalToolsPreferencePage_DownloadP4Merge);
        this.p4MergeLink.setLayoutData((Object)pmlData);
        this.p4MergeLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsPreferencePage.this.openURL(ExternalToolsPreferencePage.P4MERGE_LINK);
            }
        });
    }

    private void openURL(String url) {
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        boolean opened = false;
        if (support != null) {
            try {
                IWebBrowser browser = support.getExternalBrowser();
                if (browser != null) {
                    browser.openURL(new URL(url));
                    opened = true;
                }
            }
            catch (PartInitException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (MalformedURLException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        if (!opened) {
            P4ConnectionManager.getManager().openInformation(P4UIUtils.getShell(), Messages.ExternalToolsPreferencePage_BrowserLaunchErrorTitle, MessageFormat.format(Messages.ExternalToolsPreferencePage_BrowserLaunchErrorMessage, url));
        }
    }

    private void validate() {
        File file;
        String path = this.p4MergeText.getText().trim();
        if (!(path.length() <= 0 || (file = new File(path)).exists() && file.isFile())) {
            this.setErrorMessage(Messages.ExternalToolsPreferencePage_MustSpecifyP4MergePath);
            this.setValid(false);
            return;
        }
        path = this.p4VText.getText().trim();
        if (!(path.length() <= 0 || (file = new File(path)).exists() && file.isFile())) {
            this.setErrorMessage(Messages.ExternalToolsPreferencePage_MustSpecifyP4VPath);
            this.setValid(false);
            return;
        }
        this.setValid(true);
        this.setErrorMessage(null);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(PerforceUIPlugin.getPlugin().getPreferenceStore());
    }

    public void setP4MergeText(String path) {
        if (path != null) {
            this.p4MergeText.setText(path);
        }
    }

    public String getP4MergeText() {
        return this.p4MergeText.getText();
    }

    public void setP4VText(String path) {
        if (path != null) {
            this.p4VText.setText(path);
        }
    }

    public String getP4VText() {
        return this.p4VText.getText();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("com.perforce.team.ui.preferences.P4MERGE_PATH", this.p4MergeText.getText().trim());
        this.getPreferenceStore().setValue("com.perforce.team.ui.preferences.P4VC_PATH", this.p4VText.getText().trim());
        this.getPreferenceStore().setValue("com.perforce.team.ui.preferences.P4MFA_APP_PATH", this.p4MFAAppText.getText().trim());
        return super.performOk();
    }
}

