/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4merge;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4merge.ApplicationRunner;
import com.perforce.team.ui.p4merge.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class MergeRunner
extends ApplicationRunner {
    private IP4Connection connection = null;
    private IP4File file;
    private String basePath = null;
    private String leftPath = null;
    private String rightPath = null;
    private boolean loadBase = false;
    private boolean loadLeft = false;
    private boolean loadRight = false;
    private String baseFile = null;
    private String leftFile = null;
    private String rightFile = null;
    private String mergeFile = null;
    private int startFromRev = -1;
    private int endFromRev = -1;
    private IP4Resource resolved;

    public MergeRunner(IP4Connection connection, IP4File file, String basePath, boolean loadBase, String leftPath, boolean loadLeft, String rightPath, boolean loadRight, int startFromRev, int endFromRev) {
        this.connection = connection;
        this.file = file;
        this.basePath = basePath;
        this.leftPath = leftPath;
        this.rightPath = rightPath;
        this.loadBase = loadBase;
        this.loadLeft = loadLeft;
        this.loadRight = loadRight;
        this.startFromRev = startFromRev;
        this.endFromRev = endFromRev;
    }

    @Override
    protected IP4Connection getConnection() {
        return this.connection;
    }

    public IP4Resource getResolved() {
        return this.resolved;
    }

    @Override
    protected ProcessBuilder getBuilder() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.getPreferenceValue());
        arguments.add("-ll");
        arguments.add(Messages.MergeRunner_Theirs);
        arguments.add("-rl");
        arguments.add(Messages.MergeRunner_Yours);
        arguments.add("-C");
        String charset = this.connection.getParameters().getCharset();
        if (charset == null) {
            charset = "none";
        }
        arguments.add(charset);
        arguments.add("-nm");
        arguments.add(Messages.MergeRunner_MergeFileUsedForResolve);
        arguments.add("-nl");
        arguments.add(this.leftPath);
        arguments.add("-nr");
        arguments.add(this.rightPath);
        arguments.add("-nb");
        arguments.add(this.basePath);
        arguments.add(this.baseFile);
        arguments.add(this.leftFile);
        arguments.add(this.rightFile);
        arguments.add(this.mergeFile);
        return new ProcessBuilder(arguments);
    }

    @Override
    protected String getPreference() {
        return "com.perforce.team.ui.preferences.P4MERGE_PATH";
    }

    @Override
    protected boolean loadFiles() {
        boolean success = true;
        if (this.loadBase) {
            File baseFile = this.connection.printToTempFile(this.basePath);
            if (baseFile != null) {
                this.baseFile = baseFile.getAbsolutePath();
            } else {
                success = false;
            }
        } else {
            this.baseFile = this.basePath;
        }
        if (this.loadLeft) {
            File leftFile = this.connection.printToTempFile(this.leftPath);
            if (leftFile != null) {
                this.leftFile = leftFile.getAbsolutePath();
            } else {
                success = false;
            }
        } else {
            this.leftFile = this.leftPath;
        }
        if (this.loadRight) {
            File rightFile = this.connection.printToTempFile(this.rightPath);
            if (rightFile != null) {
                this.rightFile = rightFile.getAbsolutePath();
            } else {
                success = false;
            }
        } else {
            this.rightFile = this.rightPath;
        }
        try {
            this.mergeFile = File.createTempFile("p4ws", ".tmp").getAbsolutePath();
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    @Override
    protected String getApplicationName() {
        return "P4Merge";
    }

    @Override
    protected String getTaskName() {
        return this.rightFile;
    }

    @Override
    protected void applicationFinished(int exitCode) {
        if (exitCode == 0) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    final String name = MergeRunner.this.file.getName();
                    boolean replace = P4ConnectionManager.getManager().openQuestion(P4UIUtils.getShell(), Messages.MergeRunner_ReplaceMergedTitle, MessageFormat.format(Messages.MergeRunner_ReplaceMergedMessage, name));
                    if (replace) {
                        P4Runnable runnable = new P4Runnable(){

                            public void run(IProgressMonitor monitor) {
                                WorkspaceModifyOperation replaceFile = new WorkspaceModifyOperation(){

                                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                        try {
                                            P4Collection single = P4ConnectionManager.getManager().createP4Collection(new IP4Resource[]{MergeRunner.this.file});
                                            single.setType(IP4Resource.Type.LOCAL);
                                            IP4Resource[] resolved = single.resolve((InputStream)new FileInputStream(MergeRunner.this.mergeFile), true, MergeRunner.this.startFromRev, MergeRunner.this.endFromRev);
                                            if (resolved != null && resolved.length == 1) {
                                                MergeRunner.this.resolved = resolved[0];
                                            }
                                        }
                                        catch (Exception e) {
                                            PerforceProviderPlugin.logError((Throwable)e);
                                        }
                                    }
                                };
                                try {
                                    replaceFile.run((IProgressMonitor)new NullProgressMonitor());
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }

                            public String getTitle() {
                                return MessageFormat.format(Messages.MergeRunner_Resolving, name);
                            }
                        };
                        if (MergeRunner.this.isAsync()) {
                            P4Runner.schedule((IP4Runnable)runnable);
                        } else {
                            runnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                }
            });
        }
    }
}

