/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.ui.PerforceUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public class WrappingPainter {
    private TextViewer viewer = null;
    private MarginPainter painter = null;
    private Color color = null;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("com.perforce.team.ui.preferences.DESCRIPTION_RULER".equals(property) || "com.perforce.team.ui.preferences.DESCRIPTION_RULER_COLOR".equals(property) || "com.perforce.team.ui.preferences.DESCRIPTION_RULER_COLUMN".equals(property) || "com.perforce.team.ui.preferences.DESCRIPTION_RULER_STYLE".equals(property)) {
                WrappingPainter.this.refresh();
            }
        }
    };

    public WrappingPainter(TextViewer viewer) {
        this.viewer = viewer;
        PerforceUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener(this.listener);
        this.viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                try {
                    if (WrappingPainter.this.color != null && !WrappingPainter.this.color.isDisposed()) {
                        WrappingPainter.this.color.dispose();
                    }
                }
                finally {
                    PerforceUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener(WrappingPainter.this.listener);
                }
            }
        });
        this.refresh();
    }

    private void show() {
        Color oldColor = this.color;
        boolean add = false;
        if (this.painter == null) {
            this.painter = new MarginPainter((ITextViewer)this.viewer);
            this.painter.setMarginRulerWidth(1);
            add = true;
        }
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        int column = store.getInt("com.perforce.team.ui.preferences.DESCRIPTION_RULER_COLUMN");
        this.painter.setMarginRulerColumn(column);
        int style = store.getInt("com.perforce.team.ui.preferences.DESCRIPTION_RULER_STYLE");
        this.painter.setMarginRulerStyle(style);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.perforce.team.ui.preferences.DESCRIPTION_RULER_COLOR");
        this.color = new Color((Device)this.viewer.getTextWidget().getDisplay(), rgb);
        this.painter.setMarginRulerColor(this.color);
        if (oldColor != null && !oldColor.isDisposed()) {
            oldColor.dispose();
        }
        if (add) {
            this.viewer.addPainter((IPainter)this.painter);
        }
        this.painter.initialize();
    }

    private void hide() {
        if (this.painter != null) {
            this.viewer.removePainter((IPainter)this.painter);
            this.painter.deactivate(true);
            this.painter.dispose();
            this.painter = null;
        }
    }

    public void refresh() {
        if (!this.viewer.getTextWidget().isDisposed()) {
            IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
            boolean enabled = store.getBoolean("com.perforce.team.ui.preferences.DESCRIPTION_RULER");
            if (enabled) {
                int column = store.getInt("com.perforce.team.ui.preferences.DESCRIPTION_RULER_COLUMN");
                boolean bl = enabled = column > 0;
            }
            if (enabled) {
                this.show();
            } else {
                this.hide();
            }
        }
    }
}

