/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Label;
import com.perforce.team.ui.p4java.dialogs.BrowseChangeListDialog;
import com.perforce.team.ui.p4java.dialogs.BrowseLabelDialog;
import com.perforce.team.ui.p4java.dialogs.IntegrateToStreamDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.p4java.dialogs.VersionComboViewer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RevisionRangeWidget2
extends Composite
implements IntegrateToStreamDialog.IRevisionRangeWidget {
    private Button endButton;
    private VersionComboViewer endCombo;
    private Text endText;
    private Button endBrowseBtn;
    private Object startVer = null;
    private Object endVer = null;
    private String startOption = null;
    private String endOption = null;
    private IP4Connection connection;
    private Button startButton;
    private VersionComboViewer startCombo;
    private Text startText;
    private Button startBrowseBtn;

    public RevisionRangeWidget2(Composite parent, int style, String title, IP4Connection connection) {
        super(parent, style);
        this.connection = connection;
        this.createControl(this, title);
        this.init();
        this.addListeners();
    }

    private void init() {
        boolean enableStart = true;
        if (this.startOption == null) {
            enableStart = false;
        }
        this.startButton.setSelection(enableStart);
        this.startCombo.setEnabled(enableStart);
        this.startText.setEnabled(enableStart);
        this.startBrowseBtn.setEnabled(enableStart);
        boolean enableEnd = true;
        if (this.endOption == null) {
            enableEnd = false;
        }
        this.endButton.setSelection(enableEnd);
        this.endCombo.setEnabled(enableEnd);
        this.endText.setEnabled(enableEnd);
        this.endBrowseBtn.setEnabled(enableEnd);
    }

    private void addListeners() {
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = RevisionRangeWidget2.this.startButton.getSelection();
                RevisionRangeWidget2.this.startCombo.setEnabled(enabled);
                RevisionRangeWidget2.this.startText.setEnabled(enabled);
                RevisionRangeWidget2.this.startBrowseBtn.setEnabled(RevisionRangeWidget2.this.startCombo.getSelectedObject() != null && RevisionRangeWidget2.this.startCombo.getSelectedObject() != VersionComboViewer.VersionType.Revision && enabled);
                if (!enabled) {
                    RevisionRangeWidget2.this.startOption = null;
                }
                if (RevisionRangeWidget2.this.startButton.getSelection() && !RevisionRangeWidget2.this.endButton.getSelection()) {
                    RevisionRangeWidget2.this.endButton.setSelection(true);
                    RevisionRangeWidget2.this.endCombo.setEnabled(true);
                    RevisionRangeWidget2.this.endText.setEnabled(true);
                    RevisionRangeWidget2.this.endBrowseBtn.setEnabled(RevisionRangeWidget2.this.endCombo.getSelectedObject() != null && RevisionRangeWidget2.this.endCombo.getSelectedObject() != VersionComboViewer.VersionType.Revision);
                }
            }
        });
        this.startCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RevisionRangeWidget2.this.startText.setText("");
                RevisionRangeWidget2.this.startOption = String.valueOf(RevisionRangeWidget2.this.getPrefix(RevisionRangeWidget2.this.startCombo)) + RevisionRangeWidget2.this.startText.getText();
                RevisionRangeWidget2.this.startBrowseBtn.setEnabled(RevisionRangeWidget2.this.startCombo.getSelectedObject() != null && RevisionRangeWidget2.this.startCombo.getSelectedObject() != VersionComboViewer.VersionType.Revision);
            }
        });
        this.startText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RevisionRangeWidget2.this.startOption = String.valueOf(RevisionRangeWidget2.this.getPrefix(RevisionRangeWidget2.this.startCombo)) + RevisionRangeWidget2.this.startText.getText();
            }
        });
        this.startBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionComboViewer.VersionType type = RevisionRangeWidget2.this.startCombo.getSelectedObject();
                if (type != VersionComboViewer.VersionType.Revision) {
                    BrowseChangeListDialog dlg;
                    if (type == VersionComboViewer.VersionType.Label) {
                        BrowseLabelDialog dlg2 = new BrowseLabelDialog(RevisionRangeWidget2.this.getShell(), RevisionRangeWidget2.this.connection);
                        if (dlg2.open() == 0) {
                            RevisionRangeWidget2.this.startVer = dlg2.getSelectedLabel();
                            RevisionRangeWidget2.this.startText.setText(((IP4Label)RevisionRangeWidget2.this.startVer).getLabel().getName());
                        }
                    } else if (type == VersionComboViewer.VersionType.ChangeList && (dlg = new BrowseChangeListDialog(RevisionRangeWidget2.this.getShell(), RevisionRangeWidget2.this.connection)).open() == 0) {
                        RevisionRangeWidget2.this.startVer = dlg.getSelectedChangeList();
                        RevisionRangeWidget2.this.startText.setText(String.valueOf(((IP4Changelist)RevisionRangeWidget2.this.startVer).getChangelist().getId()));
                    }
                }
            }
        });
        this.endButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = RevisionRangeWidget2.this.endButton.getSelection();
                RevisionRangeWidget2.this.endCombo.setEnabled(enabled);
                RevisionRangeWidget2.this.endText.setEnabled(enabled);
                RevisionRangeWidget2.this.endBrowseBtn.setEnabled(RevisionRangeWidget2.this.endCombo.getSelectedObject() != null && enabled);
                if (!enabled) {
                    RevisionRangeWidget2.this.endOption = null;
                }
            }
        });
        this.endCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RevisionRangeWidget2.this.endText.setText("");
                RevisionRangeWidget2.this.endOption = String.valueOf(RevisionRangeWidget2.this.getPrefix(RevisionRangeWidget2.this.endCombo)) + RevisionRangeWidget2.this.endText.getText();
                RevisionRangeWidget2.this.endBrowseBtn.setEnabled(RevisionRangeWidget2.this.endCombo.getSelectedObject() != null && RevisionRangeWidget2.this.endCombo.getSelectedObject() != VersionComboViewer.VersionType.Revision);
            }
        });
        this.endText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RevisionRangeWidget2.this.endOption = String.valueOf(RevisionRangeWidget2.this.getPrefix(RevisionRangeWidget2.this.endCombo)) + RevisionRangeWidget2.this.endText.getText();
            }
        });
        this.endBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionComboViewer.VersionType type = RevisionRangeWidget2.this.endCombo.getSelectedObject();
                if (type != VersionComboViewer.VersionType.Revision) {
                    BrowseChangeListDialog dlg;
                    if (type == VersionComboViewer.VersionType.Label) {
                        BrowseLabelDialog dlg2 = new BrowseLabelDialog(RevisionRangeWidget2.this.getShell(), RevisionRangeWidget2.this.connection);
                        if (dlg2.open() == 0) {
                            RevisionRangeWidget2.this.endVer = dlg2.getSelectedLabel();
                            RevisionRangeWidget2.this.endText.setText(((IP4Label)RevisionRangeWidget2.this.endVer).getLabel().getName());
                        }
                    } else if (type == VersionComboViewer.VersionType.ChangeList && (dlg = new BrowseChangeListDialog(RevisionRangeWidget2.this.getShell(), RevisionRangeWidget2.this.connection)).open() == 0) {
                        RevisionRangeWidget2.this.endVer = dlg.getSelectedChangeList();
                        RevisionRangeWidget2.this.endText.setText(String.valueOf(((IP4Changelist)RevisionRangeWidget2.this.endVer).getChangelist().getId()));
                    }
                }
            }
        });
    }

    private void createControl(Composite parent, String title) {
        parent.setLayout((Layout)new FillLayout());
        Group limitArea = new Group(parent, 0);
        limitArea.setText(title);
        limitArea.setLayout((Layout)new GridLayout(4, false));
        this.startButton = new Button((Composite)limitArea, 32);
        this.startButton.setText(Messages.RevisionRangeWidget2_Start);
        this.startCombo = new VersionComboViewer((Composite)limitArea, 8);
        this.startCombo.setEnabled(false);
        this.startText = new Text((Composite)limitArea, 2052);
        this.startText.setEnabled(false);
        GridDataFactory.swtDefaults().hint(50, -1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.startText);
        this.startBrowseBtn = new Button((Composite)limitArea, 16384);
        this.startBrowseBtn.setText(Messages.RevisionRangeWidget2_Browse);
        this.startBrowseBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.endButton = new Button((Composite)limitArea, 32);
        this.endButton.setText(Messages.RevisionRangeWidget2_End);
        this.endCombo = new VersionComboViewer((Composite)limitArea, 8);
        this.endCombo.setEnabled(false);
        this.endText = new Text((Composite)limitArea, 2052);
        this.endText.setEnabled(false);
        GridDataFactory.swtDefaults().hint(50, -1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.endText);
        this.endBrowseBtn = new Button((Composite)limitArea, 16384);
        this.endBrowseBtn.setText(Messages.RevisionRangeWidget2_Browse);
        this.endBrowseBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    private String getPrefix(VersionComboViewer combo) {
        VersionComboViewer.VersionType type = combo.getSelectedObject();
        if (type != null) {
            return type.getPrefix();
        }
        return "";
    }

    @Override
    public IStatus validate() {
        boolean hasEnd;
        boolean hasStart = this.startButton.getSelection();
        if (hasStart) {
            if (this.startCombo.getSelectedObject() == null) {
                return ValidationStatus.error((String)Messages.RevisionRangeWidget2_StartTypeEmptyError);
            }
            if (StringUtils.isEmpty((CharSequence)this.startText.getText())) {
                return ValidationStatus.error((String)Messages.RevisionRangeWidget2_StartVersionEmptyError);
            }
        }
        if (hasEnd = this.endButton.getSelection()) {
            if (this.endCombo.getSelectedObject() == null) {
                return ValidationStatus.error((String)Messages.RevisionRangeWidget2_EndTypeEmptyError);
            }
            if (StringUtils.isEmpty((CharSequence)this.endText.getText())) {
                return ValidationStatus.error((String)Messages.RevisionRangeWidget2_EndVersionEmptyError);
            }
        }
        return ValidationStatus.ok();
    }

    @Override
    public String getStart() {
        return this.startOption;
    }

    @Override
    public String getEnd() {
        return this.endOption;
    }

    @Override
    public Composite getControl() {
        return this;
    }
}

