/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.client.MergeFilesOptions;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.P4FileIntegration;
import com.perforce.team.ui.p4java.dialogs.DepotFileChooser;
import com.perforce.team.ui.p4java.dialogs.IntegrateToStreamDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.p4java.dialogs.RevisionRangeWidget2;
import com.perforce.team.ui.p4java.dialogs.SourceTargetStreamWidget;
import com.perforce.team.ui.streams.StreamUtil;
import java.util.List;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;

public class MergeToStreamDialog
extends IntegrateToStreamDialog {
    public MergeToStreamDialog(Shell parent, IP4Resource resource) {
        super(parent, resource, Messages.MergeToStreamDialog_MergeToStream);
    }

    @Override
    protected IntegrateToStreamDialog.IRevisionRangeWidget createRevisionRangeWidget(Composite parent) {
        return new RevisionRangeWidget2(parent, 0, Messages.MergeToStreamDialog_LimitRevisionRange, this.getConnection());
    }

    @Override
    protected Point getPreferredSize() {
        return new Point(700, 600);
    }

    @Override
    protected IntegrateToStreamDialog.IDepotFileChooser createFolderWidget(Composite parent, final IP4Resource resource) {
        return new DepotFileChooser(parent, 0, resource, (IWorkbenchAdapter)new WorkbenchAdapter(){

            public Object[] getChildren(Object o) {
                String stream = resource.getClient().getStream();
                IP4Resource[] resources = resource.getConnection().members();
                IP4Resource streamRoot = resources[0];
                IP4Container depot = null;
                int i = 0;
                while (i < resources.length) {
                    if (stream.startsWith(resources[i].getRemotePath()) && resources[i] instanceof IP4Container) {
                        depot = (IP4Container)resources[i];
                        break;
                    }
                    ++i;
                }
                if (depot != null) {
                    depot.refresh(1);
                    IP4Resource[] iP4ResourceArray = depot.members();
                    int n = iP4ResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4Resource m = iP4ResourceArray[n2];
                        if (m.getRemotePath().startsWith(stream)) {
                            streamRoot = m;
                            break;
                        }
                        ++n2;
                    }
                }
                return new Object[]{streamRoot};
            }
        });
    }

    @Override
    protected List<IStreamSummary> getPreferredStreams(IP4Resource resource) {
        IStream stream = StreamUtil.getStream(resource.getConnection());
        return StreamUtil.getPreferredMergeSources(stream, resource.getConnection());
    }

    @Override
    protected SourceTargetStreamWidget createSourceTargetWidget(Composite parent, final IP4Resource resource) {
        return new SourceTargetStreamWidget(parent, 0, Messages.MergeToStreamDialog_InformationText, resource){

            @Override
            public Runnable getNonUIJob() {
                return new Runnable(){

                    @Override
                    public void run() {
                        targetStream = resource instanceof IP4Stream ? (IStream)resource.getAdapter(IStream.class) : StreamUtil.getStream(resource.getConnection());
                        preferredStreams.addAll(StreamUtil.getPreferredMergeSources(targetStream, resource.getConnection()));
                    }
                };
            }
        };
    }

    @Override
    protected Options updatePreviewOptions() {
        MergeFilesOptions option = this.updateOptions();
        option.setShowActionsOnly(true);
        return option;
    }

    @Override
    protected IP4Resource[] doIntegrate(IP4Connection connection, P4FileIntegration integration, String description, Options options) {
        if (options instanceof MergeFilesOptions) {
            return connection.mergeStream(integration, description, (MergeFilesOptions)options);
        }
        return null;
    }

    @Override
    protected Options updateNonPreviewOptions() {
        MergeFilesOptions option = this.updateOptions();
        option.setShowActionsOnly(false);
        return option;
    }

    private MergeFilesOptions updateOptions() {
        MergeFilesOptions option = new MergeFilesOptions();
        option.setBidirectionalInteg(false);
        option.setChangelistId(this.getChangelist());
        option.setForceStreamMerge(false);
        IStreamSummary source = this.pathWidget.getSourcePath();
        IStreamSummary target = this.pathWidget.getTargetPath();
        Object effectiveTarget = null;
        effectiveTarget = target.getType() == IStreamSummary.Type.VIRTUAL ? StreamUtil.getBaseParent(target, this.getConnection()) : this.getConnection().getStreamSummary(target.getStream());
        Object effectiveSource = null;
        effectiveSource = source.getType() == IStreamSummary.Type.VIRTUAL ? StreamUtil.getBaseParent(source, this.getConnection()) : this.getConnection().getStreamSummary(source.getStream());
        Assert.isNotNull((Object)effectiveSource);
        Assert.isNotNull((Object)effectiveTarget);
        if (effectiveTarget.getStream().equals(effectiveSource.getParent()) || effectiveTarget.getStream().equals(StreamUtil.getBaseParent((IStreamSummary)effectiveSource))) {
            option.setStream(source.getStream());
            option.setReverseMapping(false);
        } else if (effectiveSource.getStream().equals(effectiveTarget.getParent()) || effectiveSource.getStream().equals(StreamUtil.getBaseParent((IStreamSummary)effectiveTarget))) {
            option.setStream(target.getStream());
            option.setReverseMapping(true);
        } else if (effectiveTarget.getType() == IStreamSummary.Type.RELEASE && effectiveSource.getType() != IStreamSummary.Type.DEVELOPMENT || effectiveTarget.getType() == IStreamSummary.Type.DEVELOPMENT && effectiveSource.getType() == IStreamSummary.Type.MAINLINE) {
            option.setStream(target.getStream());
            option.setParentStream(source.getStream());
            option.setReverseMapping(true);
        } else {
            option.setStream(source.getStream());
            option.setParentStream(target.getStream());
            option.setReverseMapping(false);
        }
        return option;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.MergeToStreamDialog_Merge;
    }

    @Override
    protected IStatus validateTaskStreamOp() {
        IStreamSummary source = this.pathWidget.getSourcePath();
        IStreamSummary target = this.pathWidget.getTargetPath();
        if (target.getType() == IStreamSummary.Type.TASK && !source.getStream().equals(target.getParent())) {
            String msg = Messages.MergeToStreamDialog_TaskStreamCannotMergeFromNonParent;
            return ValidationStatus.error((String)msg);
        }
        return ValidationStatus.ok();
    }
}

