/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.DescriptionTemplate;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import java.util.List;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DescriptionTemplatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.perforce.team.ui.dialogs.DescriptionTemplatesPreferencePage";
    private TableViewer descTable;
    private TextViewer previewText;
    private List<DescriptionTemplate> templates;
    private IntegerFieldEditor storeDescriptions;

    private void createDescriptionArea(Composite parent) {
        Composite descArea = new Composite(parent, 0);
        descArea.setLayout((Layout)new GridLayout(2, false));
        descArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData twoColData = new GridData(4, 4, true, false);
        twoColData.horizontalSpan = 2;
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        final Image newImage = plugin.getImageDescriptor("normal/add.png").createImage();
        final Image editImage = plugin.getImageDescriptor("normal/edit.png").createImage();
        final Image removeImage = plugin.getImageDescriptor("normal/delete.png").createImage();
        descArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newImage.dispose();
                editImage.dispose();
                removeImage.dispose();
            }
        });
        Label descLabel = new Label(descArea, 16384);
        descLabel.setText(Messages.DescriptionTemplatesPreferencePage_CreateEditRemoveChangelistDescriptionTemplates);
        descLabel.setLayoutData((Object)twoColData);
        this.descTable = new TableViewer(descArea, 68356);
        this.descTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.descTable.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.descTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.templates = DescriptionTemplate.getTemplates();
        this.descTable.setInput(this.templates);
        ToolBar buttonBar = new ToolBar(descArea, 0x800200);
        buttonBar.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        ToolItem newItem = new ToolItem(buttonBar, 8);
        newItem.setToolTipText(Messages.DescriptionTemplatesPreferencePage_AddNewChangelistDescriptionTemplate);
        newItem.setImage(newImage);
        newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditDescriptionDialog dialog = new EditDescriptionDialog(DescriptionTemplatesPreferencePage.this.getShell(), Messages.DescriptionTemplatesPreferencePage_AddChangelistDescriptionTemplate);
                if (dialog.open() == 0) {
                    DescriptionTemplatesPreferencePage.this.templates.add(new DescriptionTemplate(dialog.content));
                    DescriptionTemplatesPreferencePage.this.descTable.refresh();
                    DescriptionTemplatesPreferencePage.this.updatePreview();
                }
            }
        });
        ToolItem editItem = new ToolItem(buttonBar, 8);
        editItem.setToolTipText(Messages.DescriptionTemplatesPreferencePage_EditSelectedChangelistDescriptionTemplate);
        editItem.setImage(editImage);
        editItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DescriptionTemplatesPreferencePage.this.edit(DescriptionTemplatesPreferencePage.this.descTable.getSelection());
            }
        });
        ToolItem removeItem = new ToolItem(buttonBar, 8);
        removeItem.setToolTipText(Messages.DescriptionTemplatesPreferencePage_RemoveSelectedChangelistDescriptionTemplate);
        removeItem.setImage(removeImage);
        removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selected = ((IStructuredSelection)DescriptionTemplatesPreferencePage.this.descTable.getSelection()).getFirstElement();
                if (selected instanceof DescriptionTemplate) {
                    DescriptionTemplatesPreferencePage.this.templates.remove(selected);
                    DescriptionTemplatesPreferencePage.this.descTable.refresh();
                    DescriptionTemplatesPreferencePage.this.updatePreview();
                }
            }
        });
        Label previewLabel = new Label(descArea, 16384);
        previewLabel.setText(Messages.DescriptionTemplatesPreferencePage_Preview);
        previewLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        previewLabel.setLayoutData((Object)twoColData);
        this.previewText = new TextViewer(descArea, 2826);
        this.previewText.setDocument((IDocument)new Document());
        GridData ptData = new GridData(4, 4, true, true);
        ptData.horizontalSpan = 2;
        this.previewText.getTextWidget().setLayoutData((Object)ptData);
        this.descTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((IStructuredSelection)DescriptionTemplatesPreferencePage.this.descTable.getSelection()).getFirstElement();
                if (selected instanceof DescriptionTemplate) {
                    DescriptionTemplatesPreferencePage.this.previewText.getDocument().set(((DescriptionTemplate)selected).getContent());
                } else {
                    DescriptionTemplatesPreferencePage.this.previewText.getDocument().set("");
                }
            }
        });
        this.descTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DescriptionTemplatesPreferencePage.this.edit(DescriptionTemplatesPreferencePage.this.descTable.getSelection());
            }
        });
    }

    private void edit(ISelection selection) {
        Object selected;
        if (selection instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) instanceof DescriptionTemplate) {
            DescriptionTemplate tpl = (DescriptionTemplate)selected;
            EditDescriptionDialog dialog = new EditDescriptionDialog(this.getShell(), Messages.DescriptionTemplatesPreferencePage_EditChangelistDescriptionTemplate, tpl.getContent());
            if (dialog.open() == 0) {
                tpl.setContent(dialog.getContent());
                this.descTable.refresh();
                this.updatePreview();
            }
        }
    }

    private void createOptionsArea(Composite parent) {
        Composite optionsArea = new Composite(parent, 0);
        GridLayout oaLayout = new GridLayout(1, true);
        oaLayout.marginHeight = 0;
        oaLayout.marginWidth = 0;
        optionsArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.storeDescriptions = new IntegerFieldEditor("com.perforce.team.ui.preferences.CHANGELISTS_SAVED", Messages.DescriptionTemplatesPreferencePage_MaxNumberOfChangelistsInHistory, optionsArea);
        this.storeDescriptions.setPreferenceStore(PerforceUIPlugin.getPlugin().getPreferenceStore());
        this.storeDescriptions.load();
    }

    private void updatePreview() {
        Object selected = ((IStructuredSelection)this.descTable.getSelection()).getFirstElement();
        if (selected instanceof DescriptionTemplate) {
            this.previewText.getDocument().set(((DescriptionTemplate)selected).getContent());
        } else {
            this.previewText.getDocument().set("");
        }
    }

    protected void performDefaults() {
        this.storeDescriptions.loadDefault();
        this.templates.clear();
        this.descTable.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storeDescriptions.store();
        DescriptionTemplate.saveTemplates(this.templates);
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        displayArea.setLayout((Layout)daLayout);
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createOptionsArea(displayArea);
        this.createDescriptionArea(displayArea);
        return displayArea;
    }

    public void init(IWorkbench workbench) {
    }

    private static class EditDescriptionDialog
    extends P4StatusDialog {
        private TextViewer viewer;
        private String content = null;

        public EditDescriptionDialog(Shell parent, String title, String content) {
            super(parent, title);
            this.content = content;
            this.setModalResizeStyle();
        }

        public EditDescriptionDialog(Shell parent, String title) {
            this(parent, title, null);
        }

        protected void okPressed() {
            this.content = this.viewer.getDocument().get();
            super.okPressed();
        }

        String getContent() {
            return this.content;
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            Label templateLabel = new Label(c, 16384);
            templateLabel.setText(Messages.DescriptionTemplatesPreferencePage_ChangelistDescriptionTemplate);
            this.viewer = new TextViewer(c, 2818);
            GridData vData = new GridData(4, 4, true, true);
            vData.heightHint = Math.max(100, this.convertHeightInCharsToPixels(15));
            vData.widthHint = Math.max(300, this.convertWidthInCharsToPixels(80));
            this.viewer.getTextWidget().setLayoutData((Object)vData);
            this.viewer.setDocument((IDocument)new Document());
            if (this.content != null) {
                this.viewer.getDocument().set(this.content);
            }
            this.viewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    EditDescriptionDialog.this.validate();
                }
            });
            this.validate();
            return c;
        }

        private void validate() {
            if (this.viewer.getDocument().get().trim().length() == 0) {
                this.setErrorMessage(Messages.DescriptionTemplatesPreferencePage_ChangelistDescriptionCantBeEmpty, null);
            } else {
                this.setErrorMessage(null);
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.viewer.getTextWidget().setFocus();
        }
    }
}

