/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.history.P4HistoryPageSource;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.views.SubmittedView;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;

public class ShowHistoryAction
extends P4Action {
    @Override
    protected void runAction() {
        IP4Resource resource = this.getSingleResourceSelection();
        final IP4File file = (IP4File)P4CoreUtils.convert((Object)resource, IP4File.class);
        if (file != null) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    P4HistoryPageSource source = new P4HistoryPageSource(file);
                    try {
                        IViewPart part = PerforceUIPlugin.getActivePage().showView("org.eclipse.team.ui.GenericHistoryView");
                        if (part instanceof IHistoryView) {
                            ((IHistoryView)part).showHistoryFor((Object)source);
                        } else {
                            PerforceProviderPlugin.logError((String)"Error opening History view. Class of view was not expected: GenericHistoryView");
                        }
                    }
                    catch (PartInitException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                }
            });
        } else if (resource instanceof IP4Folder) {
            final IP4Folder folder = (IP4Folder)resource;
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    SubmittedView view = SubmittedView.showView();
                    if (view != null) {
                        view.scheduleShowChangelists((IP4Resource)folder);
                    }
                }
            });
        }
    }

    @Override
    protected boolean isEnabledEx() throws TeamException {
        boolean enabled = false;
        if (this.containsOnlineConnection() && this.getSelectionSize() == 1 && !(enabled = this.containsContainers())) {
            IP4Resource resource = this.getSingleResourceSelection();
            enabled = resource instanceof IP4Folder || P4CoreUtils.convert((Object)resource, IP4File.class) != null;
        }
        return enabled;
    }
}

