/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4TeamUtils;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.project.ShareProjectsDialog;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;

public class ShareProjectsAction
extends P4Action {
    @Override
    protected boolean isEnabledEx() throws TeamException {
        return this.containsSingleOnlineConnection();
    }

    @Override
    protected void runAction() {
        ShareProjectsDialog dialog;
        IP4Connection connection;
        IP4Resource resource = this.getSingleResourceSelection();
        if (resource != null && (connection = resource.getConnection()) != null && (dialog = new ShareProjectsDialog(P4UIUtils.getShell(), connection)).open() == 0) {
            this.shareProjects(connection, dialog.getSelectedProjects());
        }
    }

    public void shareProjects(final IP4Connection connection, final IProject[] projects) {
        if (connection != null && projects != null && projects.length > 0) {
            final String title = MessageFormat.format(Messages.ShareProjectsAction_SharingProjectsMessage, projects.length, connection.getName());
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(this.getTitle(), projects.length);
                    ConnectionParameters params = connection.getParameters();
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        monitor.setTaskName(MessageFormat.format(Messages.ShareProjectsAction_SharingProject, project.getName()));
                        P4TeamUtils.shareProject(project, params);
                        monitor.worked(1);
                        ++n2;
                    }
                    monitor.done();
                }

                public String getTitle() {
                    return title.toString();
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }
}

