/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Folder;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.actions.RefreshAction;

public class RemoveAction
extends P4Action {
    @Override
    protected void runAction() {
        P4Collection collection = this.getResourceSelection();
        if (!collection.isEmpty()) {
            if (RemoveAction.isNeedConfirm()) {
                RemoveFromWorkspaceDialog dlg = new RemoveFromWorkspaceDialog(null, collection);
                if (dlg.open() == 0) {
                    this.sync(collection);
                }
            } else {
                this.sync(collection);
            }
        }
    }

    private void sync(final P4Collection collection) {
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return Messages.RemoveAction_RemovingFromWorkspace;
            }

            public void run(IProgressMonitor monitor) {
                Object[] selected;
                collection.sync("#0", monitor);
                collection.refreshLocalResources(2);
                RemoveAction.this.updateActionState();
                boolean needRefresh = false;
                IStructuredSelection selectionToRefresh = RemoveAction.this.getSelection();
                Object[] objectArray = selected = RemoveAction.this.getSelection().toArray();
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    Object select = objectArray[n2];
                    if (select instanceof IProject) {
                        IProject prj = (IProject)select;
                        if (prj != null && prj.getLocation() != null && prj.getLocation().toFile() != null && !prj.getLocation().toFile().exists()) {
                            needRefresh = true;
                            break;
                        }
                    } else if (select instanceof P4Folder) {
                        IProject[] prjs;
                        String localPath = ((P4Folder)select).getLocalPath();
                        IProject[] iProjectArray = prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int n3 = prjs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IProject prj = iProjectArray[n4];
                            if (prj.isOpen() && prj.getLocation().toOSString().equals(localPath)) {
                                needRefresh = true;
                                selectionToRefresh = new StructuredSelection((Object)prj);
                                break;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                if (needRefresh) {
                    RefreshAction refresh = new RefreshAction(new IShellProvider(){

                        public Shell getShell() {
                            return RemoveAction.this.getShell();
                        }
                    });
                    refresh.selectionChanged(selectionToRefresh);
                    refresh.refreshAll();
                }
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    protected boolean isEnabledEx() throws TeamException {
        boolean enabled = this.containsOnlineConnection();
        if (enabled && !(enabled = this.containsContainers())) {
            P4Collection collection = this.getResourceSelection();
            IP4Resource[] iP4ResourceArray = collection.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4File file;
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource.isContainer()) {
                    enabled = true;
                    break;
                }
                if (resource instanceof IP4File && (file = (IP4File)resource).getHaveRevision() > 0 && file.getAction() == null) {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }

    public static boolean isNeedConfirm() {
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        return store.getBoolean("pref_prompt_on_deleting_managed_folders");
    }

    public static void setNeedConfirm(boolean needConfirm) {
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        store.setValue("pref_prompt_on_deleting_managed_folders", needConfirm);
    }

    static class RemoveFromWorkspaceDialog
    extends MessageDialog {
        private Button noPromptButton;

        RemoveFromWorkspaceDialog(Shell parentShell, P4Collection collection) {
            super(parentShell, Messages.RemoveAction_RemoveDialogTitle, null, RemoveFromWorkspaceDialog.getMessage(collection), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }

        static String getMessage(P4Collection collection) {
            IP4Resource[] folders = collection.members();
            if (folders.length == 1) {
                return MessageFormat.format(Messages.RemoveAction_RemoveSingleFolder, folders[0].getName());
            }
            return MessageFormat.format(Messages.RemoveAction_RemoveMultipleFolders, new Integer(folders.length));
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.noPromptButton = SWTUtils.createCheckBox(parent, Messages.RemoveAction_NotPromptAgain);
            this.noPromptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RemoveAction.setNeedConfirm(!RemoveFromWorkspaceDialog.this.noPromptButton.getSelection());
                }
            });
            return composite;
        }
    }
}

