/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.OpenAction;
import com.perforce.team.ui.p4java.actions.SyncAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.TeamException;

public class EditAction
extends OpenAction {
    public EditAction() {
        this.quietMode = false;
    }

    public EditAction(boolean quietMode) {
        this.quietMode = quietMode;
    }

    @Override
    protected boolean isEnabledEx() throws TeamException {
        P4Collection collection;
        IP4Resource[] resources;
        int size;
        boolean enabled = this.containsOnlineConnection();
        if (enabled && !(enabled = this.containsContainers()) && (size = (resources = (collection = super.getResourceSelection()).members()).length) > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File) {
                    IP4File file = (IP4File)resource;
                    if (this.isValidFile(file)) {
                        enabled = true;
                        break;
                    }
                } else {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }

    private void edit(final P4Collection collection, final int changelist, final String description, final boolean setActive) {
        final boolean[] doNotEdit = new boolean[]{true};
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                boolean unsyncedFiles = false;
                IP4Resource[] resources = collection.members();
                int size = resources.length;
                if (size > 0) {
                    IP4Resource[] iP4ResourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4File file;
                        IP4Resource resource = iP4ResourceArray[n2];
                        if (resource instanceof IP4File && !(file = (IP4File)resource).isSynced()) {
                            unsyncedFiles = true;
                        }
                        ++n2;
                    }
                    if (!unsyncedFiles) {
                        doNotEdit[0] = false;
                    }
                }
                if (unsyncedFiles) {
                    String[] dialogButtonLabels = new String[]{Messages.EditAction_GetLatest, Messages.EditAction_DontGetLatest, Messages.EditAction_Cancel};
                    int buttonId = 1;
                    if (!P4ConnectionManager.getManager().isSuppressErrors()) {
                        MessageDialog dlg = new MessageDialog(EditAction.this.getShell(), Messages.EditAction_CheckOut, null, Messages.EditAction_UnsyncedFiles, 4, dialogButtonLabels, 0);
                        if (!EditAction.this.isQuietMode()) {
                            buttonId = dlg.open();
                        }
                    }
                    if (buttonId == 0) {
                        doNotEdit[0] = false;
                        SyncAction action = new SyncAction();
                        action.setAsync(false);
                        action.setCollection(EditAction.this.getResourceSelection());
                        action.runAction();
                    } else if (buttonId == 1) {
                        doNotEdit[0] = false;
                    } else if (buttonId == 2) {
                        doNotEdit[0] = true;
                        return;
                    }
                }
            }
        });
        if (doNotEdit[0]) {
            return;
        }
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return EditAction.this.getJobTitle();
            }

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(this.getTitle(), 1);
                monitor.subTask(EditAction.this.generateTitle(null, collection));
                collection.edit(changelist, description, setActive);
                monitor.worked(1);
                monitor.done();
                collection.refreshLocalResources(2);
                EditAction.this.updateActionState();
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    protected void runModifyAction(int changelist, String description, P4Collection collection, boolean setActive) {
        this.edit(collection, changelist, description, setActive);
    }

    @Override
    public String getComboTitle() {
        return Messages.EditAction_OpenInChangelist;
    }

    @Override
    public String getDialogTitle() {
        return Messages.EditAction_CheckOut;
    }

    @Override
    protected boolean isValidFile(IP4File file) {
        return file.getP4JFile() != null && !file.isOpened();
    }

    @Override
    protected String getJobTitle() {
        return Messages.EditAction_CheckingOut;
    }

    @Override
    protected String getDefaultDescription() {
        return P4Collection.EDIT_DEFAULT_DESCRIPTION;
    }
}

