/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.labels;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Label;
import com.perforce.team.ui.dialogs.PerforceDialog;
import com.perforce.team.ui.labels.LabelsViewer;
import com.perforce.team.ui.labels.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SelectLabelDialog
extends PerforceDialog {
    private IP4Label selected = null;
    private IP4Connection connection;
    private LabelsViewer labelsViewer;

    public SelectLabelDialog(Shell parent, IP4Connection connection) {
        super(parent, Messages.SelectLabelDialog_SelectLabel);
        this.setModalResizeStyle();
        this.connection = connection;
    }

    public IP4Label getSelected() {
        return this.selected;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.labelsViewer = new LabelsViewer();
        this.labelsViewer.createControl(c, this.connection, false, false);
        this.labelsViewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectLabelDialog.this.updateSelection();
                SelectLabelDialog.this.close();
            }
        });
        return c;
    }

    private void updateSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.labelsViewer.getViewer().getSelection();
        if (selection.getFirstElement() instanceof IP4Label) {
            this.selected = (IP4Label)selection.getFirstElement();
        }
    }

    protected void okPressed() {
        this.updateSelection();
        super.okPressed();
    }
}

