/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.ui.dialogs.BufferedResourceNode;
import com.perforce.team.ui.editor.IP4CompareNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class P4ResourceNode
extends ResourceNode
implements IP4CompareNode {
    private boolean dirty = false;
    private IFile deleteFile;
    private String label = null;

    public P4ResourceNode(IFile resource, String label) {
        super((IResource)resource);
        this.label = label;
    }

    protected IStructureComparator createChild(IResource child) {
        return new BufferedResourceNode(child);
    }

    public void setContent(byte[] contents) {
        this.dirty = true;
        super.setContent(contents);
    }

    @Override
    public void commit(IProgressMonitor pm) throws CoreException {
        if (this.dirty) {
            if (this.deleteFile != null) {
                this.deleteFile.delete(true, true, pm);
                return;
            }
            IResource resource = this.getResource();
            if (resource instanceof IFile) {
                ByteArrayInputStream is = new ByteArrayInputStream(this.getContent());
                try {
                    IFile file = (IFile)resource;
                    if (file.exists()) {
                        file.setContents((InputStream)is, false, true, pm);
                    } else {
                        file.create((InputStream)is, false, pm);
                    }
                    this.dirty = false;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        IFile file;
        IFolder folder;
        IResource resource;
        if (child == null && (resource = this.getResource()) instanceof IFolder) {
            folder = (IFolder)resource;
            file = folder.getFile(other.getName());
            child = new BufferedResourceNode((IResource)file);
        }
        if (other == null && child != null) {
            resource = this.getResource();
            if (resource instanceof IFolder && (file = (folder = (IFolder)resource).getFile(child.getName())) != null && file.exists()) {
                this.deleteFile = file;
                this.dirty = true;
            }
            return null;
        }
        if (other instanceof IStreamContentAccessor && child instanceof IEditableContent) {
            IEditableContent dst = (IEditableContent)child;
            try {
                InputStream is = ((IStreamContentAccessor)other).getContents();
                byte[] bytes = P4ResourceNode.readBytes(is);
                if (bytes != null) {
                    dst.setContent(bytes);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return child;
    }

    private static byte[] readBytes(InputStream in) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                int c;
                while ((c = in.read()) != -1) {
                    bos.write(c);
                }
            }
            catch (IOException ex) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    bos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        return bos.toByteArray();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof P4ResourceNode)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        P4ResourceNode other = (P4ResourceNode)obj;
        return P4CoreUtils.equals((Object)this.label, (Object)other.getLabel()) && P4CoreUtils.equals((Object)this.getResource().getFullPath(), (Object)other.getResource().getFullPath());
    }

    public int hashCode() {
        return this.label == null ? super.hashCode() : super.hashCode() + this.label.hashCode() * 31 + this.getResource().getFullPath().hashCode();
    }
}

