/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import com.perforce.p4api.PerforceFileAccess;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.ILocalRevision;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.editor.IP4CompareNode;
import com.perforce.team.ui.editor.Messages;
import com.perforce.team.ui.editor.P4CompareEditorInput;
import com.perforce.team.ui.editor.P4FileNode;
import com.perforce.team.ui.editor.P4ResourceNode;
import com.perforce.team.ui.editor.P4StorageNode;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.progress.UIJob;

public final class CompareUtils {
    public static final String TITLE = Messages.CompareUtils_DiffTwoRevs;

    public static void doCompare(IP4File file, String depotPath1, String depotPath2, int revision1, int revision2) {
        try {
            String fileType = new Path(file.getRemotePath()).getFileExtension();
            String title = String.valueOf(TITLE) + PerforceFileAccess.getFilename((String)file.getRemotePath());
            IP4Connection connection = file.getConnection();
            IP4File p4File1 = connection.getFile((IFileSpec)new FileSpec(depotPath1));
            IP4File p4File2 = connection.getFile((IFileSpec)new FileSpec(depotPath2));
            if (p4File1 != null && p4File2 != null) {
                InputStream reader1 = p4File1.getRemoteContents(revision1);
                InputStream reader2 = p4File2.getRemoteContents(revision2);
                if (reader1 != null && reader2 != null) {
                    File file1 = P4CoreUtils.createFile((InputStream)reader1);
                    File file2 = P4CoreUtils.createFile((InputStream)reader2);
                    if (file1 != null && file2 != null) {
                        P4FileNode leftNode = new P4FileNode(file1, String.valueOf(file.getName()) + "#" + revision1, fileType, file.getName());
                        P4FileNode rightNode = new P4FileNode(file2, String.valueOf(file.getName()) + "#" + revision2, fileType, file.getName());
                        CompareUtils.openCompare(title, leftNode, rightNode);
                    }
                }
            }
        }
        catch (Exception e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
    }

    private static String getRevisionLabel(Object revision) {
        StringBuilder label = new StringBuilder();
        if (revision instanceof IP4Revision) {
            IP4Revision p4Revision = (IP4Revision)revision;
            label.append(MessageFormat.format(Messages.CompareUtils_RemoteRev, p4Revision.getName(), p4Revision.getRevision()));
            String folder = p4Revision.getRemotePath();
            int lastSlash = folder.lastIndexOf(47);
            if (lastSlash != -1) {
                folder = folder.substring(0, lastSlash);
                label.append(" - ");
                label.append(folder);
            }
        } else if (revision instanceof ILocalRevision) {
            ILocalRevision localRevision = (ILocalRevision)revision;
            label.append(MessageFormat.format(Messages.CompareUtils_LocalRev, localRevision.getName(), P4UIUtils.getDateText(localRevision.getTimestamp())));
        } else if (revision instanceof IFileRevision) {
            label.append(((IFileRevision)revision).getName());
        } else if (revision instanceof IFile) {
            label.append(MessageFormat.format(Messages.CompareUtils_WorkspaceFile, ((IFile)revision).getName()));
        } else if (revision instanceof File) {
            label.append(MessageFormat.format(Messages.CompareUtils_LocalFile, ((File)revision).getName()));
        }
        return label.toString();
    }

    private static IP4CompareNode createNode(IFileRevision revision, String label, String type, IProgressMonitor monitor) {
        IFile file;
        ILocalRevision local;
        IP4CompareNode node = null;
        if (revision instanceof IP4Revision) {
            try {
                InputStream stream = revision.getStorage(monitor).getContents();
                File file2 = P4CoreUtils.createFile((InputStream)stream);
                node = new P4FileNode(file2, label, type, revision.getName());
                ((P4FileNode)node).setContentIdentifier(revision.getContentIdentifier());
            }
            catch (CoreException stream) {}
        } else if (revision instanceof ILocalRevision && (local = (ILocalRevision)revision).isCurrent() && (file = local.getFile()) != null) {
            node = new P4ResourceNode(file, label);
        }
        if (node == null) {
            try {
                node = new P4StorageNode(revision.getStorage(monitor), label, type);
                node.setContentIdentifier(revision.getContentIdentifier());
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return node;
    }

    private static String getType(IP4File p4File, File file) {
        String name = null;
        if (p4File != null) {
            name = p4File.getName();
        }
        if (name == null && file != null) {
            name = file.getName();
        }
        String type = null;
        if (name != null) {
            type = new Path(name).getFileExtension();
        }
        return type;
    }

    public static void openLocalCompare(IFile file1, File file2, String file2Label, String title) {
        CompareUtils.openLocalCompare(file1, file2, null, file2Label, title);
    }

    public static void openLocalCompare(File file1, File file2, String file1Label, String file2Label, String title) {
        if (file1 != null && file2 != null) {
            String fileType = new Path(file1.getAbsolutePath()).getFileExtension();
            if (file1Label == null) {
                file1Label = CompareUtils.getRevisionLabel(file1);
            }
            P4FileNode leftNode = new P4FileNode(file1, file1Label, fileType, true, file1.getName());
            P4FileNode rightNode = new P4FileNode(file2, file2Label, fileType, file1.getName());
            CompareUtils.openCompare(title, leftNode, rightNode);
        }
    }

    public static void openLocalCompare(IFile file1, File file2, String file1Label, String file2Label, String title) {
        if (file1 != null && file2 != null) {
            String fileType = file1.getFileExtension();
            if (file1Label == null) {
                file1Label = CompareUtils.getRevisionLabel(file1);
            }
            P4ResourceNode leftNode = new P4ResourceNode(file1, file1Label);
            P4FileNode rightNode = new P4FileNode(file2, file2Label, fileType, file1.getName());
            CompareUtils.openCompare(title, leftNode, rightNode);
        }
    }

    public static void openLocalCompare(IFile file, File file2, String label) {
        if (file != null && file2 != null) {
            String title = String.valueOf(TITLE) + file.getName();
            CompareUtils.openLocalCompare(file, file2, label, title);
        }
    }

    public static void openLocalCompare(IP4File file, IFileRevision revision) {
        if (file != null) {
            IFile localFile = file.getLocalFileForLocation();
            if (localFile != null) {
                CompareUtils.openLocalCompare(localFile, revision);
            } else {
                File compareFile;
                String local = file.getLocalPath();
                if (local != null && (compareFile = new File(local)).exists()) {
                    CompareUtils.openLocalCompare(compareFile, revision);
                }
            }
        }
    }

    public static void openLocalCompare(IP4File p4File, File file, String label) {
        if (file != null && p4File != null) {
            String fileType = CompareUtils.getType(p4File, file);
            P4FileNode rightNode = new P4FileNode(file, label, fileType, p4File.getName());
            IFile localFile = p4File.getLocalFileForLocation();
            if (localFile != null) {
                CompareUtils.openLocalCompare(localFile, (IP4CompareNode)rightNode);
            } else {
                File compareFile;
                String local = p4File.getLocalPath();
                if (local != null && (compareFile = new File(local)).exists()) {
                    CompareUtils.openLocalCompare(compareFile, (IP4CompareNode)rightNode);
                }
            }
        }
    }

    public static void openLocalCompare(IP4File p4File, int revision, File file, String label) {
        if (file != null && p4File != null) {
            String fileType = CompareUtils.getType(p4File, file);
            String fileLabel = label == null ? CompareUtils.getRevisionLabel(file) : label;
            String name = p4File.getName();
            P4FileNode leftNode = new P4FileNode(file, fileLabel, fileType, true, name);
            InputStream reader1 = p4File.getRemoteContents(revision);
            File file1 = P4CoreUtils.createFile((InputStream)reader1);
            P4FileNode rightNode = new P4FileNode(file1, String.valueOf(name) + "#" + revision, fileType, name);
            String title = String.valueOf(TITLE) + name;
            CompareUtils.openCompare(title, leftNode, rightNode);
        }
    }

    public static void openLocalCompare(File file, IFileRevision revision) {
        if (file != null && revision != null) {
            String fileType = new Path(file.getAbsolutePath()).getFileExtension();
            String fileLabel = CompareUtils.getRevisionLabel(file);
            P4FileNode leftNode = new P4FileNode(file, fileLabel, fileType, true, file.getName());
            String rightLabel = CompareUtils.getRevisionLabel(revision);
            IP4CompareNode rightNode = CompareUtils.createNode(revision, rightLabel, fileType, (IProgressMonitor)new NullProgressMonitor());
            String title = String.valueOf(TITLE) + file.getName();
            CompareUtils.openCompare(title, leftNode, rightNode);
        }
    }

    public static void openLocalCompare(File file, IP4CompareNode rightNode) {
        if (file != null && rightNode != null) {
            String fileType = new Path(file.getAbsolutePath()).getFileExtension();
            String fileLabel = CompareUtils.getRevisionLabel(file);
            P4FileNode leftNode = new P4FileNode(file, fileLabel, fileType, true, file.getName());
            String title = String.valueOf(TITLE) + file.getName();
            CompareUtils.openCompare(title, leftNode, rightNode);
        }
    }

    public static void openLocalCompare(IFile file, IP4CompareNode rightNode) {
        if (file != null && rightNode != null) {
            P4ResourceNode leftNode = new P4ResourceNode(file, CompareUtils.getRevisionLabel(file));
            String title = String.valueOf(TITLE) + file.getName();
            CompareUtils.openCompare(title, leftNode, rightNode);
        }
    }

    public static void openLocalCompare(IFile file, IFileRevision revision) {
        if (file != null && revision != null) {
            String fileType = file.getFileExtension();
            P4ResourceNode leftNode = new P4ResourceNode(file, CompareUtils.getRevisionLabel(file));
            String rightLabel = CompareUtils.getRevisionLabel(revision);
            IP4CompareNode rightNode = CompareUtils.createNode(revision, rightLabel, fileType, (IProgressMonitor)new NullProgressMonitor());
            String title = String.valueOf(TITLE) + file.getName();
            CompareUtils.openCompare(title, leftNode, rightNode);
        }
    }

    public static void openCompare(final String title, final IP4CompareNode leftNode, final IP4CompareNode rightNode) {
        UIJob job = new UIJob(Messages.CompareUtils_OpeningCompareEditor){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                P4CompareEditorInput input = new P4CompareEditorInput(title, leftNode, rightNode);
                CompareUI.openCompareEditor((CompareEditorInput)input);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static void openCompare(IFileRevision left, IFileRevision right) {
        String fileType = new Path(left.getName()).getFileExtension();
        String leftLabel = CompareUtils.getRevisionLabel(left);
        String rightLabel = CompareUtils.getRevisionLabel(right);
        IP4CompareNode leftNode = CompareUtils.createNode(left, leftLabel, fileType, (IProgressMonitor)new NullProgressMonitor());
        IP4CompareNode rightNode = CompareUtils.createNode(right, rightLabel, fileType, (IProgressMonitor)new NullProgressMonitor());
        String title = String.valueOf(TITLE) + left.getName();
        CompareUtils.openCompare(title, leftNode, rightNode);
    }
}

