/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class BaseCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension6 {
    private String display;
    private String replacement;
    private int offset;
    private int length;
    private int cursorPosition;
    private Image image;

    public BaseCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null);
    }

    public BaseCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.replacement = replacementString;
        this.offset = replacementOffset;
        this.length = replacementLength;
        this.cursorPosition = cursorPosition;
        this.image = image;
        this.display = displayString;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.offset, this.length, this.replacement);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.display;
    }

    public Image getImage() {
        return this.image;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.offset + this.cursorPosition, 0);
    }

    public StyledString getStyledDisplayString() {
        return new StyledString(this.getDisplayString());
    }
}

