/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.diff;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.diff.DiffRegistry;
import com.perforce.team.ui.diff.IFileDiffer;
import com.perforce.team.ui.diff.Messages;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public abstract class DiffContentProvider
extends PerforceContentProvider {
    private Map<String, IFileDiffer> typeDiffers = new HashMap<String, IFileDiffer>();
    private Map<String, IFileDiffer> extDiffers = new HashMap<String, IFileDiffer>();
    private ISchedulingRule diffRule = P4Runner.createRule();

    public DiffContentProvider(StructuredViewer viewer) {
        super(viewer);
    }

    public DiffContentProvider(StructuredViewer viewer, boolean async) {
        super(viewer, async);
    }

    public DiffContentProvider(StructuredViewer viewer, Object context) {
        super(viewer, context);
    }

    public DiffContentProvider(StructuredViewer viewer, boolean async, Object context) {
        super(viewer, async, context);
    }

    public abstract boolean canDiff(IP4Resource var1);

    public abstract IStorage getLeftStorage(IP4Resource var1, IP4File var2);

    public abstract IStorage getRightStorage(IP4Resource var1, IP4File var2);

    protected void generateDiff(final IFileDiffer differ, final IP4Resource resource, final IP4File file) {
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.DiffContentProvider_GettingFileDifferences;
            }

            public void run(IProgressMonitor monitor) {
                IStorage storage1 = DiffContentProvider.this.getLeftStorage(resource, file);
                if (monitor.isCanceled()) {
                    return;
                }
                IStorage storage2 = DiffContentProvider.this.getRightStorage(resource, file);
                if (monitor.isCanceled()) {
                    return;
                }
                differ.generateDiff(resource, file, storage1, storage2);
                if (monitor.isCanceled()) {
                    return;
                }
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (P4UIUtils.okToUse((Viewer)DiffContentProvider.this.viewer)) {
                            DiffContentProvider.this.updateResource(resource);
                        }
                    }
                });
            }
        }, (ISchedulingRule)this.diffRule);
    }

    protected void updateResource(IP4Resource resource) {
        this.viewer.refresh((Object)resource);
        if (this.viewer instanceof TreeViewer) {
            ((TreeViewer)this.viewer).expandToLevel((Object)resource, -1);
        }
    }

    public IFileDiffer getDiffer(IP4Resource resource) {
        String name;
        IFileDiffer differ = null;
        if (resource != null && (name = resource.getName()) != null) {
            IContentType type = Platform.getContentTypeManager().findContentTypeFor(name);
            if (type != null) {
                if (this.typeDiffers.containsKey(type.getId())) {
                    differ = this.typeDiffers.get(type.getId());
                } else {
                    differ = DiffRegistry.getRegistry().getDiffer(type, true);
                    this.typeDiffers.put(type.getId(), differ);
                }
            } else {
                String ext = new Path(name).getFileExtension();
                if (ext != null && ext.length() > 0) {
                    if (this.extDiffers.containsKey(ext)) {
                        differ = this.extDiffers.get(ext);
                    } else {
                        differ = DiffRegistry.getRegistry().getDifferByExtension(ext);
                        this.extDiffers.put(ext, differ);
                    }
                }
            }
        }
        return differ;
    }

    protected Object[] getDiffs(IFileDiffer differ, IP4Resource resource) {
        return differ.getDiff(resource);
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        Tracing.printTrace((boolean)Policy.DEBUG, (String)"SUBMIT", (String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":getChildren() parentElement=" + parentElement));
        if (parentElement instanceof IP4Resource) {
            IFileDiffer differ;
            IP4File file;
            IP4Resource resource = (IP4Resource)parentElement;
            if (resource.isFile() && this.canDiff(resource) && (file = (IP4File)P4CoreUtils.convert((Object)resource, IP4File.class)) != null && (differ = this.getDiffer(resource)) != null) {
                if (differ.diffGenerated(resource)) {
                    return this.getDiffs(differ, resource);
                }
                this.generateDiff(differ, resource, file);
                return new Object[]{new PerforceContentProvider.Loading()};
            }
        } else if (parentElement instanceof IDiffContainer) {
            return ((IDiffContainer)parentElement).getChildren();
        }
        return super.getChildren(parentElement);
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof IDiffElement) {
            return ((IDiffElement)element).getParent();
        }
        return super.getParent(element);
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof IP4Resource) {
            IP4Resource resource = (IP4Resource)element;
            if (resource.isFile() && this.canDiff(resource)) {
                return this.getDiffer(resource) != null;
            }
        } else if (element instanceof IDiffContainer) {
            return ((IDiffContainer)element).hasChildren();
        }
        return super.hasChildren(element);
    }

    protected void clearDiffers() {
        for (IFileDiffer differ : this.typeDiffers.values()) {
            if (differ == null) continue;
            differ.dispose();
        }
        this.typeDiffers.clear();
        for (IFileDiffer differ : this.extDiffers.values()) {
            if (differ == null) continue;
            differ.dispose();
        }
        this.extDiffers.clear();
    }

    @Override
    public void dispose() {
        this.clearDiffers();
        super.dispose();
    }
}

