/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.dialogs.PerforceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SyncRevisionDialog
extends PerforceDialog {
    private Button latestRadio;
    private Button revisionRadio;
    private Button otherRadio;
    private Text revisionText;
    private Text otherText;
    private Button forceSyncButton;
    private Button previewSyncButton;
    private String revSpec;
    private boolean force = false;
    private boolean preview = false;
    private String initalText;
    private boolean isOther = false;

    public SyncRevisionDialog(Shell parent, String initial, boolean isOther) {
        super(parent, Messages.SyncRevisionDialog_SyncFilesToRevLabelChangeOrDate);
        this.initalText = initial;
        this.isOther = isOther;
    }

    public SyncRevisionDialog(Shell parent) {
        this(parent, null, false);
    }

    public String getRevSpec() {
        return this.revSpec;
    }

    public boolean forceSync() {
        return this.force;
    }

    public boolean preview() {
        return this.preview;
    }

    public boolean forceSelected() {
        return this.forceSyncButton.getSelection();
    }

    public void setForceSelected(boolean force) {
        this.forceSyncButton.setSelection(force);
    }

    private void select(boolean latest, boolean revision, boolean other) {
        this.latestRadio.setSelection(latest);
        this.revisionRadio.setSelection(revision);
        this.revisionText.setEnabled(revision);
        this.otherRadio.setSelection(other);
        this.otherRadio.setEnabled(other);
    }

    public void selectLatest() {
        this.select(true, false, false);
    }

    public boolean latestSelected() {
        return this.latestRadio.getSelection();
    }

    public void selectRevision() {
        this.select(false, true, false);
    }

    public boolean revisionSelected() {
        return this.revisionRadio.getSelection();
    }

    public void selectOther() {
        this.select(false, false, true);
    }

    public boolean otherSelected() {
        return this.otherRadio.getSelection();
    }

    public void setRevisionText(String revision) {
        if (revision != null) {
            this.revisionText.setText(revision);
        }
    }

    public void setOtherText(String other) {
        if (other != null) {
            this.otherText.setText(other);
        }
    }

    public String getCurrentRevisionSpec() {
        String spec = null;
        if (this.revisionRadio.getSelection() && this.revisionText.getText().length() > 0) {
            spec = this.revisionText.getText();
            if (!spec.startsWith("#")) {
                spec = "#" + spec;
            }
        } else if (this.otherRadio.getSelection() && this.otherText.getText().length() > 0) {
            spec = this.otherText.getText();
            if (!spec.startsWith("@")) {
                spec = "@" + spec;
            }
        } else {
            spec = "";
        }
        return spec;
    }

    protected void okPressed() {
        this.revSpec = this.getCurrentRevisionSpec();
        this.force = this.forceSelected();
        this.preview = this.previewSyncButton.getSelection();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = this.createComposite(dialogArea, 2, 1808);
        GridData twoData = new GridData(4, 4, true, false);
        twoData.horizontalSpan = 2;
        this.latestRadio = this.createRadio(composite, Messages.SyncRevisionDialog_GetLatestRevision);
        this.latestRadio.setLayoutData((Object)twoData);
        this.revisionRadio = this.createRadio(composite, Messages.SyncRevisionDialog_RevisionNumber);
        this.revisionText = this.createTextField(composite, 30, false);
        this.otherRadio = this.createRadio(composite, Messages.SyncRevisionDialog_Other);
        this.otherText = this.createTextField(composite);
        this.createBlank(composite);
        this.createLabel(composite, Messages.SyncRevisionDialog_LabelChangeOrDate);
        SelectionAdapter radioAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SyncRevisionDialog.this.otherRadio.getSelection()) {
                    SyncRevisionDialog.this.otherText.setEnabled(true);
                    SyncRevisionDialog.this.otherText.setFocus();
                } else {
                    SyncRevisionDialog.this.otherText.setEnabled(false);
                }
                if (SyncRevisionDialog.this.revisionRadio.getSelection()) {
                    SyncRevisionDialog.this.revisionText.setEnabled(true);
                    SyncRevisionDialog.this.revisionText.setFocus();
                } else {
                    SyncRevisionDialog.this.revisionText.setEnabled(false);
                }
            }
        };
        this.revisionRadio.addSelectionListener((SelectionListener)radioAdapter);
        this.otherRadio.addSelectionListener((SelectionListener)radioAdapter);
        if (this.initalText != null) {
            if (this.isOther) {
                this.otherRadio.setSelection(true);
                this.otherText.setText(this.initalText);
            } else {
                this.revisionRadio.setSelection(true);
                this.revisionText.setText(this.initalText);
            }
        } else {
            this.revisionRadio.setSelection(true);
        }
        radioAdapter.widgetSelected(null);
        this.forceSyncButton = new Button(composite, 32);
        this.forceSyncButton.setText(Messages.SyncRevisionDialog_ForceOperation);
        this.forceSyncButton.setLayoutData((Object)twoData);
        this.previewSyncButton = new Button(composite, 32);
        this.previewSyncButton.setText(Messages.SyncRevisionDialog_PreviewSync);
        this.previewSyncButton.setLayoutData((Object)twoData);
        return dialogArea;
    }
}

