/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.ui.PerforceUIPlugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class PerforcePreferencesDialog
extends PreferencePage
implements IWorkbenchPreferencePage {
    private int numColumns;
    private FieldEditor[] fieldEditors;
    private IPreferenceStore store;

    public PerforcePreferencesDialog(int numColumns) {
        this.numColumns = numColumns;
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.fieldEditors.length) {
            this.fieldEditors[i].store();
            ++i;
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    protected void setFieldEditors(FieldEditor[] fieldEditors) {
        this.fieldEditors = fieldEditors;
    }

    protected void initializeValues() {
        int i = 0;
        while (i < this.fieldEditors.length) {
            this.fieldEditors[i].load();
            ++i;
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        int i = 0;
        while (i < this.fieldEditors.length) {
            this.fieldEditors[i].loadDefault();
            ++i;
        }
    }

    protected PerforceColorFieldEditor createColorFieldEditor(String preferenceName, String label, Composite parent) {
        PerforceColorFieldEditor editor = new PerforceColorFieldEditor(preferenceName, label, parent);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPrefStore());
        return editor;
    }

    protected PerforceBooleanFieldEditor createBooleanFieldEditor(String preferenceName, String label, Composite parent) {
        PerforceBooleanFieldEditor editor = new PerforceBooleanFieldEditor(preferenceName, label, parent);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPrefStore());
        return editor;
    }

    protected PerforceStringFieldEditor createStringFieldEditor(String preferenceName, String label, Composite parent) {
        PerforceStringFieldEditor editor = new PerforceStringFieldEditor(preferenceName, label, parent);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPrefStore());
        return editor;
    }

    protected PerforceFontFieldEditor createFontFieldEditor(String preferenceName, String label, Composite parent) {
        PerforceFontFieldEditor editor = new PerforceFontFieldEditor(preferenceName, label, parent);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPrefStore());
        return editor;
    }

    protected PerforceRadioGroupFieldEditor createRadioGroupFieldEditor(String preferenceName, String label, int numColumns, String[][] labelAndValues, Composite parent, boolean useGroup) {
        PerforceRadioGroupFieldEditor editor = new PerforceRadioGroupFieldEditor(preferenceName, label, numColumns, labelAndValues, parent, useGroup);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPrefStore());
        return editor;
    }

    private IPreferenceStore getPrefStore() {
        if (this.store == null) {
            this.store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PerforceUIPlugin.getPlugin().getBundle().getSymbolicName());
        }
        return this.store;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return this.getPrefStore();
    }

    protected void setPrefInt(String key, int value) {
        this.getPrefStore().setValue(key, value);
    }

    protected int getPrefInt(String key) {
        return this.getPrefStore().getInt(key);
    }

    protected int getPrefDefInt(String key) {
        return this.getPrefStore().getDefaultInt(key);
    }

    protected void setPrefBoolean(String key, boolean value) {
        this.getPrefStore().setValue(key, value);
    }

    protected boolean getPrefBoolean(String key) {
        return this.getPrefStore().getBoolean(key);
    }

    protected boolean getPrefDefBoolean(String key) {
        return this.getPrefStore().getDefaultBoolean(key);
    }

    protected void setPrefString(String key, String value) {
        this.getPrefStore().setValue(key, value);
    }

    protected String getPrefString(String key) {
        return this.getPrefStore().getString(key);
    }

    protected String getPrefDefString(String key) {
        return this.getPrefStore().getDefaultString(key);
    }

    protected class PerforceBooleanFieldEditor
    extends BooleanFieldEditor {
        private Composite parent;

        public PerforceBooleanFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.adjustForNumColumns(PerforcePreferencesDialog.this.numColumns);
            this.parent = parent;
        }

        public Control getHelpControl() {
            return this.getChangeControl(this.parent);
        }
    }

    protected class PerforceColorFieldEditor
    extends ColorFieldEditor {
        private Composite parent;

        public PerforceColorFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.adjustForNumColumns(PerforcePreferencesDialog.this.numColumns);
            this.parent = parent;
        }

        public Control getHelpControl() {
            return this.getChangeControl(this.parent);
        }
    }

    protected class PerforceFontFieldEditor
    extends FontFieldEditor {
        private Composite parent;

        public PerforceFontFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.adjustForNumColumns(PerforcePreferencesDialog.this.numColumns);
            this.parent = parent;
        }

        public Control getHelpControl() {
            return this.getChangeControl(this.parent);
        }
    }

    protected class PerforceRadioGroupFieldEditor
    extends RadioGroupFieldEditor {
        private Composite parent;

        public PerforceRadioGroupFieldEditor(String name, String labelText, int numColumns, String[][] labelAndValues, Composite parent, boolean useGroup) {
            super(name, labelText, numColumns, labelAndValues, parent, useGroup);
            this.adjustForNumColumns(PerforcePreferencesDialog.this.numColumns);
            this.parent = parent;
        }

        public Control getHelpControl() {
            return this.getRadioBoxControl(this.parent);
        }
    }

    protected class PerforceStringFieldEditor
    extends StringFieldEditor {
        private Composite parent;

        public PerforceStringFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.adjustForNumColumns(PerforcePreferencesDialog.this.numColumns);
            this.parent = parent;
        }

        public Control getHelpControl() {
            return this.getTextControl(this.parent);
        }
    }
}

