/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.dialogs.Messages;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ClientPreferencesDialog
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.perforce.team.ui.dialogs.ClientPreferencesDialog";

    public ClientPreferencesDialog() {
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        this.setPreferenceStore(store);
        if (StringUtils.isEmpty((CharSequence)store.getString("pref_client_switch_option"))) {
            store.setDefault("pref_client_switch_option", "never");
        }
        if (StringUtils.isEmpty((CharSequence)store.getString("pref_client_root_parent_default"))) {
            store.setDefault("pref_client_root_parent_default", System.getProperty("user.home"));
        }
    }

    public String getTitle() {
        return Messages.ClientPreferencesDialog_Title;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.perforce.team.ui.pref_client_switch_radio");
    }

    protected void createFieldEditors() {
        int SPAN = 3;
        Composite composite = this.getFieldEditorParent();
        composite.setLayoutData((Object)new GridData(1808));
        Label switchLabel = new Label(composite, 64);
        switchLabel.setText(Messages.ClientPreferencesDialog_SyncChoices);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        switchLabel.setLayoutData((Object)gd);
        RadioGroupFieldEditor switchOption = new RadioGroupFieldEditor("pref_client_switch_option", "", 1, (String[][])new String[][]{{Messages.ClientPreferencesDialog_Always, "always"}, {Messages.ClientPreferencesDialog_Never, "never"}, {Messages.ClientPreferencesDialog_Prompt, "prompt"}}, composite, true);
        this.addField((FieldEditor)switchOption);
        Label defLabel = new Label(composite, 64);
        defLabel.setText(Messages.ClientPreferencesDialog_NewConnectDef);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        defLabel.setLayoutData((Object)gd);
        Group clientComp = DialogUtils.createGroup(composite, "", 3);
        clientComp.setLayoutData((Object)new GridData(768));
        DirectoryFieldEditor clientLocation = new DirectoryFieldEditor("pref_client_root_parent_default", Messages.ClientPreferencesDialog_Location, (Composite)clientComp){

            protected void createControl(Composite parent) {
                this.setValidateStrategy(0);
                super.createControl(parent);
            }
        };
        this.addField((FieldEditor)clientLocation);
        clientComp.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    public void init(IWorkbench workbench) {
    }
}

