/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class BufferedResourceNode
extends ResourceNode {
    private boolean fDirty = false;
    private IFile fDeleteFile;

    public BufferedResourceNode(IResource resource) {
        super(resource);
    }

    protected IStructureComparator createChild(IResource child) {
        return new BufferedResourceNode(child);
    }

    public void setContent(byte[] contents) {
        this.fDirty = true;
        super.setContent(contents);
    }

    public void commit(IProgressMonitor pm) throws CoreException {
        if (this.fDirty) {
            if (this.fDeleteFile != null) {
                this.fDeleteFile.delete(true, true, pm);
                return;
            }
            IResource resource = this.getResource();
            if (resource instanceof IFile) {
                ByteArrayInputStream is = new ByteArrayInputStream(this.getContent());
                try {
                    IFile file = (IFile)resource;
                    if (file.exists()) {
                        file.setContents((InputStream)is, false, true, pm);
                    } else {
                        file.create((InputStream)is, false, pm);
                    }
                    this.fDirty = false;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        IFile file;
        IFolder folder;
        IResource resource;
        if (child == null && (resource = this.getResource()) instanceof IFolder) {
            folder = (IFolder)resource;
            file = folder.getFile(other.getName());
            child = new BufferedResourceNode((IResource)file);
        }
        if (other == null && child != null) {
            resource = this.getResource();
            if (resource instanceof IFolder && (file = (folder = (IFolder)resource).getFile(child.getName())) != null && file.exists()) {
                this.fDeleteFile = file;
                this.fDirty = true;
            }
            return null;
        }
        if (other instanceof IStreamContentAccessor && child instanceof IEditableContent) {
            IEditableContent dst = (IEditableContent)child;
            try {
                InputStream is = ((IStreamContentAccessor)other).getContents();
                byte[] bytes = BufferedResourceNode.readBytes(is);
                if (bytes != null) {
                    dst.setContent(bytes);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return child;
    }

    public static byte[] readBytes(InputStream in) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                int c;
                while ((c = in.read()) != -1) {
                    bos.write(c);
                }
            }
            catch (IOException ex) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    bos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        return bos.toByteArray();
    }

    public boolean equals(Object obj) {
        return obj instanceof BufferedResourceNode && super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

