/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.decorator;

import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.IProjectSettingsChangeListener;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.PerforceTeamProvider;
import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.IP4SubmittedFile;
import com.perforce.team.core.p4java.P4Depot;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.synchronize.IP4ChangeSet;
import com.perforce.team.ui.IgnoredFiles;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.decorator.IconCache;
import com.perforce.team.ui.decorator.P4Decoration;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.ui.IDecoratorManager;

public class PerforceDecorator
extends LabelProvider
implements ILabelDecorator,
IProjectSettingsChangeListener,
IPropertyChangeListener,
IP4Listener {
    public static final String ID = "com.perforce.team.ui.decorator.PerforceDecorator";
    protected boolean decorateIgnored;
    protected String fileDecoration = "";
    protected String connectionDecoration = "";
    protected String projectDecoration = "";
    protected String outgoingChangeFlag = "";
    protected String ignoredText = "";
    protected String unaddedChangeFlag = "";
    protected boolean showChangelists = false;
    protected IconCache iconCache = new IconCache();
    private boolean resourceDecorator;
    private boolean suspendDecoration = false;

    public static String removeTrailingWhitespace(StringBuilder str) {
        int i = str.length() - 1;
        while (i > -1 && Character.isWhitespace(str.charAt(i))) {
            --i;
        }
        if (i == -1) {
            return null;
        }
        return str.substring(0, i + 1);
    }

    public static void suspendDecoration() {
        PerforceDecorator decorator = PerforceDecorator.getActivePerforceDecorator();
        if (decorator != null) {
            decorator.suspendDecoration = true;
        }
    }

    public static void unsuspendDecoration() {
        PerforceDecorator decorator = PerforceDecorator.getActivePerforceDecorator();
        if (decorator != null) {
            decorator.suspendDecoration = false;
        }
    }

    private String decorateText(IP4File file, String text, boolean ignored) {
        return this.decorateText(file, text, false, false, ignored);
    }

    private String getIncomingAction(IP4File file) {
        String headAction = null;
        FileAction action = file.getHeadAction();
        if (action != null) {
            headAction = action.toString().toLowerCase();
        }
        return headAction;
    }

    private String decorateText(IP4File file, String text, boolean showChangelist, boolean showIncoming, boolean ignored) {
        FileAction action;
        String actionText;
        HashMap<String, String> bindings = new HashMap<String, String>();
        if (file.getHeadRevision() > 0) {
            bindings.put("have", Integer.toString(file.getHaveRevision()));
            bindings.put("head", Integer.toString(file.getHeadRevision()));
            bindings.put("head_change", Integer.toString(file.getHeadChange()));
        } else if (!ignored && !file.isOpened()) {
            bindings.put("not_under_version_control", this.unaddedChangeFlag);
        }
        String type = file.getOpenedType();
        if (type == null) {
            type = file.getHeadType();
        }
        if (type != null) {
            bindings.put("type", type);
        }
        if (file.isOpened() && file.openedByOwner()) {
            bindings.put("outgoing_change_flag", this.outgoingChangeFlag);
        }
        String string = actionText = (action = file.getAction()) != null ? action.toString().toLowerCase() : null;
        if (action == null) {
            if (showIncoming) {
                actionText = this.getIncomingAction(file);
            } else if (P4File.isActionDelete((FileAction)file.getHeadAction())) {
                actionText = file.getHaveRevision() == 0 ? "-deleted-" : "-head rev deleted-";
            }
        }
        if (actionText != null) {
            bindings.put("action", actionText);
        }
        bindings.put("name", text);
        StringBuilder decorated = P4Decoration.decorate(this.fileDecoration, bindings);
        if (showChangelist) {
            int id = file.getChangelistId();
            if (id == 0) {
                decorated.append(" <Changelist: Default>");
            } else if (id > 0) {
                this.addChangelist(decorated, id);
            } else {
                id = file.getHeadChange();
                if (id > 0) {
                    this.addChangelist(decorated, id);
                }
            }
        }
        return PerforceDecorator.removeTrailingWhitespace(decorated);
    }

    private void addChangelist(StringBuilder buffer, int id) {
        buffer.append(" <Changelist: #");
        buffer.append(id);
        buffer.append('>');
    }

    protected String decorateProjectWithConnection(String name, IP4Connection connection) {
        String decorated = name;
        if (connection != null) {
            ConnectionParameters params = connection.getParameters();
            HashMap<String, String> bindings = new HashMap<String, String>();
            bindings.put("server", params.getPort());
            bindings.put("client", params.getClient());
            bindings.put("user", params.getUser());
            bindings.put("charset", params.getCharsetNoNone());
            bindings.put("name", name);
            this.updateSandBoxAndStreamDecoration(bindings, connection);
            decorated = P4Decoration.decorate(this.projectDecoration, bindings).toString();
        }
        return decorated;
    }

    private void updateSandBoxAndStreamDecoration(Map<String, String> bindings, IP4Connection connection) {
        IP4Stream stream;
        String streamStr;
        if (connection.isOffline()) {
            bindings.put("offline", "*Offline*");
        }
        if (connection.isSandbox()) {
            bindings.put("sandbox", "*Sandbox*");
        }
        if (!connection.isOffline() && connection.getClient() != null && connection.getClient().getStream() != null && !StringUtils.isEmpty((CharSequence)(streamStr = connection.getClient().getStream()).trim()) && (stream = connection.getStream(streamStr.trim())) != null && stream.getStreamSummary() != null) {
            IStreamSummary sum = stream.getStreamSummary();
            bindings.put("stream_name", sum.getName());
            bindings.put("stream_root", sum.getStream());
        }
    }

    protected String decorateIgnoredResource(String text) {
        return String.valueOf(text) + " " + this.ignoredText;
    }

    public PerforceDecorator() {
        this.resourceDecorator = true;
        this.init();
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof ILabelProviderListener) {
                final ILabelProviderListener l = (ILabelProviderListener)listeners[i];
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.labelProviderChanged(event);
                    }
                });
            }
            ++i;
        }
    }

    public PerforceDecorator(boolean resourceDecorator) {
        this.resourceDecorator = resourceDecorator;
        this.init();
    }

    public static PerforceDecorator getActivePerforceDecorator() {
        IDecoratorManager manager = PerforceUIPlugin.getPlugin().getWorkbench().getDecoratorManager();
        if (manager.getEnabled(ID)) {
            return (PerforceDecorator)manager.getLabelDecorator(ID);
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.iconCache.clear();
        if (this.resourceDecorator) {
            PerforceProviderPlugin.removeProjectSettingsChangeListener((IProjectSettingsChangeListener)this);
        }
        P4ConnectionManager.getManager().removeListener(this);
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        store.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void projectSettingsChanged(IProject project, ConnectionParameters params) {
        this.resourceStateChanged(new IResource[]{project});
    }

    private boolean isValidPref(String property) {
        return "pref_file_format".equals(property) || "pref_project_format".equals(property) || "pref_ignored_text".equals(property) || "pref_file_open_icon".equals(property) || "pref_file_sync_icon".equals(property) || "pref_file_sync2_icon".equals(property) || "pref_file_unresolved_icon".equals(property) || "pref_file_lock_icon".equals(property) || "pref_mark_unmanaged".equals(property) || "pref_file_other_icon".equals(property) || "com.perforce.team.ui.preferences.IGNORED_DECORATION".equals(property) || "pref_ignored_icon".equals(property) || "com.perforce.team.ui.preferences.SHOW_CHANGELIST_IN_SYNC_VIEW".equals(property) || "com.perforce.team.ui.preferences.CONNECTION_DECORATION_TEXT".equals(property) || "com.perforce.team.ui.preferences.PROJECT_DECORATION_TEXT".equals(property) || "com.perforce.team.ui.preferences.FILE_DECORATION_TEXT".equals(property) || "com.perforce.team.ui.preferences.OUTGOING_CHANGE_DECORATION".equals(property) || "pref_local_only_icon".equals(property) || "pref_stream_sandbox_icon".equals(property) || "pref_stream_sandbox_project_icon".equals(property);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.isValidPref(event.getProperty())) {
            this.iconCache.clear();
            this.getPreferences();
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public void resourceStateChanged(final IResource[] resources) {
        boolean gotFolder = false;
        int i = 0;
        while (i < resources.length) {
            int type = resources[i].getType();
            if (type == 4 || type == 2) {
                gotFolder = true;
            }
            ++i;
        }
        final boolean gotFolder2 = gotFolder;
        PerforceUIPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (gotFolder2) {
                    PerforceDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)PerforceDecorator.this));
                } else {
                    PerforceDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)PerforceDecorator.this, (Object[])resources));
                }
            }
        });
    }

    public Image decorateImage(Image image, Object o) {
        IP4File file;
        boolean managedFile;
        if (this.suspendDecoration || image == null) {
            return null;
        }
        IResource resource = PerforceProviderPlugin.getResource((Object)o);
        boolean bl = managedFile = resource != null;
        if (resource instanceof IProject) {
            image = this.iconCache.getProjectImage(image, (IProject)resource);
        } else if (o instanceof IP4File) {
            IP4File p4Resource = (IP4File)o;
            image = this.iconCache.getImage(image, p4Resource, managedFile, false);
        } else if (o instanceof IFile) {
            IP4Resource p4Resource = P4ConnectionManager.getManager().asyncGetResource((IResource)((IFile)o));
            if (p4Resource instanceof IP4File) {
                boolean ignored = this.iconCache.ignoredLocation > 0 && IgnoredFiles.isIgnored((IResource)((IFile)o));
                image = this.iconCache.getImage(image, (IP4File)p4Resource, managedFile, ignored);
            }
        } else if (o instanceof IP4PendingChangelist) {
            image = this.iconCache.getImage(image, (IP4PendingChangelist)o);
        } else if (o instanceof IP4SubmittedChangelist) {
            image = this.iconCache.getImage(image, (IP4SubmittedChangelist)o);
        } else if (o instanceof IP4ShelveFile) {
            image = this.iconCache.getImage((IP4ShelveFile)o);
        } else if (o instanceof IP4SubmittedFile) {
            image = this.iconCache.getImage(image, (IP4SubmittedFile)o);
        } else if (o instanceof IP4Connection) {
            image = this.iconCache.getImage(image, (IP4Connection)o);
        } else if (o instanceof IAdaptable && (file = (IP4File)P4CoreUtils.convert((Object)o, IP4File.class)) != null) {
            image = this.iconCache.getImage(image, file, managedFile, false);
        }
        return image;
    }

    public String decorateProject(String text, IProject project) {
        String decorated = null;
        PerforceTeamProvider provider = PerforceProviderPlugin.getPerforceProviderFor((IResource)project);
        if (provider != null) {
            decorated = this.getProjectText(text, project);
        }
        return decorated;
    }

    public String decorateSyncElement(String text, ISynchronizeModelElement element) {
        IResource resource = element.getResource();
        if (resource instanceof IFile) {
            IP4Resource p4Resource = P4ConnectionManager.getManager().asyncGetResource(resource);
            if (p4Resource instanceof IP4File) {
                return this.getFileText(text, (IP4File)p4Resource, this.showChangelists, true);
            }
        } else {
            IP4Changelist change;
            IP4ChangeSet set;
            if (resource instanceof IProject) {
                return this.decorateProject(text, (IProject)resource);
            }
            if (element instanceof IAdaptable && (set = (IP4ChangeSet)P4CoreUtils.convert((Object)element, IP4ChangeSet.class)) != null && (change = set.getChangelist()) != null) {
                String description;
                StringBuilder changeDescription = new StringBuilder(set.getName());
                String user = change.getUserName();
                String client = change.getClientName();
                if (user != null && client != null) {
                    changeDescription.append(" " + user + "@" + client);
                }
                if (!change.isDefault() && (description = change.getShortDescription()).length() > 0) {
                    changeDescription.append(" { " + description + " }");
                }
                return changeDescription.toString();
            }
        }
        return null;
    }

    public String decorateResource(String text, IResource resource) {
        IP4Resource p4Resource;
        boolean ignored;
        String decorated = null;
        boolean bl = ignored = this.decorateIgnored && PerforceTeamProvider.getPerforceProvider((IResource)resource) != null && IgnoredFiles.isIgnored(resource);
        if (resource instanceof IFile && (p4Resource = P4ConnectionManager.getManager().asyncGetResource(resource)) instanceof IP4File) {
            decorated = this.getFileText(text, (IP4File)p4Resource, ignored);
        }
        if (ignored) {
            decorated = this.decorateIgnoredResource(text);
        }
        return decorated;
    }

    private String decorateConnection(String text, IP4Connection connection) {
        HashMap<String, String> bindings = new HashMap<String, String>();
        this.updateSandBoxAndStreamDecoration(bindings, connection);
        if (bindings.isEmpty()) {
            return text;
        }
        bindings.put("name", text);
        String decorated = P4Decoration.decorate(this.connectionDecoration, bindings).toString();
        return decorated;
    }

    public String decorateShelvedFile(String text, IP4ShelveFile shelvedFile) {
        FileAction action;
        String actionText;
        String type;
        IP4File file = shelvedFile.getFile();
        HashMap<String, String> bindings = new HashMap<String, String>();
        int have = file.getHaveRevision();
        if (have > 0) {
            bindings.put("have", Integer.toString(have));
        }
        if ((type = file.getOpenedType()) == null) {
            type = file.getHeadType();
        }
        if (type != null) {
            bindings.put("type", type);
        }
        String string = actionText = (action = file.getAction()) != null ? action.toString().toLowerCase() : null;
        if (action == null && P4File.isActionDelete((FileAction)file.getHeadAction())) {
            actionText = file.getHaveRevision() == 0 ? "-deleted-" : "-head rev deleted-";
        }
        if (actionText != null) {
            bindings.put("action", actionText);
        }
        bindings.put("name", text);
        StringBuilder decorated = P4Decoration.decorate(this.fileDecoration, bindings);
        return PerforceDecorator.removeTrailingWhitespace(decorated);
    }

    public String decorateSubmittedFile(String text, IP4SubmittedFile submittedFile) {
        FileAction action;
        String actionText;
        IP4File file = submittedFile.getFile();
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("have", Integer.toString(submittedFile.getRevision()));
        String type = file.getOpenedType();
        if (type == null) {
            type = file.getHeadType();
        }
        if (type != null) {
            bindings.put("type", type);
        }
        String string = actionText = (action = file.getAction()) != null ? action.toString().toLowerCase() : null;
        if (action == null && P4File.isActionDelete((FileAction)file.getHeadAction())) {
            actionText = file.getHaveRevision() == 0 ? "-deleted-" : "-head rev deleted-";
        }
        if (actionText != null) {
            bindings.put("action", actionText);
        }
        bindings.put("name", text);
        StringBuilder decorated = P4Decoration.decorate(this.fileDecoration, bindings);
        return PerforceDecorator.removeTrailingWhitespace(decorated);
    }

    public String decorateFolder(String text, IP4Folder folder) {
        String streamName = this.streamNameForStreamRoot(folder);
        if (streamName.isEmpty()) {
            return text;
        }
        return MessageFormat.format("{0} ({1})", text, streamName);
    }

    private String streamNameForStreamRoot(IP4Folder folder) {
        if (!(folder.getParent() instanceof P4Depot)) {
            return "";
        }
        P4Depot depot = (P4Depot)folder.getParent();
        if (depot.getType() != IDepot.DepotType.STREAM) {
            return "";
        }
        for (IStreamSummary stream : depot.getStreams()) {
            if (!stream.getStream().equals(folder.getRemotePath())) continue;
            return stream.getName();
        }
        return "";
    }

    public String decorateText(String text, Object o) {
        if (text != null && !this.suspendDecoration) {
            String decorated = null;
            if (o instanceof IP4File) {
                decorated = this.getFileText(text, (IP4File)o);
            } else if (o instanceof IP4Connection) {
                decorated = this.decorateConnection(text, (IP4Connection)o);
            } else if (o instanceof IP4Folder) {
                decorated = this.decorateFolder(text, (IP4Folder)o);
            } else {
                IP4File file;
                if (o instanceof IProject) {
                    return this.decorateProject(text, (IProject)o);
                }
                if (o instanceof IResource) {
                    decorated = this.decorateResource(text, (IResource)o);
                } else if (o instanceof ISynchronizeModelElement) {
                    decorated = this.decorateSyncElement(text, (ISynchronizeModelElement)o);
                } else if (o instanceof IP4ShelveFile) {
                    decorated = this.decorateShelvedFile(text, (IP4ShelveFile)o);
                } else if (o instanceof IP4SubmittedFile) {
                    decorated = this.decorateSubmittedFile(text, (IP4SubmittedFile)o);
                } else if (o instanceof IAdaptable && (file = (IP4File)P4CoreUtils.convert((Object)o, IP4File.class)) != null) {
                    decorated = this.getFileText(text, file);
                }
            }
            if (decorated != null) {
                return decorated;
            }
        }
        return null;
    }

    protected String getProjectText(String text, IProject project) {
        IP4Connection connection = P4ConnectionManager.getManager().getConnection(project, false);
        if (connection != null) {
            text = this.decorateProjectWithConnection(text, connection);
        }
        return text;
    }

    public String getFileText(String text, IP4File file) {
        return this.getFileText(text, file, false);
    }

    public String getFileText(String text, IP4File file, boolean ignored) {
        return this.decorateText(file, text, ignored);
    }

    public String getFileText(String text, IP4File file, boolean showChangelist, boolean showIncoming) {
        return this.decorateText(file, text, showChangelist, showIncoming, false);
    }

    private void postLabelEvent(final LabelProviderChangedEvent event) {
        PerforceUIPlugin.asyncExec(new Runnable(){

            @Override
            public void run() {
                PerforceDecorator.this.fireLabelProviderChanged(event);
            }
        });
    }

    protected void append(StringBuffer buffer, String text, String sep) {
        if (buffer.length() > 0) {
            buffer.append(sep);
        }
        buffer.append(text);
    }

    private void init() {
        this.getPreferences();
        if (this.resourceDecorator) {
            PerforceProviderPlugin.addProjectSettingsChangeListener((IProjectSettingsChangeListener)this);
        }
        P4ConnectionManager.getManager().addListener(this);
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void getPreferences() {
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        this.decorateIgnored = store.getBoolean("pref_ignored_text");
        this.connectionDecoration = store.getString("com.perforce.team.ui.preferences.CONNECTION_DECORATION_TEXT");
        this.projectDecoration = store.getString("com.perforce.team.ui.preferences.PROJECT_DECORATION_TEXT");
        this.fileDecoration = store.getString("com.perforce.team.ui.preferences.FILE_DECORATION_TEXT");
        this.outgoingChangeFlag = store.getString("com.perforce.team.ui.preferences.OUTGOING_CHANGE_DECORATION");
        this.unaddedChangeFlag = store.getString("com.perforce.team.ui.preferences.UNADDED_CHANGE_DECORATION");
        this.ignoredText = store.getString("com.perforce.team.ui.preferences.IGNORED_DECORATION");
        this.showChangelists = store.getBoolean("com.perforce.team.ui.preferences.SHOW_CHANGELIST_IN_SYNC_VIEW");
    }

    public void resoureChanged(final P4Event event) {
        Tracing.printExecTime((boolean)Policy.DEBUG, (String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":resourceChanged()"), (String)event.toString(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (PerforceDecorator.this.resourceDecorator) {
                    PerforceDecorator.this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)PerforceDecorator.this, (Object[])event.getLocalResources()));
                } else {
                    PerforceDecorator.this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)PerforceDecorator.this, (Object[])event.getResources()));
                }
            }
        });
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

