/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.decorator;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.IProjectSettingsChangeListener;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.actions.stub.Utils;
import com.perforce.team.ui.decorator.IconCache;
import com.perforce.team.ui.decorator.LabelEventJob;
import com.perforce.team.ui.decorator.PerforceDecorator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IContributorResourceAdapter;

public class LightweightPerforceDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
IP4Listener,
IProjectSettingsChangeListener,
IPropertyChangeListener {
    PerforceDecorator delegate = new PerforceDecorator(false){

        @Override
        public String getName() {
            return String.valueOf(LightweightPerforceDecorator.class.getSimpleName()) + ":" + super.getName();
        }
    };
    public static final String DECORATOR_ID = "com.perforce.team.ui.decorator.LightweightPerforceDecorator";
    protected boolean decorateIgnored;
    protected String fileDecoration = "";
    protected String projectDecoration = "";
    protected String outgoingChangeFlag = "";
    protected String ignoredText = "";
    protected String unaddedChangeFlag = "";
    protected boolean showChangelists = false;
    protected IconCache iconCache = new IconCache();
    private boolean resourceDecorator;

    public static String removeTrailingWhitespace(StringBuilder str) {
        int i = str.length() - 1;
        while (i > -1 && Character.isWhitespace(str.charAt(i))) {
            --i;
        }
        if (i == -1) {
            return null;
        }
        return str.substring(0, i + 1);
    }

    public LightweightPerforceDecorator() {
        this.delegate = PerforceDecorator.getActivePerforceDecorator();
        this.init();
    }

    private void init() {
        this.getPreferences();
        if (this.resourceDecorator) {
            PerforceProviderPlugin.addProjectSettingsChangeListener((IProjectSettingsChangeListener)this);
        }
        P4ConnectionManager.getManager().addListener(this);
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        super.dispose();
        this.iconCache.clear();
        if (this.resourceDecorator) {
            PerforceProviderPlugin.removeProjectSettingsChangeListener((IProjectSettingsChangeListener)this);
        }
        P4ConnectionManager.getManager().removeListener(this);
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        store.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void decorate(Object element, IDecoration decoration) {
    }

    private void decorateResourceMapping(Object element, IDecoration decoration) {
        ResourceMapping mapping = Utils.getResourceMapping(element);
    }

    public static void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PerforceUIPlugin.getPlugin().getWorkbench().getDecoratorManager().update(LightweightPerforceDecorator.DECORATOR_ID);
            }
        });
    }

    private static IResource getResource(Object actElement) {
        IContributorResourceAdapter adapter;
        IAdaptable adaptable;
        Object element = actElement;
        if (element instanceof ResourceMapping) {
            element = ((ResourceMapping)element).getModelObject();
        }
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) == null && (adapter = (IContributorResourceAdapter)adaptable.getAdapter(IContributorResourceAdapter.class)) != null) {
            resource = adapter.getAdaptedResource(adaptable);
        }
        return resource;
    }

    private void postLabelEvent() {
        LabelEventJob.getInstance().postLabelEvent(this);
    }

    void fireLabelEvent() {
        final LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LightweightPerforceDecorator.this.fireLabelProviderChanged(event);
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.postLabelEvent();
    }

    public void projectSettingsChanged(IProject project, ConnectionParameters params) {
        this.postLabelEvent();
    }

    public void resoureChanged(P4Event event) {
        this.postLabelEvent();
    }

    private void getPreferences() {
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        this.decorateIgnored = store.getBoolean("pref_ignored_text");
        this.projectDecoration = store.getString("com.perforce.team.ui.preferences.PROJECT_DECORATION_TEXT");
        this.fileDecoration = store.getString("com.perforce.team.ui.preferences.FILE_DECORATION_TEXT");
        this.outgoingChangeFlag = store.getString("com.perforce.team.ui.preferences.OUTGOING_CHANGE_DECORATION");
        this.unaddedChangeFlag = store.getString("com.perforce.team.ui.preferences.UNADDED_CHANGE_DECORATION");
        this.ignoredText = store.getString("com.perforce.team.ui.preferences.IGNORED_DECORATION");
        this.showChangelists = store.getBoolean("com.perforce.team.ui.preferences.SHOW_CHANGELIST_IN_SYNC_VIEW");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

